/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.rasanovum.viaromana.ViaRomanaMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ViaRomanaModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ViaRomanaMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ViaRomanaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.PathData = message.data.PathData;
                    variables.FadeAmount = message.data.FadeAmount;
                    variables.FadeIncrease = message.data.FadeIncrease;
                    variables.LastNodeX = message.data.LastNodeX;
                    variables.LastNodeZ = message.data.LastNodeZ;
                    variables.ChartingPath = message.data.ChartingPath;
                    variables.Debug = message.data.Debug;
                    variables.LastNodeY = message.data.LastNodeY;
                    variables.RecievedTutorial = message.data.RecievedTutorial;
                    variables.ToastTimer = message.data.ToastTimer;
                    variables.LastSignPosition = message.data.LastSignPosition;
                    variables.LeftClickTimer = message.data.LeftClickTimer;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String PathData = "\"\"";
        public double FadeAmount = 0.0;
        public boolean FadeIncrease = false;
        public double LastNodeX = 0.0;
        public double LastNodeZ = 0.0;
        public boolean ChartingPath = false;
        public boolean Debug = true;
        public double LastNodeY = 0.0;
        public boolean RecievedTutorial = false;
        public double ToastTimer = 0.0;
        public String LastSignPosition = "\"\"";
        public double LeftClickTimer = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ViaRomanaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("PathData", this.PathData);
            nbt.m_128347_("FadeAmount", this.FadeAmount);
            nbt.m_128379_("FadeIncrease", this.FadeIncrease);
            nbt.m_128347_("LastNodeX", this.LastNodeX);
            nbt.m_128347_("LastNodeZ", this.LastNodeZ);
            nbt.m_128379_("ChartingPath", this.ChartingPath);
            nbt.m_128379_("Debug", this.Debug);
            nbt.m_128347_("LastNodeY", this.LastNodeY);
            nbt.m_128379_("RecievedTutorial", this.RecievedTutorial);
            nbt.m_128347_("ToastTimer", this.ToastTimer);
            nbt.m_128359_("LastSignPosition", this.LastSignPosition);
            nbt.m_128347_("LeftClickTimer", this.LeftClickTimer);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.PathData = nbt.m_128461_("PathData");
            this.FadeAmount = nbt.m_128459_("FadeAmount");
            this.FadeIncrease = nbt.m_128471_("FadeIncrease");
            this.LastNodeX = nbt.m_128459_("LastNodeX");
            this.LastNodeZ = nbt.m_128459_("LastNodeZ");
            this.ChartingPath = nbt.m_128471_("ChartingPath");
            this.Debug = nbt.m_128471_("Debug");
            this.LastNodeY = nbt.m_128459_("LastNodeY");
            this.RecievedTutorial = nbt.m_128471_("RecievedTutorial");
            this.ToastTimer = nbt.m_128459_("ToastTimer");
            this.LastSignPosition = nbt.m_128461_("LastSignPosition");
            this.LeftClickTimer = nbt.m_128459_("LeftClickTimer");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("via_romana", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "via_romana_mapvars";
        public double InfrastructureCheckRadius = 1.0;
        public double InfrastructureCheckQuality = 0.6;
        public double NodeDistanceMinimum = 10.0;
        public double NodeDistanceMaximum = 20.0;
        public double PathDistanceMinimum = 50.0;
        public double PathDistanceMaximum = 100000.0;
        public double TravelFatigueCooldown = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.InfrastructureCheckRadius = nbt.m_128459_("InfrastructureCheckRadius");
            this.InfrastructureCheckQuality = nbt.m_128459_("InfrastructureCheckQuality");
            this.NodeDistanceMinimum = nbt.m_128459_("NodeDistanceMinimum");
            this.NodeDistanceMaximum = nbt.m_128459_("NodeDistanceMaximum");
            this.PathDistanceMinimum = nbt.m_128459_("PathDistanceMinimum");
            this.PathDistanceMaximum = nbt.m_128459_("PathDistanceMaximum");
            this.TravelFatigueCooldown = nbt.m_128459_("TravelFatigueCooldown");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("InfrastructureCheckRadius", this.InfrastructureCheckRadius);
            nbt.m_128347_("InfrastructureCheckQuality", this.InfrastructureCheckQuality);
            nbt.m_128347_("NodeDistanceMinimum", this.NodeDistanceMinimum);
            nbt.m_128347_("NodeDistanceMaximum", this.NodeDistanceMaximum);
            nbt.m_128347_("PathDistanceMinimum", this.PathDistanceMinimum);
            nbt.m_128347_("PathDistanceMaximum", this.PathDistanceMaximum);
            nbt.m_128347_("TravelFatigueCooldown", this.TravelFatigueCooldown);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ViaRomanaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "via_romana_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ViaRomanaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Debug = original.Debug;
            clone.RecievedTutorial = original.RecievedTutorial;
            clone.ToastTimer = original.ToastTimer;
            clone.LeftClickTimer = original.LeftClickTimer;
            if (!event.isWasDeath()) {
                clone.PathData = original.PathData;
                clone.FadeAmount = original.FadeAmount;
                clone.FadeIncrease = original.FadeIncrease;
                clone.LastNodeX = original.LastNodeX;
                clone.LastNodeZ = original.LastNodeZ;
                clone.ChartingPath = original.ChartingPath;
                clone.LastNodeY = original.LastNodeY;
                clone.LastSignPosition = original.LastSignPosition;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ViaRomanaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ViaRomanaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ViaRomanaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

