/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneBarterGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneDisappearGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneReactToPlayerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneTargetHostilePlayersGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneWanderGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DeepOneEntity
extends DeepOneBaseEntity {
    public static final Animation ANIMATION_THROW = Animation.create((int)20);
    public static final Animation ANIMATION_BITE = Animation.create((int)8);
    public static final Animation ANIMATION_SCRATCH = Animation.create((int)22);
    public static final Animation ANIMATION_TRADE = Animation.create((int)55);
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(0.99f, 0.99f, false);
    public static final ResourceLocation BARTER_LOOT = new ResourceLocation("alexscaves", "gameplay/deep_one_barter");

    public DeepOneEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DeepOneAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DeepOneBarterGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DeepOneReactToPlayerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DeepOneDisappearGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new DeepOneWanderGoal(this, 12, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DeepOneBaseEntity.HurtByHostileTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new DeepOneTargetHostilePlayersGoal(this));
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected ResourceLocation getBarterLootTable() {
        return BARTER_LOOT;
    }

    @Override
    public void startAttackBehavior(LivingEntity target) {
        float f;
        double dist = this.m_20270_((Entity)target);
        if (dist < (double)(f = this.m_20205_() + target.m_20205_()) + 1.0 && this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_SCRATCH : ANIMATION_BITE);
            this.m_216990_((SoundEvent)ACSoundRegistry.DEEP_ONE_ATTACK.get());
        }
        if (dist > (double)(f + 4.0f)) {
            this.m_21573_().m_5624_((Entity)target, 1.3);
        }
        if (this.getAnimation() == ANIMATION_SCRATCH && (this.getAnimationTick() > 5 && this.getAnimationTick() < 9 || this.getAnimationTick() > 12 && this.getAnimationTick() < 16)) {
            this.checkAndDealMeleeDamage(target, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() > 3 && this.getAnimationTick() <= 7) {
            this.checkAndDealMeleeDamage(target, 1.0f);
        }
    }

    @Override
    public Animation getTradingAnimation() {
        return ANIMATION_TRADE;
    }

    @Override
    public SoundEvent getAdmireSound() {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_ADMIRE.get();
    }

    protected SoundEvent m_7515_() {
        return this.soundsAngry() ? (SoundEvent)ACSoundRegistry.DEEP_ONE_HOSTILE.get() : (SoundEvent)ACSoundRegistry.DEEP_ONE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_DEATH.get();
    }

    @Override
    public boolean startDisappearBehavior(Player player) {
        this.m_21563_().m_24950_(player.m_20185_(), player.m_20188_(), player.m_20189_(), 20.0f, (float)this.m_8132_());
        if (this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ACItemRegistry.INK_BOMB.get()));
        }
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_THROW);
        } else if (this.getAnimation() == ANIMATION_THROW && this.getAnimationTick() > 10) {
            if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.INK_BOMB.get())) {
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            return super.startDisappearBehavior(player);
        }
        return false;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_THROW, ANIMATION_BITE, ANIMATION_SCRATCH, ANIMATION_TRADE};
    }
}

