/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.NeodymiumNodeBlock;
import com.github.alexmodguy.alexscaves.server.block.NeodymiumPillarBlock;
import com.github.alexmodguy.alexscaves.server.level.feature.config.MagneticNodeFeatureConfiguration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class MagneticNodeFeature
extends Feature<MagneticNodeFeatureConfiguration> {
    public MagneticNodeFeature(Codec<MagneticNodeFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<MagneticNodeFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        if (MagneticNodeFeature.canReplace(level.m_8055_(pos))) {
            ArrayList<Direction> possiblities = new ArrayList<Direction>();
            for (Direction possible : Direction.values()) {
                BlockPos check = pos.m_121945_(possible);
                if (!this.isSameChunk(pos, check) || !level.m_8055_(check).m_60783_((BlockGetter)level, check, possible.m_122424_())) continue;
                possiblities.add(possible.m_122424_());
            }
            Direction direction = MagneticNodeFeature.selectDirection(possiblities, randomSource);
            if (direction != null) {
                int centerHeight = 3 + randomSource.m_188503_(3);
                MagneticNodeFeature.generatePillar(level, pos, ((MagneticNodeFeatureConfiguration)context.m_159778_()).pillarBlock, ((MagneticNodeFeatureConfiguration)context.m_159778_()).nodeBlock, direction, randomSource, centerHeight);
                int pillarSpread = 2;
                Vec3i inverseVec = new Vec3i(1, 1, 1).m_121996_(new Vec3i(Math.abs(direction.m_122429_()), Math.abs(direction.m_122430_()), Math.abs(direction.m_122431_())));
                for (int pillar = 0; pillar < 2 + randomSource.m_188503_(3); ++pillar) {
                    BlockPos genAt = pos.m_7918_((randomSource.m_188503_(pillarSpread * 2) - pillarSpread) * inverseVec.m_123341_(), (randomSource.m_188503_(pillarSpread * 2) - pillarSpread) * inverseVec.m_123342_(), (randomSource.m_188503_(pillarSpread * 2) - pillarSpread) * inverseVec.m_123343_());
                    if (genAt.m_123333_((Vec3i)pos) <= 0) continue;
                    int pillarHeight = Math.max(centerHeight - genAt.m_123333_((Vec3i)pos) - randomSource.m_188503_(2), 1) + 2;
                    MagneticNodeFeature.generatePillar(level, genAt, ((MagneticNodeFeatureConfiguration)context.m_159778_()).pillarBlock, ((MagneticNodeFeatureConfiguration)context.m_159778_()).nodeBlock, direction, randomSource, pillarHeight);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }

    private static void generatePillar(WorldGenLevel level, BlockPos pos, BlockStateProvider pillarState, BlockStateProvider nodeState, Direction facing, RandomSource randomSource, int height) {
        BlockPos begin = pos;
        int j = 0;
        while (j < 5 && MagneticNodeFeature.canReplace(level.m_8055_(begin))) {
            ++j;
            begin = begin.m_121945_(facing.m_122424_());
        }
        BlockPos stopPillarAt = pos.m_5484_(facing, height);
        while (!begin.equals((Object)stopPillarAt)) {
            Direction randomOffset;
            if (MagneticNodeFeature.canReplace(level.m_8055_(begin = begin.m_121945_(facing)))) {
                MagneticNodeFeature.placeBlock(level, begin, pillarState, facing, randomSource, false);
            }
            if (randomSource.m_188503_(3) != 0 || (randomOffset = Direction.m_235672_((RandomSource)randomSource)).m_122434_() == facing.m_122434_() || !MagneticNodeFeature.canReplace(level.m_8055_(begin.m_121945_(randomOffset)))) continue;
            BlockPos randomPos = begin.m_121945_(randomOffset);
            MagneticNodeFeature.placeBlock(level, randomPos, nodeState, randomOffset, randomSource, level.m_6425_(randomPos).m_192917_((Fluid)Fluids.f_76193_));
        }
        MagneticNodeFeature.placeBlock(level, begin, pillarState, facing, randomSource, true);
        BlockPos relative = begin.m_121945_(facing);
        if (MagneticNodeFeature.canReplace(level.m_8055_(relative))) {
            MagneticNodeFeature.placeBlock(level, relative, nodeState, facing, randomSource, level.m_6425_(relative).m_192917_((Fluid)Fluids.f_76193_));
        }
    }

    private static void placeBlock(WorldGenLevel level, BlockPos pos, BlockStateProvider blockState, Direction facing, RandomSource randomSource, boolean flag) {
        BlockState state = blockState.m_213972_(randomSource, pos);
        if (state.m_60734_() instanceof NeodymiumNodeBlock) {
            state = (BlockState)((BlockState)state.m_61124_((Property)NeodymiumNodeBlock.FACING, (Comparable)facing)).m_61124_((Property)NeodymiumNodeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        } else if (state.m_60734_() instanceof NeodymiumPillarBlock) {
            state = (BlockState)((BlockState)state.m_61124_((Property)NeodymiumPillarBlock.FACING, (Comparable)facing)).m_61124_((Property)NeodymiumPillarBlock.TOP, (Comparable)Boolean.valueOf(flag));
        }
        level.m_7731_(pos, state, 3);
    }

    private boolean isSameChunk(BlockPos pos, BlockPos check) {
        return SectionPos.m_123171_((int)pos.m_123341_()) == SectionPos.m_123171_((int)check.m_123341_()) && SectionPos.m_123171_((int)pos.m_123343_()) == SectionPos.m_123171_((int)check.m_123343_());
    }

    private static Direction selectDirection(List<Direction> directionList, RandomSource randomSource) {
        if (directionList.size() <= 0) {
            return null;
        }
        if (directionList.size() <= 1) {
            return directionList.get(0);
        }
        return directionList.get(randomSource.m_188503_(directionList.size() - 1));
    }
}

