/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ForsakenIdolBlock;
import com.github.alexmodguy.alexscaves.server.block.ThornwoodBranchBlock;
import com.github.alexmodguy.alexscaves.server.level.structure.ForlornBridgeStructure;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class ForlornBridgeStructurePiece
extends StructurePiece {
    protected final BlockPos bridgePos;
    protected final int sectionId;
    protected final int maxSections;
    protected final Direction direction;

    public ForlornBridgeStructurePiece(BlockPos bridgePos, int sectionId, int maxSections, Direction direction) {
        super((StructurePieceType)ACStructurePieceRegistry.FORLORN_BRIDGE.get(), 0, ForlornBridgeStructurePiece.createBoundingBox(bridgePos, direction));
        this.bridgePos = bridgePos;
        this.sectionId = sectionId;
        this.maxSections = maxSections;
        this.direction = direction;
    }

    public ForlornBridgeStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.FORLORN_BRIDGE.get(), tag);
        this.bridgePos = new BlockPos(tag.m_128451_("TPX"), tag.m_128451_("TPY"), tag.m_128451_("TPZ"));
        this.sectionId = tag.m_128451_("Section");
        this.maxSections = tag.m_128451_("MaxSections");
        this.direction = Direction.m_122407_((int)tag.m_128451_("Direction"));
    }

    public ForlornBridgeStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    private static BoundingBox createBoundingBox(BlockPos origin, Direction direction) {
        int i = ForlornBridgeStructure.BRIDGE_SECTION_WIDTH / 2;
        int j = ForlornBridgeStructure.BRIDGE_SECTION_LENGTH - i;
        int dirX = i + j * Math.abs(direction.m_122429_());
        int dirZ = i + j * Math.abs(direction.m_122431_());
        return new BoundingBox(origin.m_123341_() - dirX, -64, origin.m_123343_() - dirZ, origin.m_123341_() + dirX, 256, origin.m_123343_() + dirZ);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("TPX", this.bridgePos.m_123341_());
        tag.m_128405_("TPY", this.bridgePos.m_123342_());
        tag.m_128405_("TPZ", this.bridgePos.m_123343_());
        tag.m_128405_("Section", this.sectionId);
        tag.m_128405_("MaxSections", this.maxSections);
        tag.m_128405_("Direction", this.direction.m_122416_());
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        HashSet<BlockPos> supports = new HashSet<BlockPos>();
        HashSet<BlockPos> specialSupports = new HashSet<BlockPos>();
        int j = ForlornBridgeStructure.BRIDGE_SECTION_WIDTH / 2;
        for (int width = -j; width < j; ++width) {
            pos.m_122190_((Vec3i)this.bridgePos);
            pos.m_122175_(this.direction.m_122427_(), width);
            int startLength = 0;
            int endLength = ForlornBridgeStructure.BRIDGE_SECTION_LENGTH;
            if (this.sectionId == 0) {
                startLength = random.m_188503_(ForlornBridgeStructure.BRIDGE_SECTION_LENGTH - 1);
            }
            if (this.sectionId == this.maxSections) {
                endLength = random.m_188503_(ForlornBridgeStructure.BRIDGE_SECTION_LENGTH);
            }
            for (int length = startLength; length < endLength; ++length) {
                pos.m_122173_(this.direction);
                BlockState prior = this.checkedGetBlock(level, (BlockPos)pos);
                if (!prior.m_60795_() && prior.m_60819_().m_76178_()) continue;
                BlockState state = (BlockState)((Block)ACBlockRegistry.THORNWOOD_PLANKS_SLAB.get()).m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
                if (width == -j || width == j - 1) {
                    if (length % 3 == startLength) {
                        state = Blocks.f_50009_.m_49966_();
                        supports.add(pos.m_7949_());
                        if (this.sectionId == 0 && length == startLength || this.sectionId == this.maxSections && length != startLength) {
                            specialSupports.add(pos.m_7949_());
                        }
                    } else {
                        boolean left = width == j - 1;
                        state = (BlockState)((BlockState)((Block)ACBlockRegistry.THORNWOOD_PLANKS_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)(left ? this.direction.m_122428_() : this.direction.m_122427_()));
                    }
                }
                this.checkedSetBlock(level, (BlockPos)pos, state);
            }
        }
        for (BlockPos support : supports) {
            this.checkedSetBlock(level, support.m_7494_(), Blocks.f_50009_.m_49966_());
            this.checkedSetBlock(level, support.m_7494_().m_121945_(this.direction), (BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)this.direction));
            this.checkedSetBlock(level, support.m_7494_().m_121945_(this.direction.m_122424_()), (BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)this.direction.m_122424_()));
            if (specialSupports.contains(support)) {
                boolean end = this.maxSections == this.sectionId;
                this.checkedSetBlock(level, support.m_6630_(2), (BlockState)((Block)ACBlockRegistry.FORSAKEN_IDOL.get()).m_49966_().m_61124_((Property)ForsakenIdolBlock.FACING, (Comparable)(end ? this.direction : this.direction.m_122424_())));
            } else {
                this.checkedSetBlock(level, support.m_6630_(2), Blocks.f_50009_.m_49966_());
                this.checkedSetBlock(level, support.m_6630_(3), ((Block)ACBlockRegistry.THORNWOOD_PLANKS_FENCE.get()).m_49966_());
                if (random.m_188499_()) {
                    this.buildChain(level, support.m_6630_(4));
                }
            }
            if (!random.m_188499_() && this.sectionId != 0 && this.sectionId != this.maxSections) continue;
            this.buildBeam(level, support.m_7495_());
        }
    }

    private void buildBeam(WorldGenLevel level, BlockPos below) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)below);
        while (!this.checkedGetBlock(level, (BlockPos)pos).m_280296_() && pos.m_123342_() > level.m_141937_()) {
            this.checkedSetBlock(level, (BlockPos)pos, Blocks.f_50009_.m_49966_());
            pos.m_122184_(0, -1, 0);
        }
    }

    private void buildChain(WorldGenLevel level, BlockPos above) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)above);
        if (level.m_45527_((BlockPos)pos) || level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, above.m_123341_(), above.m_123343_()) >= level.m_151558_()) {
            return;
        }
        while (!this.checkedGetBlock(level, (BlockPos)pos).m_280296_() && pos.m_123342_() < level.m_151558_()) {
            this.checkedSetBlock(level, (BlockPos)pos, Blocks.f_50184_.m_49966_());
            pos.m_122184_(0, 1, 0);
        }
    }

    public void checkedSetBlock(WorldGenLevel level, BlockPos position, BlockState state) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            level.m_7731_(position, state, 128);
        }
    }

    public BlockState checkedGetBlock(WorldGenLevel level, BlockPos position) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            return level.m_8055_(position);
        }
        return Blocks.f_50626_.m_49966_();
    }
}

