/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.processor.UndergroundCabinProcessor;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class UndergroundCabinStructurePiece
extends TemplateStructurePiece {
    private ResourceKey<Biome> pickedBiome = null;

    public UndergroundCabinStructurePiece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
        super((StructurePieceType)ACStructurePieceRegistry.UNDERGROUND_CABIN.get(), 0, manager, resourceLocation, resourceLocation.toString(), UndergroundCabinStructurePiece.makeSettings(rotation), pos);
    }

    public UndergroundCabinStructurePiece(StructureTemplateManager manager, CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.UNDERGROUND_CABIN.get(), tag, manager, x -> UndergroundCabinStructurePiece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rotation"))));
    }

    public UndergroundCabinStructurePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74392_(true).m_163782_(false);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        this.pickedBiome = this.pickBiome(randomSource);
        this.f_73657_.m_74394_().m_74383_((StructureProcessor)new UndergroundCabinProcessor());
        BlockPos structureCenter = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.f_73656_.m_163801_().m_123341_() / 2, 0, this.f_73656_.m_163801_().m_123343_() / 2), (Mirror)Mirror.NONE, (Rotation)this.f_73657_.m_74404_(), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)this.f_73658_);
        BlockPos cavePos = this.getCaveHeight(structureCenter, (BlockGetter)worldGenLevel, randomSource);
        this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), cavePos.m_123342_(), this.f_73658_.m_123343_());
        BlockPos genPos = new BlockPos(pos.m_123341_(), cavePos.m_123342_(), pos.m_123343_());
        super.m_213694_(worldGenLevel, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, genPos);
    }

    private ResourceKey<Biome> pickBiome(RandomSource randomSource) {
        boolean attempts = false;
        ArrayList<ResourceKey<Biome>> biomeList = new ArrayList<ResourceKey<Biome>>(ACBiomeRegistry.ALEXS_CAVES_BIOMES);
        biomeList.removeIf(BiomeGenerationConfig::isBiomeDisabledCompletely);
        return biomeList.isEmpty() ? null : (ResourceKey)Util.m_214621_(biomeList, (RandomSource)randomSource);
    }

    private BlockPos getCaveHeight(BlockPos currentStructureCenter, BlockGetter level, RandomSource randomSource) {
        ArrayList<BlockPos> genPos = new ArrayList<BlockPos>();
        int j = 0;
        BlockPos.MutableBlockPos chunkCenter = new BlockPos.MutableBlockPos(currentStructureCenter.m_123341_(), level.m_141937_() + 3, currentStructureCenter.m_123343_());
        while (chunkCenter.m_123342_() < currentStructureCenter.m_123342_()) {
            BlockState currentState = level.m_8055_((BlockPos)chunkCenter);
            chunkCenter.m_122184_(0, 1, 0);
            BlockState nextState = level.m_8055_((BlockPos)chunkCenter);
            if (!this.canReplace(currentState, j) && this.canReplace(nextState, j + 1)) {
                genPos.add(chunkCenter.m_7949_().m_7495_());
            }
            ++j;
        }
        if (genPos.isEmpty()) {
            return currentStructureCenter;
        }
        return genPos.size() <= 1 ? (BlockPos)genPos.get(0) : (BlockPos)genPos.get(randomSource.m_188503_(genPos.size() - 1));
    }

    protected boolean canReplace(BlockState state, int already) {
        return state.m_60795_() || state.m_247087_();
    }

    protected void m_213704_(String string, BlockPos pos, ServerLevelAccessor accessor, RandomSource random, BoundingBox box) {
        accessor.m_7731_(pos, Blocks.f_50627_.m_49966_(), 0);
        switch (string) {
            case "loot_chest": {
                ResourceLocation chestLoot = this.pickedBiome == null ? BuiltInLootTables.f_78742_ : new ResourceLocation("alexscaves:chests/underground_cabin_" + this.pickedBiome.m_135782_().m_135815_());
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)accessor, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)chestLoot);
            }
        }
    }
}

