/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.misc;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class CabinMapLootModifier
implements IGlobalLootModifier {
    public static final Supplier<Codec<CabinMapLootModifier>> CODEC = () -> RecordCodecBuilder.create(inst -> inst.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions)).apply((Applicative)inst, CabinMapLootModifier::new));
    private final LootItemCondition[] conditions;
    private final Predicate<LootContext> orConditions;

    protected CabinMapLootModifier(LootItemCondition[] conditionsIn) {
        this.conditions = conditionsIn;
        this.orConditions = LootItemConditions.m_81841_((Predicate[])conditionsIn);
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return this.orConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockPos chestPos;
        ServerLevel serverlevel;
        BlockPos blockpos;
        if (context.m_230907_().m_188501_() < this.getChance() && context.m_78936_(LootContextParams.f_81460_) && (blockpos = (serverlevel = context.m_78952_()).m_215011_(ACTagRegistry.ON_UNDERGROUND_CABIN_MAPS, chestPos = BlockPos.m_274446_((Position)((Position)context.m_165124_(LootContextParams.f_81460_))), 100, true)) != null) {
            ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
            MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
            itemstack.m_41714_((Component)Component.m_237115_((String)"item.alexscaves.underground_cabin_explorer_map"));
            generatedLoot.add((Object)itemstack);
        }
        return generatedLoot;
    }

    private float getChance() {
        return ((Double)AlexsCaves.COMMON_CONFIG.cabinMapLootChance.get()).floatValue();
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

