/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.wizards;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.WarlockAttackGoal;
import io.redspace.ironsspellbooks.network.ClientboundSyncAnimation;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class GenericAnimatedWarlockAttackGoal<T extends AbstractSpellCastingMob>
extends WarlockAttackGoal {
    List<AttackAnimationData> moveList = new ArrayList<AttackAnimationData>();
    final T mob;
    int meleeAnimTimer = -1;
    @Nullable
    public AttackAnimationData currentAttack;
    @Nullable
    public AttackAnimationData nextAttack = this.randomizeNextAttack(0.0f);
    @Nullable
    public AttackAnimationData queueCombo;
    float comboChance = 0.3f;

    public GenericAnimatedWarlockAttackGoal(T abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval, float meleeRange) {
        super((AbstractSpellCastingMob)abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval, meleeRange);
        this.wantsToMelee = true;
        this.mob = abstractSpellCastingMob;
    }

    @Override
    protected void handleAttackLogic(double distanceSquared) {
        if (this.meleeAnimTimer < 0 && (!this.wantsToMelee || distanceSquared > (double)(this.meleeRange * this.meleeRange) || ((AbstractSpellCastingMob)this.mob).isCasting())) {
            super.handleAttackLogic(distanceSquared);
            return;
        }
        this.mob.m_21563_().m_148051_((Entity)this.target);
        if (this.meleeAnimTimer > 0) {
            this.forceFaceTarget();
            --this.meleeAnimTimer;
            if (this.currentAttack.isHitFrame(this.meleeAnimTimer)) {
                this.playSwingSound();
                Vec3 lunge = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_((double)0.45f);
                this.mob.m_5997_(lunge.f_82479_, lunge.f_82480_, lunge.f_82481_);
                if (distanceSquared <= (double)(this.meleeRange * this.meleeRange)) {
                    boolean flag = this.mob.m_7327_((Entity)this.target);
                    this.target.f_19802_ = 0;
                    if (flag && this.currentAttack.isSingleHit()) {
                        float f = this.mob.m_217043_().m_188501_();
                        int n = this.target.m_21254_() ? 2 : 1;
                        if (f < this.comboChance * (float)n) {
                            this.queueCombo = this.randomizeNextAttack(0.0f);
                        }
                    }
                }
            }
        } else if (this.queueCombo != null && this.target != null && !this.target.m_21224_()) {
            this.nextAttack = this.queueCombo;
            this.queueCombo = null;
            this.doMeleeAction();
        } else if (this.meleeAnimTimer == 0) {
            this.nextAttack = this.randomizeNextAttack((float)distanceSquared);
            this.resetAttackTimer(distanceSquared);
            this.meleeAnimTimer = -1;
        } else if (distanceSquared < (double)(this.meleeRange * this.meleeRange) * 1.2 * 1.2) {
            if (--this.attackTime == 0) {
                this.doMeleeAction();
            } else if (this.attackTime < 0) {
                this.resetAttackTimer(distanceSquared);
            }
        }
    }

    private AttackAnimationData randomizeNextAttack(float distanceSquared) {
        if (this.moveList.isEmpty()) {
            return null;
        }
        return this.moveList.get(this.mob.m_217043_().m_188503_(this.moveList.size()));
    }

    private void forceFaceTarget() {
        double d0 = this.target.m_20185_() - this.mob.m_20185_();
        double d1 = this.target.m_20189_() - this.mob.m_20189_();
        float yRot = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
        this.mob.m_5618_(yRot);
        this.mob.m_5616_(yRot);
        this.mob.m_146922_(yRot);
    }

    @Override
    protected void doMeleeAction() {
        this.currentAttack = this.nextAttack;
        if (this.currentAttack != null) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.meleeAnimTimer = this.currentAttack.lengthInTicks;
            Messages.sendToPlayersTrackingEntity(new ClientboundSyncAnimation<T>(this.currentAttack.animationId, this.mob), this.mob);
        }
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() || this.meleeAnimTimer > 0;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.meleeAnimTimer = -1;
        this.queueCombo = null;
    }

    public void playSwingSound() {
        this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, (float)Mth.m_216287_((RandomSource)this.mob.m_217043_(), (int)12, (int)18) * 0.1f);
    }

    public GenericAnimatedWarlockAttackGoal<T> setMoveset(List<AttackAnimationData> moveset) {
        this.moveList = moveset;
        this.nextAttack = this.randomizeNextAttack(0.0f);
        return this;
    }

    public GenericAnimatedWarlockAttackGoal<T> setComboChance(float comboChance) {
        this.comboChance = comboChance;
        return this;
    }
}

