/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.target_area;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.render.SpellRenderingHelper;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TargetAreaRenderer
extends EntityRenderer<TargetedAreaEntity> {
    public TargetAreaRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(TargetedAreaEntity pEntity) {
        return null;
    }

    public void render(TargetedAreaEntity entity, float pEntityYaw, float pPartialTick, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        int i;
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)SpellRenderingHelper.SOLID, (float)0.0f, (float)0.0f));
        Vector3f color = entity.getColor();
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        float radius = entity.getRadius();
        int segments = (int)(5.0f * radius + 9.0f);
        float angle = (float)Math.PI * 2 / (float)segments;
        float entityY = (float)Mth.m_14139_((double)pPartialTick, (double)entity.f_19791_, (double)entity.m_20186_());
        float[] heights = new float[6];
        for (i = 0; i < 6; ++i) {
            int degrees = i * 60;
            float x = radius * Mth.m_14089_((float)((float)degrees * ((float)Math.PI / 180)));
            float z = radius * Mth.m_14031_((float)((float)degrees * ((float)Math.PI / 180)));
            heights[i] = (float)Utils.findRelativeGroundLevel(entity.f_19853_, entity.m_20182_().m_82520_((double)x, (double)entity.m_20206_(), (double)z), (int)(entity.m_20206_() * 4.0f)) - entityY;
        }
        for (i = 0; i < segments; ++i) {
            float theta = angle * (float)i;
            float theta2 = angle * (float)(i + 1);
            float x1 = radius * Mth.m_14089_((float)theta);
            float x2 = radius * Mth.m_14089_((float)theta2);
            float z1 = radius * Mth.m_14031_((float)theta);
            float z2 = radius * Mth.m_14031_((float)theta2);
            int degrees = (int)(theta * 57.295776f);
            int degrees2 = (int)(theta2 * 57.295776f);
            int j = degrees / 60 % 6;
            float heightMin = heights[j];
            float heightMax = heights[(j + 1) % 6];
            float f = theta * 57.295776f % 60.0f / 60.0f;
            float f2 = theta2 * 57.295776f % 60.0f / 60.0f;
            float y1 = Mth.m_14179_((float)f, (float)heightMin, (float)heightMax);
            if (f2 < f) {
                heightMin = heightMax;
                heightMax = heights[(j + 2) % 6];
            }
            float y2 = Mth.m_14179_((float)f2, (float)heightMin, (float)heightMax);
            consumer.m_252986_(poseMatrix, x2, y2 - 0.6f, z2).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(poseMatrix, x2, y2 + 0.6f, z2).m_6122_(0, 0, 0, 1).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(poseMatrix, x1, y1 + 0.6f, z1).m_6122_(0, 0, 0, 1).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(poseMatrix, x1, y1 - 0.6f, z1).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        }
        poseStack.m_85849_();
    }

    private ParticleOptions particle(int i) {
        return switch (i) {
            case 0 -> ParticleHelper.SNOWFLAKE;
            case 1 -> ParticleHelper.UNSTABLE_ENDER;
            case 2 -> ParticleHelper.ACID_BUBBLE;
            case 3 -> ParticleHelper.BLOOD;
            case 4 -> ParticleHelper.WISP;
            case 5 -> ParticleHelper.ELECTRIC_SPARKS;
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
    }
}

