/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.attribute.IMagicAttribute;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.AscensionEffect;
import io.redspace.ironsspellbooks.effect.CustomDescriptionMobEffect;
import io.redspace.ironsspellbooks.effect.guiding_bolt.GuidingBoltManager;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingMusicManager;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.weapons.IMultihandWeapon;
import io.redspace.ironsspellbooks.network.ServerboundCancelCast;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.player.SpinAttackType;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.render.SpellRenderingHelper;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import io.redspace.ironsspellbooks.spells.ender.RecallSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientPlayerEvents {
    @SubscribeEvent
    public static void onPlayerLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        IronsSpellbooks.LOGGER.debug("ClientPlayerNetworkEvent onPlayerLogOut");
        DeadKingMusicManager.hardStop();
        GuidingBoltManager.handleClientLogout();
        ClientMagicData.spellSelectionManager = null;
        if (event.getPlayer() != null) {
            ClientMagicData.resetClientCastState(event.getPlayer().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenScreen(ScreenEvent.Opening event) {
        if (ClientMagicData.isCasting()) {
            Messages.sendToServer(new ServerboundCancelCast(true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() && event.phase == TickEvent.Phase.END && event.player == Minecraft.m_91087_().f_91074_) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ClientMagicData.getRecasts().tickRecasts();
            ClientMagicData.getCooldowns().tick(1);
            if (ClientMagicData.getCastDuration() > 0) {
                ClientMagicData.handleCastDuration();
            }
            if (level != null) {
                List spellcasters = level.m_6249_((Entity)null, event.player.m_20191_().m_82400_(64.0), mob -> mob instanceof Player || mob instanceof AbstractSpellCastingMob);
                spellcasters.forEach(entity -> {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    SyncedSpellData spellData = ClientMagicData.getSyncedSpellData(livingEntity);
                    if (spellData.hasEffect(8L)) {
                        AbyssalShroudEffect.ambientParticles(level, livingEntity);
                    }
                    if (spellData.hasEffect(16L)) {
                        AscensionEffect.ambientParticles(level, livingEntity);
                    }
                    if (livingEntity.m_21209_() && spellData.getSpinAttackType() == SpinAttackType.FIRE) {
                        BurningDashSpell.ambientParticles(level, livingEntity);
                    }
                    if (spellData.isCasting()) {
                        if (spellData.getCastingSpellId().equals(((AbstractSpell)SpellRegistry.RAY_OF_SIPHONING_SPELL.get()).getSpellId())) {
                            Vec3 impact = Utils.raycastForEntity(entity.f_19853_, entity, RayOfSiphoningSpell.getRange(0), true).m_82450_().m_82492_(0.0, 0.25, 0.0);
                            for (int i = 0; i < 8; ++i) {
                                Vec3 motion = new Vec3(Utils.getRandomScaled(0.2f), Utils.getRandomScaled(0.2f), Utils.getRandomScaled(0.2f));
                                entity.f_19853_.m_7106_(ParticleHelper.SIPHON, impact.f_82479_ + motion.f_82479_, impact.f_82480_ + motion.f_82480_, impact.f_82481_ + motion.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                            }
                        } else if (spellData.getCastingSpellId().equals(((AbstractSpell)SpellRegistry.RECALL_SPELL.get()).getSpellId())) {
                            RecallSpell.ambientParticles(livingEntity, spellData);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof LocalPlayer) {
            LocalPlayer player2 = (LocalPlayer)player;
            ClientMagicData.spellSelectionManager = new SpellSelectionManager((Player)player2);
        }
    }

    @SubscribeEvent
    public static void beforeLivingRender(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        SyncedSpellData syncedData;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if ((livingEntity instanceof Player || livingEntity instanceof AbstractSpellCastingMob) && (syncedData = ClientMagicData.getSyncedSpellData(livingEntity)).hasEffect(32L) && livingEntity.m_20177_((Player)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void afterLivingRender(RenderLivingEvent.Post<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        SyncedSpellData syncedData;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (syncedData = ClientMagicData.getSyncedSpellData(livingEntity)).isCasting()) {
            SpellRenderingHelper.renderSpellHelper(syncedData, livingEntity, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void imbuedWeaponTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof Scroll) {
            return;
        }
        MinecraftInstanceHelper.ifPlayerPresent(player1 -> {
            LocalPlayer player = (LocalPlayer)player1;
            List lines = event.getToolTip();
            boolean advanced = event.getFlags().m_7050_();
            if (stack.m_41720_() instanceof CastingItem) {
                ClientPlayerEvents.handleCastingImplementTooltip(stack, player, lines, advanced);
            }
            if (ISpellContainer.isSpellContainer(stack) && !(stack.m_41720_() instanceof SpellBook)) {
                ClientPlayerEvents.handleImbuedSpellTooltip(stack, player, lines, advanced);
            }
            if (ISpellContainer.isSpellContainer(stack) && Utils.canImbue(stack)) {
                ISpellContainer spellContainer = ISpellContainer.get(stack);
                lines.add(1, Component.m_237110_((String)"tooltip.irons_spellbooks.can_be_imbued_frame", (Object[])new Object[]{Component.m_237110_((String)"tooltip.irons_spellbooks.can_be_imbued_number", (Object[])new Object[]{spellContainer.getActiveSpellCount(), spellContainer.getMaxSpellCount()}).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD));
            }
            if (stack.m_41720_() instanceof IMultihandWeapon) {
                if (((Boolean)ServerConfigs.APPLY_ALL_MULTIHAND_ATTRIBUTES.get()).booleanValue()) {
                    int i = TooltipsUtils.indexOfComponent(lines, "item.modifiers.mainhand");
                    if (i >= 0) {
                        lines.set(i, Component.m_237115_((String)"tooltip.irons_spellbooks.modifiers.multihand").m_130948_(((Component)lines.get(i)).m_7383_()));
                    }
                } else {
                    int i = TooltipsUtils.indexOfComponent(lines, "item.modifiers.mainhand");
                    if (i >= 0) {
                        int endIndex = 0;
                        ArrayList<Integer> linesToGrab = new ArrayList<Integer>();
                        for (int j = i; j < lines.size(); ++j) {
                            ComponentContents contents = ((Component)lines.get(j)).m_214077_();
                            if (contents instanceof TranslatableContents) {
                                TranslatableContents translatableContents = (TranslatableContents)contents;
                                if (translatableContents.m_237508_().startsWith("attribute.modifier")) {
                                    endIndex = j;
                                    for (Object arg : translatableContents.m_237523_()) {
                                        TranslatableContents translatableContents2;
                                        Component component;
                                        ComponentContents patt12157$temp;
                                        if (!(arg instanceof Component) || !((patt12157$temp = (component = (Component)arg).m_214077_()) instanceof TranslatableContents) || !(ClientPlayerEvents.getAttributeForDescriptionId((translatableContents2 = (TranslatableContents)patt12157$temp).m_237508_()) instanceof IMagicAttribute)) continue;
                                        linesToGrab.add(j);
                                    }
                                    continue;
                                }
                                if (i == j || !translatableContents.m_237508_().startsWith("item.modifiers")) continue;
                                break;
                            }
                            for (Component line : ((Component)lines.get(j)).m_7360_()) {
                                TranslatableContents translatableContents;
                                ComponentContents patt13280$temp = line.m_214077_();
                                if (!(patt13280$temp instanceof TranslatableContents) || !(translatableContents = (TranslatableContents)patt13280$temp).m_237508_().startsWith("attribute.modifier")) continue;
                                endIndex = j;
                            }
                        }
                        if (!linesToGrab.isEmpty()) {
                            lines.add(++endIndex, Component.m_237119_());
                            lines.add(++endIndex, Component.m_237115_((String)"tooltip.irons_spellbooks.modifiers.multihand").m_130948_(((Component)lines.get(i)).m_7383_()));
                            for (Integer index : linesToGrab) {
                                lines.add(++endIndex, (Component)lines.get(index));
                            }
                            for (int j = linesToGrab.size() - 1; j >= 0; --j) {
                                lines.remove((Integer)linesToGrab.get(j));
                            }
                        }
                    }
                }
            }
        });
    }

    private static void handleImbuedSpellTooltip(ItemStack stack, LocalPlayer player, List<Component> lines, boolean advanced) {
        int i;
        ISpellContainer spellContainer = ISpellContainer.get(stack);
        int n = i = advanced ? TooltipsUtils.indexOfAdvancedText(lines, stack) : lines.size();
        if (!spellContainer.isEmpty()) {
            ArrayList<MutableComponent> additionalLines = new ArrayList<MutableComponent>();
            spellContainer.getActiveSpells().forEach(spellSlot -> {
                List<MutableComponent> spellTooltip = TooltipsUtils.formatActiveSpellTooltip(stack, spellSlot, CastSource.SWORD, player);
                spellTooltip.set(1, Component.m_237113_((String)" ").m_7220_((Component)spellTooltip.get(1)));
                additionalLines.addAll(spellTooltip);
            });
            additionalLines.add(1, Component.m_237115_((String)"tooltip.irons_spellbooks.imbued_tooltip").m_130940_(ChatFormatting.GRAY));
            lines.addAll(i < 0 ? lines.size() : i, additionalLines);
        }
    }

    private static void handleCastingImplementTooltip(ItemStack stack, LocalPlayer player, List<Component> lines, boolean advanced) {
        SpellData spellSlot = ClientMagicData.getSpellSelectionManager().getSelectedSpellData();
        if (spellSlot != SpellData.EMPTY) {
            List<MutableComponent> additionalLines = TooltipsUtils.formatActiveSpellTooltip(stack, spellSlot, CastSource.SWORD, player);
            additionalLines.add(1, Component.m_237115_((String)"tooltip.irons_spellbooks.casting_implement_tooltip").m_130940_(ChatFormatting.GRAY));
            additionalLines.set(2, Component.m_237113_((String)" ").m_7220_((Component)additionalLines.get(2)));
            additionalLines.add(Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.press_to_cast_active", (Object[])new Object[]{Component.m_237117_((String)"key.use")}).m_130940_(ChatFormatting.GOLD)));
            int i = advanced ? TooltipsUtils.indexOfAdvancedText(lines, stack) : lines.size();
            lines.addAll(i < 0 ? lines.size() : i, additionalLines);
        }
    }

    private static Attribute getAttributeForDescriptionId(String descriptionId) {
        return ForgeRegistries.ATTRIBUTES.getValues().stream().filter(attribute -> attribute.m_22087_().equals(descriptionId)).findFirst().orElse(null);
    }

    @SubscribeEvent
    public static void customPotionTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List mobEffects = PotionUtils.m_43547_((ItemStack)stack);
        if (mobEffects.size() > 0) {
            for (MobEffectInstance mobEffectInstance : mobEffects) {
                MobEffect mobEffect = mobEffectInstance.m_19544_();
                if (!(mobEffect instanceof CustomDescriptionMobEffect)) continue;
                CustomDescriptionMobEffect customDescriptionMobEffect = (CustomDescriptionMobEffect)mobEffect;
                CustomDescriptionMobEffect.handleCustomPotionTooltip(stack, event.getToolTip(), event.getFlags().m_7050_(), mobEffectInstance, customDescriptionMobEffect);
            }
        }
    }

    @SubscribeEvent
    public static void changeFogColor(ViewportEvent.ComputeFogColor event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)MobEffectRegistry.PLANAR_SIGHT.get())) {
            int color = ((MobEffect)MobEffectRegistry.PLANAR_SIGHT.get()).m_19484_();
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            event.setRed((f += (float)(color >> 16 & 0xFF) / 255.0f) * 0.15f);
            event.setGreen((f1 += (float)(color >> 8 & 0xFF) / 255.0f) * 0.15f);
            event.setBlue((f2 += (float)(color >> 0 & 0xFF) / 255.0f) * 0.15f);
        }
    }
}

