/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;

public final class SafeIngredientUtil {
    private static final Cache<ITypedIngredient<?>, Boolean> CRASHING_INGREDIENT_RENDER_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final Cache<ITypedIngredient<?>, Boolean> CRASHING_INGREDIENT_TOOLTIP_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();

    private SafeIngredientUtil() {
    }

    public static <T> List<Component> getTooltip(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        Minecraft minecraft = Minecraft.m_91087_();
        TooltipFlag.Default tooltipFlag = minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        return SafeIngredientUtil.getTooltip(ingredientManager, ingredientRenderer, typedIngredient, tooltipFlag);
    }

    public static <T> List<Component> getTooltip(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, TooltipFlag.Default tooltipFlag) {
        if (CRASHING_INGREDIENT_TOOLTIP_CACHE.getIfPresent(typedIngredient) == Boolean.TRUE) {
            return SafeIngredientUtil.getTooltipErrorTooltip();
        }
        T ingredient = typedIngredient.getIngredient();
        try {
            List<Component> tooltip = ingredientRenderer.getTooltip(ingredient, (TooltipFlag)tooltipFlag);
            ArrayList<Component> tooltipCopy = new ArrayList<Component>(tooltip);
            if (CRASHING_INGREDIENT_RENDER_CACHE.getIfPresent(typedIngredient) == Boolean.TRUE) {
                tooltipCopy.addAll(SafeIngredientUtil.getRenderErrorTooltip());
            }
            return tooltipCopy;
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIP_CACHE.put(typedIngredient, (Object)Boolean.TRUE);
            ErrorUtil.logIngredientCrash(e, "Caught an error getting an Ingredient's tooltip", ingredientManager, typedIngredient);
            return SafeIngredientUtil.getTooltipErrorTooltip();
        }
    }

    private static List<Component> getTooltipErrorTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.crash");
        list.add((Component)crash.m_130940_(ChatFormatting.RED));
        return list;
    }

    private static List<Component> getRenderErrorTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.render.crash");
        list.add((Component)crash.m_130940_(ChatFormatting.RED));
        return list;
    }

    public static <T> void render(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, GuiGraphics guiGraphics, ITypedIngredient<T> typedIngredient) {
        if (CRASHING_INGREDIENT_RENDER_CACHE.getIfPresent(typedIngredient) == Boolean.TRUE) {
            SafeIngredientUtil.renderError(guiGraphics);
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        try {
            ingredientRenderer.render(guiGraphics, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDER_CACHE.put(typedIngredient, (Object)Boolean.TRUE);
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                ErrorUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, typedIngredient);
                SafeIngredientUtil.renderError(guiGraphics);
            }
            CrashReport crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, typedIngredient);
            throw new ReportedException(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        guiGraphics.m_280056_(font, "ERR", 0, 0, -65536, false);
        guiGraphics.m_280056_(font, "OR", 0, 8, -65536, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

