/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class OutputSlotTooltipCallback
implements IRecipeSlotTooltipCallback {
    private final ResourceLocation recipeName;
    private final IModIdHelper modIdHelper;
    private final IIngredientManager ingredientManager;

    public OutputSlotTooltipCallback(ResourceLocation recipeName, IModIdHelper modIdHelper, IIngredientManager ingredientManager) {
        this.recipeName = recipeName;
        this.modIdHelper = modIdHelper;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
        boolean showAdvanced;
        if (recipeSlotView.getRole() != RecipeIngredientRole.OUTPUT) {
            return;
        }
        Optional<ITypedIngredient<?>> displayedIngredient = recipeSlotView.getDisplayedIngredient();
        if (displayedIngredient.isEmpty()) {
            return;
        }
        if (this.modIdHelper.isDisplayingModNameEnabled()) {
            String ingredientModId;
            ResourceLocation ingredientName = this.getResourceLocation(displayedIngredient.get());
            String recipeModId = this.recipeName.m_135827_();
            if (!recipeModId.equals(ingredientModId = ingredientName.m_135827_())) {
                String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                MutableComponent recipeBy = Component.m_237110_((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
                tooltip.add((Component)recipeBy.m_130940_(ChatFormatting.GRAY));
            }
        }
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = showAdvanced = minecraft.f_91066_.f_92125_ || Screen.m_96638_();
        if (showAdvanced) {
            MutableComponent recipeId = Component.m_237110_((String)"jei.tooltip.recipe.id", (Object[])new Object[]{this.recipeName.toString()});
            tooltip.add((Component)recipeId.m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private <T> ResourceLocation getResourceLocation(ITypedIngredient<T> ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient.getType());
        return ingredientHelper.getResourceLocation(ingredient.getIngredient());
    }
}

