/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.test;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.test.data.RequestedItemTests;
import io.github.mortuusars.wares.test.data.agreement.AgreementTest;
import io.github.mortuusars.wares.test.framework.Test;
import io.github.mortuusars.wares.test.framework.TestResult;
import io.github.mortuusars.wares.test.framework.TestingResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;

public class Tests {
    private final ServerPlayer player;

    public Tests(ServerPlayer player) {
        this.player = player;
    }

    public TestingResult run() {
        Wares.LOGGER.info("RUNNING TESTS");
        Pair<List<TestResult>, List<TestResult>> ran = this.run(new AgreementTest().collect(), new RequestedItemTests().collect());
        List<TestResult> skipped = this.skip(new List[0]);
        TestingResult testingResult = new TestingResult((List)ran.getFirst(), (List)ran.getSecond(), skipped);
        Wares.LOGGER.info(String.join((CharSequence)"", new CharSequence[]{"TESTS COMPLETED!\n", testingResult.getTotalTestCount() + " test(s) were conducted.", testingResult.passed().size() > 0 ? "\nPassed:\n" + testingResult.passed().stream().map(TestResult::toString).collect(Collectors.joining("\n")) : "", testingResult.failed().size() > 0 ? "\nFailed:\n" + testingResult.failed().stream().map(TestResult::toString).collect(Collectors.joining("\n")) : "", testingResult.skipped().size() > 0 ? "\nSkipped:\n" + testingResult.skipped().stream().map(TestResult::toString).collect(Collectors.joining("\n")) : ""}));
        return testingResult;
    }

    @SafeVarargs
    private Pair<List<TestResult>, List<TestResult>> run(List<Test> ... tests) {
        ArrayList<TestResult> passed = new ArrayList<TestResult>();
        ArrayList<TestResult> failed = new ArrayList<TestResult>();
        for (List<Test> list : tests) {
            for (Test test : list) {
                TestResult testResult = this.runTest(test);
                if (testResult.status() == TestResult.Status.PASSED) {
                    passed.add(testResult);
                    continue;
                }
                failed.add(testResult);
            }
        }
        return Pair.of(passed, failed);
    }

    @SafeVarargs
    private List<TestResult> skip(List<Test> ... tests) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (List<Test> list : tests) {
            for (Test test : list) {
                results.add(TestResult.skip(test.name));
            }
        }
        return results;
    }

    private TestResult runTest(Test test) {
        try {
            test.test.accept(this.player);
            return TestResult.pass(test.name);
        }
        catch (Exception e) {
            return TestResult.error(test.name, e.toString());
        }
    }
}

