/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.block.entity;

import de.cristelknight.doapi.common.world.ImplementedInventory;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfy.beachparty.client.gui.handler.TikiBarGuiHandler;
import satisfy.beachparty.recipe.TikiBarRecipe;
import satisfy.beachparty.registry.BlockEntityRegistry;
import satisfy.beachparty.registry.RecipeRegistry;

public class TikiBarBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<TikiBarBlockEntity>,
MenuProvider {
    private static final int[] SLOTS_FOR_SIDE = new int[]{2};
    private static final int[] SLOTS_FOR_UP = new int[]{1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 3;
    private static final int OUTPUT_SLOT = 0;
    private int shakingTime = 0;
    private int totalShakingTime;
    protected float experience;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TikiBarBlockEntity.this.shakingTime;
                case 1 -> TikiBarBlockEntity.this.totalShakingTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TikiBarBlockEntity.this.shakingTime = value;
                    break;
                }
                case 1: {
                    TikiBarBlockEntity.this.totalShakingTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public TikiBarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TIKI_BAR_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    public void dropExperience(ServerLevel world, Vec3 pos) {
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)pos, (int)((int)this.experience));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.shakingTime = nbt.m_128448_("ShakingTime");
        this.experience = nbt.m_128457_("Experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128350_("Experience", this.experience);
        nbt.m_128376_("ShakingTime", (short)this.shakingTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, TikiBarBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
        boolean dirty = false;
        TikiBarRecipe recipeType = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.TIKI_BAR_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        assert (this.f_58857_ != null);
        RegistryAccess access = this.f_58857_.m_9598_();
        if (this.canCraft(recipeType, access)) {
            ++this.shakingTime;
            if (this.shakingTime == this.totalShakingTime) {
                this.shakingTime = 0;
                this.craft(recipeType, access);
                dirty = true;
            }
        } else {
            this.shakingTime = 0;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean canCraft(TikiBarRecipe recipe, RegistryAccess access) {
        if (recipe == null) {
            return false;
        }
        ItemStack recipeResultItem = recipe.m_8043_(access);
        if (recipeResultItem.m_41619_() || this.areInputsEmpty()) {
            return false;
        }
        ItemStack outputSlotItem = this.m_8020_(0);
        if (outputSlotItem.m_41619_()) {
            return true;
        }
        return ItemStack.m_41656_((ItemStack)outputSlotItem, (ItemStack)recipeResultItem) && outputSlotItem.m_41613_() + recipeResultItem.m_41613_() <= outputSlotItem.m_41741_();
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(TikiBarRecipe recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access).m_41777_();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput);
        } else if (ItemStack.m_41656_((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
            if (outputSlotStack.m_41613_() > outputSlotStack.m_41741_()) {
                outputSlotStack.m_41764_(outputSlotStack.m_41741_());
            }
        }
        this.consumeIngredients(recipe);
    }

    private void consumeIngredients(TikiBarRecipe recipe) {
        block0: for (Ingredient ingredient : recipe.m_7527_()) {
            for (int i = 1; i <= 2; ++i) {
                ItemStack slotItem = this.m_8020_(i);
                if (!ingredient.test(slotItem)) continue;
                ItemStack remainder = this.getRemainderItem(slotItem);
                slotItem.m_41774_(1);
                if (slotItem.m_41619_() && !remainder.m_41619_()) {
                    this.m_6836_(i, remainder);
                    continue block0;
                }
                if (!slotItem.m_41619_()) continue block0;
                this.m_6836_(i, ItemStack.f_41583_);
                continue block0;
            }
        }
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public int @NotNull [] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.totalShakingTime = 50;
            this.shakingTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new TikiBarGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

