/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.SporeRecreatorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SporesRecreatorTile
extends IndustrialProcessingTile<SporesRecreatorTile> {
    private int getPowerPerTick;
    @Save
    private SidedFluidTankComponent<SporesRecreatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("water", SporeRecreatorConfig.maxWaterTankSize, 31, 20, 0).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_) || fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_));
    @Save
    private SidedInventoryComponent<SporesRecreatorTile> input;
    @Save
    private SidedInventoryComponent<SporesRecreatorTile> output;

    public SporesRecreatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.SPORES_RECREATOR, 79, 40, blockPos, blockState);
        this.addTank(this.tank);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 53, 22, 3, 1).setColor(DyeColor.BLUE).setRange(1, 3).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> stack.m_204117_(Tags.Items.MUSHROOMS) || stack.m_41720_().equals(Items.f_41954_) || stack.m_41720_().equals(Items.f_41955_)).setOutputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.input);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 110, 22, 9, 2).setColor(DyeColor.ORANGE).setRange(3, 3).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
        this.getPowerPerTick = SporeRecreatorConfig.powerPerTick;
    }

    @Override
    public boolean canIncrease() {
        return !ItemHandlerUtil.getFirstItem(this.input).m_41619_() && this.tank.getFluidAmount() >= 100 && (ItemHandlerUtil.getFirstItem(this.input).m_204117_(Tags.Items.MUSHROOMS) ? this.tank.getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) : this.tank.getFluid().getFluid().m_6212_((Fluid)Fluids.f_76195_)) && ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((ItemLike)ItemHandlerUtil.getFirstItem(this.input).m_41720_(), 2), (boolean)true).m_41619_();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack outputStack = new ItemStack((ItemLike)ItemHandlerUtil.getFirstItem(this.input).m_41720_(), 2);
            this.tank.drainForced(100, IFluidHandler.FluidAction.EXECUTE);
            ItemHandlerUtil.getFirstItem(this.input).m_41774_(1);
            ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
        };
    }

    protected EnergyStorageComponent<SporesRecreatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(SporeRecreatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public SporesRecreatorTile getSelf() {
        return this;
    }
}

