/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.explosion.ExplosionTickHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ExplosionHelper {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private final ServerLevel serverWorld;
    public LinkedList<HashSet<Long>> toRemove = new LinkedList();
    private BlockPos start;
    private HashSet<Long> blocksToUpdate = new HashSet();
    private HashSet<Long> lightUpdates = new HashSet();
    private HashSet<Long> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap();

    public ExplosionHelper(ServerLevel serverWorld, BlockPos start) {
        this.serverWorld = serverWorld;
        this.start = start;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Long>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Long> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private LevelChunk removeBlock(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        BlockState oldState = chunk.m_8055_(pos);
        if (oldState.m_60734_() instanceof EntityBlock) {
            this.serverWorld.m_7471_(pos, false);
            this.serverWorld.m_5518_().m_7174_(pos);
            return chunk;
        }
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage != null) {
            storage.m_62986_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF, AIR);
        }
        this.setChunkModified(pos);
        this.serverWorld.m_5518_().m_7174_(pos);
        return chunk;
    }

    public void setChunkModified(BlockPos blockPos) {
        LevelChunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(LevelChunk chunk) {
    }

    private LevelChunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private LevelChunkSection getBlockStorage(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        return chunk.m_7103_()[pos.m_123342_() - this.serverWorld.m_141937_() >> 4];
    }

    public void finish() {
        IndustrialForegoing.LOGGER.debug("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ExplosionTickHandler.removalProcessList.add(process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.m_46859_(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return storage.m_62982_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
    }

    public static class RemovalProcess {
        public boolean isDead = false;
        int index = 0;
        private ExplosionHelper helper;
        private MinecraftServer server;
        private int blocksToUpdatePointer = 0;
        private List<Long> blocksToRmv = new ArrayList<Long>();
        private long start;

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.m_7654_();
            this.start = System.currentTimeMillis();
        }

        public void updateProcess() {
            long startTime = Util.m_137550_();
            HashSet<LevelChunk> chunks = new HashSet<LevelChunk>();
            while (Util.m_137550_() - startTime < 40L && this.helper.toRemove.size() > 0) {
                IndustrialForegoing.LOGGER.debug("Processing chunks at rad: " + this.index);
                HashSet<Long> set = this.helper.toRemove.removeFirst();
                for (long pos : set) {
                    BlockPos blockPos = BlockPos.m_122022_((long)pos);
                    if (!BlockUtils.canBlockBeBrokenPlugin((Level)this.helper.serverWorld, blockPos)) continue;
                    chunks.add(this.helper.removeBlock(blockPos));
                }
                ++this.index;
            }
            this.finishChunks(chunks);
            if (this.helper.toRemove.isEmpty()) {
                if (this.blocksToRmv.isEmpty()) {
                    this.blocksToRmv = new ArrayList<Long>(this.helper.blocksToUpdate);
                }
                if (this.blocksToUpdatePointer < this.helper.blocksToUpdate.size()) {
                    this.updateBlocks();
                } else {
                    IndustrialForegoing.LOGGER.info("Explosion Completed in " + (System.currentTimeMillis() - this.start) / 1000L + "s");
                    this.isDead = true;
                    IndustrialForegoing.LOGGER.info("Explosion done");
                }
            }
        }

        public void finishChunks(HashSet<LevelChunk> chunks) {
            for (LevelChunk chunk : chunks) {
                chunk.m_8092_(true);
                ThreadedLevelLightEngine lightManager = (ThreadedLevelLightEngine)this.helper.serverWorld.m_5518_();
                lightManager.m_9353_((ChunkAccess)chunk, false).thenRun(() -> this.helper.serverWorld.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_9829_((Packet)new ClientboundLightUpdatePacket(chunk.m_7697_(), this.helper.serverWorld.m_5518_(), null, null))));
                this.helper.serverWorld.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_9829_((Packet)new ClientboundLevelChunkWithLightPacket(chunk, (LevelLightEngine)lightManager, null, null)));
            }
        }

        private void updateBlocks() {
            IndustrialForegoing.LOGGER.debug("Updating Blocks");
            int amount = 1000;
            for (int i = 0; i < amount; ++i) {
                if (this.blocksToUpdatePointer + i >= this.helper.blocksToUpdate.size()) continue;
                try {
                    long pos = this.blocksToRmv.get(this.blocksToUpdatePointer + i);
                    BlockPos blockPos = BlockPos.m_122022_((long)pos);
                    BlockState state = this.helper.serverWorld.m_8055_(blockPos);
                    if (state.m_60734_() instanceof FallingBlock) {
                        state.m_60734_().m_213897_(state, this.helper.serverWorld, blockPos, this.helper.serverWorld.f_46441_);
                    }
                    state.m_60690_((Level)this.helper.serverWorld, blockPos, Blocks.f_50016_, blockPos.m_7494_(), false);
                    continue;
                }
                catch (Throwable e) {
                    IndustrialForegoing.LOGGER.error((Object)e);
                }
            }
            this.blocksToUpdatePointer += amount;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

