/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.mixin.plugin;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;
import org.violetmoon.zeta.mixin.plugin.DelegateInterfaceMixin;

public class InterfaceDelegateMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        HashMultimap targets = HashMultimap.create();
        ClassNode mixinClass = mixinInfo.getClassNode(0);
        String thisOwner = targetClassName.replace(".", "/");
        AnnotationNode delegateInterface = Annotations.getVisible((ClassNode)mixinClass, DelegateInterfaceMixin.class);
        if (delegateInterface != null && (mixinClass.access & 0x200) != 0) {
            String callInvoker = ((Type)Annotations.getValue((AnnotationNode)delegateInterface, (String)"delegate")).getInternalName();
            List delegatedMethods = (List)Annotations.getValue((AnnotationNode)delegateInterface, (String)"methods");
            for (AnnotationNode delegate : delegatedMethods) {
                List targetMethods = Annotations.getValue((AnnotationNode)delegate, (String)"target", (boolean)false);
                String delegateMethod = (String)Annotations.getValue((AnnotationNode)delegate, (String)"delegate");
                String desc = (String)Annotations.getValue((AnnotationNode)delegate, (String)"desc");
                for (String targetName : targetMethods) {
                    targets.put((Object)targetName, (Object)new MethodReference(delegateMethod, Descriptor.tokenize(desc)));
                }
            }
            for (MethodNode method : targetClass.methods) {
                Object methodName = method.name + method.desc;
                if (!targets.containsKey(methodName)) {
                    methodName = method.name;
                }
                if (!targets.containsKey(methodName)) continue;
                Descriptor targetDescriptor = Descriptor.tokenize(method.desc);
                int opcode = switch (targetDescriptor.ret) {
                    case "V" -> 177;
                    case "I", "S", "C", "B", "Z" -> 172;
                    case "J" -> 173;
                    case "F" -> 174;
                    case "D" -> 175;
                    default -> 176;
                };
                HashMap<InsnNode, InsnList> transformations = new HashMap<InsnNode, InsnList>();
                Collection nodes = targets.get(methodName);
                for (int i = 0; i < method.instructions.size(); ++i) {
                    AbstractInsnNode node = method.instructions.get(i);
                    if (!(node instanceof InsnNode)) continue;
                    InsnNode insnNode = (InsnNode)node;
                    if (node.getOpcode() != opcode) continue;
                    this.buildTransforms(callInvoker, thisOwner, method, targetDescriptor, insnNode, nodes, transformations);
                }
                for (InsnNode transformationTarget : transformations.keySet()) {
                    method.instructions.insertBefore((AbstractInsnNode)transformationTarget, (InsnList)transformations.get(transformationTarget));
                }
            }
        }
    }

    private void buildTransforms(String callInvoker, String owner, MethodNode target, Descriptor targetDescriptor, InsnNode returnNode, Collection<MethodReference> transformers, Map<InsnNode, InsnList> transformations) {
        String ownerType = "L" + owner + ";";
        boolean isStatic = (target.access & 8) != 0;
        for (MethodReference transformer : transformers) {
            Descriptor transformerDescriptor = transformer.descriptor;
            InsnList transformation = this.foldTransformerParams(ownerType, isStatic, targetDescriptor, transformerDescriptor);
            if (transformation == null) continue;
            transformation.add((AbstractInsnNode)new MethodInsnNode(184, callInvoker, transformer.name, transformer.descriptor.toString()));
            if (transformations.containsKey(returnNode)) {
                transformations.get(returnNode).add(transformation);
                continue;
            }
            transformations.put(returnNode, transformation);
        }
    }

    private InsnList foldTransformerParams(String ownerType, boolean isStatic, Descriptor target, Descriptor transformer) {
        if (!target.ret.equals(transformer.ret)) {
            return null;
        }
        if (transformer.params.length == 0 || !transformer.params[0].equals(target.ret)) {
            return null;
        }
        if (transformer.params.length == 1) {
            return new InsnList();
        }
        InsnList localVarsToLoad = new InsnList();
        boolean firstWasThis = false;
        int lvtIndex = isStatic ? 0 : 1;
        for (int i = 0; i < transformer.params.length - 1; ++i) {
            int targetIndex;
            String transformerParam = transformer.params[i + 1];
            if (i == 0 && !isStatic && transformerParam.equals(ownerType)) {
                firstWasThis = true;
                localVarsToLoad.add((AbstractInsnNode)new VarInsnNode(25, 0));
                continue;
            }
            int n = targetIndex = firstWasThis ? i - 1 : i;
            if (targetIndex >= target.params.length) {
                return null;
            }
            if (transformerParam.charAt(0) == target.params[targetIndex].charAt(0)) {
                int opcode = switch (transformerParam) {
                    case "I", "S", "C", "B", "Z" -> 21;
                    case "J" -> 22;
                    case "F" -> 23;
                    case "D" -> 24;
                    default -> 25;
                };
                localVarsToLoad.add((AbstractInsnNode)new VarInsnNode(opcode, lvtIndex++));
                if (opcode != 22 && opcode != 24) continue;
                ++lvtIndex;
                continue;
            }
            return null;
        }
        return localVarsToLoad;
    }

    private record MethodReference(String name, Descriptor descriptor) {
    }

    private record Descriptor(String[] params, String ret) {
        private static final String END_TOKEN = "ISCBZJFD";

        @Override
        public String toString() {
            StringBuilder out = new StringBuilder("(");
            for (String param : this.params) {
                out.append(param);
            }
            out.append(')');
            out.append(this.ret);
            return out.toString();
        }

        private static Descriptor tokenize(String desc) {
            if (desc.length() < 3 || desc.charAt(0) != '(') {
                return new Descriptor(new String[0], "V");
            }
            ArrayList<String> parameters = new ArrayList<String>();
            String returnType = "V";
            int pointer = 1;
            boolean parsingReturnType = false;
            boolean parsingClassType = false;
            StringBuilder collected = new StringBuilder();
            while (pointer < desc.length()) {
                char charAt = desc.charAt(pointer++);
                if (!parsingClassType && END_TOKEN.indexOf(charAt) >= 0 || parsingClassType && charAt == ';') {
                    collected.append(charAt);
                    if (parsingReturnType) {
                        returnType = collected.toString();
                    } else {
                        parameters.add(collected.toString());
                    }
                    parsingClassType = false;
                    collected = new StringBuilder();
                    continue;
                }
                if (charAt == ')') {
                    parsingReturnType = true;
                    continue;
                }
                if (charAt == 'L') {
                    parsingClassType = true;
                }
                collected.append(charAt);
            }
            return new Descriptor(parameters.toArray(new String[0]), returnType);
        }
    }
}

