/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.violetmoon.zeta.registry.DyeablesRegistry;

public class ZetaDyeRecipe
extends CustomRecipe {
    protected final DyeablesRegistry dyeablesRegistry;
    protected final RecipeSerializer<?> serializer;

    public ZetaDyeRecipe(ResourceLocation id, CraftingBookCategory cat, DyeablesRegistry dyeablesRegistry) {
        super(id, cat);
        this.dyeablesRegistry = dyeablesRegistry;
        this.serializer = new SimpleCraftingRecipeSerializer((id_, cat_) -> new ZetaDyeRecipe(id_, cat_, dyeablesRegistry, this::m_7707_));
    }

    protected ZetaDyeRecipe(ResourceLocation id, CraftingBookCategory cat, DyeablesRegistry dyeablesRegistry, Supplier<RecipeSerializer<?>> loopCloser) {
        super(id, cat);
        this.dyeablesRegistry = dyeablesRegistry;
        this.serializer = loopCloser.get();
    }

    public boolean matches(CraftingContainer p_43769_, Level p_43770_) {
        ItemStack itemstack = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_43769_.m_6643_(); ++i) {
            ItemStack itemstack1 = p_43769_.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            if (this.dyeablesRegistry.isDyeable(itemstack1)) {
                if (!itemstack.m_41619_()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (!(itemstack1.m_41720_() instanceof DyeItem)) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.m_41619_() && !list.isEmpty();
    }

    public ItemStack assemble(CraftingContainer p_43767_, RegistryAccess pissing) {
        ArrayList list = Lists.newArrayList();
        ItemStack itemstack = ItemStack.f_41583_;
        for (int i = 0; i < p_43767_.m_6643_(); ++i) {
            ItemStack itemstack1 = p_43767_.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            Item item = itemstack1.m_41720_();
            if (this.dyeablesRegistry.isDyeable(itemstack1)) {
                if (!itemstack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                itemstack = itemstack1.m_41777_();
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return ItemStack.f_41583_;
            }
            list.add((DyeItem)item);
        }
        return !itemstack.m_41619_() && !list.isEmpty() ? this.dyeablesRegistry.dyeItem(itemstack, list) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }
}

