/*
 * Decompiled with CFR 0.152.
 */
package com.mna;

import com.mna.api.particles.ParticleInit;
import com.mna.api.tools.RLoc;
import com.mna.apibridge.APIBridge;
import com.mna.blocks.BlockClientInit;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.init.TileEntityClientInit;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.brewing.BrewingInit;
import com.mna.commands.CommandInit;
import com.mna.commands.CommandSerializerInit;
import com.mna.config.ClientConfig;
import com.mna.config.GeneralConfig;
import com.mna.effects.EffectInit;
import com.mna.effects.particles.EffectParticleSpawner;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.entities.EntityClientInit;
import com.mna.entities.EntityInit;
import com.mna.entities.attributes.AttributeInit;
import com.mna.entities.models.constructs.modular.ConstructModelRegistry;
import com.mna.events.ClientEventHandler;
import com.mna.gui.GuiInit;
import com.mna.gui.HUDOverlayRenderer;
import com.mna.gui.containers.ContainerInit;
import com.mna.guide.GuideBookEntries;
import com.mna.items.ItemClientInit;
import com.mna.items.ItemInit;
import com.mna.items.artifice.ItemThaumaturgicCompass;
import com.mna.items.ritual.ItemThaumaturgicLink;
import com.mna.loot.GlobalLootModifiers;
import com.mna.particles.ParticleClientInit;
import com.mna.recipes.RecipeInit;
import com.mna.tools.ISidedProxy;
import com.mna.tools.debugging.ForgeLoggerTweaker;
import com.mna.tools.proxy.ClientProxy;
import com.mna.tools.proxy.ServerProxy;
import com.mna.villagers.VillagerRegistry;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="mna")
public class ManaAndArtifice {
    public static final Logger LOGGER = LogManager.getLogger();
    public static ManaAndArtifice instance;
    public static final ResourceLocation EMPTY;
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public ISidedProxy proxy;
    public final boolean isDebug;
    public final ArrayList<UUID> enabled_auras = new ArrayList();

    public ManaAndArtifice() {
        boolean HIDE_CONSOLE_NOISE = this.isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        if (HIDE_CONSOLE_NOISE) {
            ForgeLoggerTweaker.setMinimumLevel(org.apache.logging.log4j.Level.WARN);
            ForgeLoggerTweaker.applyLoggerFilter();
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)GeneralConfig.GENERAL_SPEC, "mna-general.toml");
        APIBridge.earlyInit();
        LOGGER.info("M&A -> Configs Registered");
        ForgeMod.enableMilkFluid();
        instance = this;
        ItemInit.ITEMS.register(this.modEventBus);
        BlockInit.BLOCKS.register(this.modEventBus);
        TileEntityInit.TILE_ENTITY_TYPES.register(this.modEventBus);
        AttributeInit.ATTRIBUTES.register(this.modEventBus);
        EntityInit.ENTITY_TYPES.register(this.modEventBus);
        ParticleInit.PARTICLES.register(this.modEventBus);
        ContainerInit.CONTAINERS.register(this.modEventBus);
        RecipeInit.SERIALIZERS.register(this.modEventBus);
        RecipeInit.TYPES.register(this.modEventBus);
        VillagerRegistry.POI_TYPES.register(this.modEventBus);
        VillagerRegistry.PROFESSIONS.register(this.modEventBus);
        CommandSerializerInit.ARGUMENTS.register(this.modEventBus);
        GlobalLootModifiers.LOOT_MODIFIERS.register(this.modEventBus);
        EffectInit.EFFECTS.register(this.modEventBus);
        EnchantmentInit.ENCHANTMENTS.register(this.modEventBus);
        BrewingInit.POTIONS.register(this.modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register(HUDOverlayRenderer.class);
            MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
            MinecraftForge.EVENT_BUS.register(EffectParticleSpawner.class);
            MinecraftForge.EVENT_BUS.register(GuideBookEntries.class);
            this.modEventBus.addListener(this::clientInit);
            this.modEventBus.register(GuiInit.class);
            this.modEventBus.register(ParticleClientInit.class);
            this.modEventBus.register(TileEntityClientInit.class);
            this.modEventBus.register(BlockClientInit.class);
            this.modEventBus.register(ItemClientInit.class);
            this.modEventBus.register(ConstructModelRegistry.class);
            this.modEventBus.register(EntityClientInit.class);
            this.proxy = new ClientProxy();
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            this.proxy = new ServerProxy();
        });
        MinecraftForge.EVENT_BUS.register(CommandInit.class);
        this.modEventBus.register(CommandSerializerInit.class);
        GeckoLib.initialize();
        try {
            String inputLine;
            URL url = new URL("https://manaandartifice.com/auras_enabled.txt");
            HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
            httpcon.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader in = new BufferedReader(new InputStreamReader(httpcon.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                try {
                    UUID uuid = UUID.fromString(inputLine);
                    this.enabled_auras.add(uuid);
                }
                catch (Exception exception) {}
            }
            in.close();
            LOGGER.info("M&A -> Retrieved " + this.enabled_auras.size() + " auras from the server");
        }
        catch (Exception e) {
            LOGGER.error("M&A -> Failed to query auras from the server");
        }
        LOGGER.info("M&A -> Mod Event Bus Handlers Registered");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)ItemInit.THAUMATURGIC_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private final Angle wobble;
            private final Angle wobbleRandom;
            {
                this.wobble = new Angle();
                this.wobbleRandom = new Angle();
            }

            public float m_142187_(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity living, int some_number) {
                LivingEntity entity;
                Object object = entity = living != null ? living : stack.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (world == null && entity.m_9236_() instanceof ClientLevel) {
                    world = (ClientLevel)entity.m_9236_();
                }
                BlockPos blockpos = ((ItemThaumaturgicCompass)((Object)ItemInit.THAUMATURGIC_COMPASS.get())).getTrackedPosition(stack, (ResourceKey<Level>)world.m_46472_());
                long i = world.m_46467_();
                if (blockpos != null && !(entity.m_20182_().m_82531_((double)blockpos.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)blockpos.m_123343_() + 0.5) < (double)1.0E-5f)) {
                    double d3;
                    boolean flag = living instanceof Player && ((Player)living).m_7578_();
                    double d1 = 0.0;
                    if (flag) {
                        d1 = living.m_146908_();
                    } else if (entity instanceof ItemFrame) {
                        d1 = this.getFrameRotation((ItemFrame)entity);
                    } else if (entity instanceof ItemEntity) {
                        d1 = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (living != null) {
                        d1 = living.f_20883_;
                    }
                    d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getAngleTo(Vec3.m_82512_((Vec3i)blockpos), (Entity)entity) / 6.2831854820251465;
                    if (flag) {
                        if (this.wobble.shouldUpdate(i)) {
                            this.wobble.update(i, 0.5 - (d1 - 0.25));
                        }
                        d3 = d2 + this.wobble.rotation;
                    } else {
                        d3 = 0.5 - (d1 - 0.25 - d2);
                    }
                    return Mth.m_14091_((float)((float)d3), (float)1.0f);
                }
                if (this.wobbleRandom.shouldUpdate(i)) {
                    this.wobbleRandom.update(i, Math.random());
                }
                double d0 = this.wobbleRandom.rotation + (double)((float)stack.hashCode() / 2.1474836E9f);
                return Mth.m_14091_((float)((float)d0), (float)1.0f);
            }

            private double getFrameRotation(ItemFrame p_239441_1_) {
                Direction direction = p_239441_1_.m_6350_();
                int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + p_239441_1_.m_31823_() * 45 + i));
            }

            private double getAngleTo(Vec3 p_239443_1_, Entity p_239443_2_) {
                return Math.atan2(p_239443_1_.m_7094_() - p_239443_2_.m_20189_(), p_239443_1_.m_7096_() - p_239443_2_.m_20185_());
            }
        });
        ItemProperties.register((Item)((Item)ItemInit.HELLFIRE_TRIDENT.get()), (ResourceLocation)RLoc.create("throwing"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

            public float m_142187_(ItemStack pStack, ClientLevel pLevel, LivingEntity pEntity, int pSeed) {
                return pEntity != null && pEntity.m_6117_() ? 1.0f : 0.0f;
            }
        });
        ItemProperties.register((Item)((Item)ItemInit.THAUMATURGIC_LINK.get()), (ResourceLocation)new ResourceLocation("biome"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

            public float m_142187_(ItemStack pStack, ClientLevel pLevel, LivingEntity pEntity, int pSeed) {
                ItemThaumaturgicLink link;
                Item item = pStack.m_41720_();
                if (item instanceof ItemThaumaturgicLink && (link = (ItemThaumaturgicLink)item).isBiome(pStack)) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    static {
        EMPTY = new ResourceLocation("mna", "empty");
    }

    @OnlyIn(value=Dist.CLIENT)
    class Angle {
        private double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private Angle() {
        }

        private boolean shouldUpdate(long p_239448_1_) {
            return this.lastUpdateTick != p_239448_1_;
        }

        private void update(long p_239449_1_, double p_239449_3_) {
            this.lastUpdateTick = p_239449_1_;
            double d0 = p_239449_3_ - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

