/*
 * Decompiled with CFR 0.152.
 */
package com.mna.advancements.triggers;

import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.tools.RLoc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class LightEldrinFumeTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RLoc.create("light_fume");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        ArrayList<Affinity> affinities = new ArrayList<Affinity>();
        if (json.has("affinities") && json.get("affinities").isJsonArray()) {
            json.get("affinities").getAsJsonArray().forEach(e -> {
                String val = e.getAsString();
                try {
                    affinities.add(Affinity.valueOf(val));
                }
                catch (Throwable t) {
                    ManaAndArtifice.LOGGER.warn("failed to parse affinity enum value in light fume advancement trigger.  Value:" + val);
                }
            });
        }
        return new Instance(entityPredicate, affinities);
    }

    public void trigger(ServerPlayer player, Affinity type) {
        this.m_66234_(player, instance -> instance.matches(type));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final List<Affinity> affinities;

        public Instance(ContextAwarePredicate player, List<Affinity> affinities) {
            super(ID, player);
            this.affinities = affinities;
        }

        public boolean matches(Affinity type) {
            if (this.affinities != null && this.affinities.size() > 0) {
                return this.affinities.contains((Object)type);
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            return jsonobject;
        }
    }
}

