/*
 * Decompiled with CFR 0.152.
 */
package com.mna.advancements.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mna.advancements.predicates.CraftSpellPredicate;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.tools.RLoc;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TranscribeSpellTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RLoc.create("transcribe_spell");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        CraftSpellPredicate spellPredicate = null;
        ItemPredicate itemPredicate = null;
        if (json.has("spell") && json.get("spell").isJsonObject()) {
            spellPredicate = CraftSpellPredicate.fromJSON(json.get("spell").getAsJsonObject());
        }
        if (json.has("item") && json.get("item").isJsonObject()) {
            itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("item").getAsJsonObject());
        }
        return new Instance(entityPredicate, spellPredicate, itemPredicate);
    }

    public void trigger(ServerPlayer player, ISpellDefinition spell, ItemStack destination) {
        this.m_66234_(player, instance -> instance.test(spell, player.m_9236_(), destination));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final CraftSpellPredicate spellPredicate;
        private final ItemPredicate itemPredicate;

        public Instance(ContextAwarePredicate player, CraftSpellPredicate spellPredicate, ItemPredicate itemPredicate) {
            super(ID, player);
            this.spellPredicate = spellPredicate;
            this.itemPredicate = itemPredicate;
        }

        public boolean test(ISpellDefinition spell, Level world, ItemStack destinationStack) {
            boolean success = true;
            if (this.spellPredicate != null) {
                success &= this.spellPredicate.test(spell, world);
            }
            if (this.itemPredicate != null) {
                success &= this.itemPredicate.m_45049_(destinationStack);
            }
            return success;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            return jsonobject;
        }
    }
}

