/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import com.mna.api.blocks.FillerBlock;
import com.mna.api.blocks.interfaces.IOffsetPlace;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockWithOffset
extends Block
implements IOffsetPlace {
    private BlockPos[] offsets;

    public BlockWithOffset(BlockBehaviour.Properties properties, BlockPos ... offsets) {
        super(properties);
        this.offsets = offsets;
    }

    public void m_6807_(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean p_220082_5_) {
        for (BlockPos offset : this.offsets) {
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            if (!world.m_46859_(offsetPos)) continue;
            FillerBlock.setAtOffsetFrom((LevelAccessor)world, pos, offset);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean doDrops) {
        if (state.m_60734_() != newState.m_60734_()) {
            Block filler = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mna", "filler_block"));
            for (BlockPos offset : this.offsets) {
                BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
                BlockState offsetState = world.m_8055_(offsetPos);
                if (offsetState.m_60734_() != filler) continue;
                world.m_46961_(offsetPos, false);
            }
        }
        super.m_6810_(state, world, pos, newState, doDrops);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        for (BlockPos offset : this.offsets) {
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            if (context.m_43725_().m_46859_(offsetPos)) continue;
            return null;
        }
        return this.m_49966_();
    }

    protected void m_142387_(Level world, Player player, BlockPos pos, BlockState state) {
        Block filler = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mna", "filler_block"));
        for (BlockPos offset : this.offsets) {
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (offsetState.m_60734_() != filler) continue;
            world.m_5898_(player, 2001, offsetPos, BlockWithOffset.m_49956_((BlockState)state));
        }
        world.m_5898_(player, 2001, pos, BlockWithOffset.m_49956_((BlockState)state));
    }

    @Override
    public BlockPlaceContext adjustPlacement(BlockPlaceContext attempted) {
        return attempted;
    }
}

