/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class DirectionalPoint {
    private final Direction direction;
    private final BlockPos position;
    private final String originalBlockName;

    public DirectionalPoint(BlockPos position, Direction direction, String originalBlockName) {
        this.position = position;
        this.direction = direction;
        this.originalBlockName = originalBlockName;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isValid() {
        return this.position != null && this.direction != null;
    }

    @Nullable
    public String getBlock() {
        return this.originalBlockName;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.direction != null) {
            tag.m_128405_("direction", this.direction.m_122411_());
        }
        if (this.position != null) {
            tag.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)this.position));
        }
        if (this.originalBlockName != null) {
            tag.m_128359_("block", this.originalBlockName);
        }
        return tag;
    }

    public static DirectionalPoint of(CompoundTag tag) {
        if (tag.m_128441_("position") && tag.m_128441_("direction") && tag.m_128441_("block")) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("position"));
            Direction direction = Direction.m_122376_((int)tag.m_128451_("direction"));
            String name = tag.m_128461_("block");
            return new DirectionalPoint(pos, direction, name);
        }
        return null;
    }
}

