/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import com.mna.api.blocks.FillerBlock;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.IOffsetPlace;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class WaterloggableBlockWithOffset
extends WaterloggableBlock
implements IOffsetPlace {
    private final BlockPos[] offsets;

    public WaterloggableBlockWithOffset(BlockBehaviour.Properties properties, boolean startWaterlogged, BlockPos ... offsets) {
        super(properties, startWaterlogged);
        this.offsets = offsets;
    }

    public void m_6807_(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean p_220082_5_) {
        for (BlockPos offset : this.getOffsets(oldState)) {
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            if (!world.m_46859_(offsetPos)) continue;
            FillerBlock.setAtOffsetFrom((LevelAccessor)world, pos, offset);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        Block filler = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mna", "filler_block"));
        if (state.m_60734_() != newState.m_60734_()) {
            for (BlockPos offset : this.getOffsets(state)) {
                BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
                BlockState offsetState = world.m_8055_(offsetPos);
                if (offsetState.m_60734_() != filler) continue;
                world.m_7471_(offsetPos, false);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        for (BlockPos offset : this.getOffsets(context.m_43725_().m_8055_(pos))) {
            FluidState flState;
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            if (context.m_43725_().m_46859_(offsetPos) || (flState = context.m_43725_().m_6425_(offsetPos)) != null && !flState.m_76178_() && (flState.m_76152_() == Fluids.f_76193_ || flState.m_76152_() == Fluids.f_76192_)) continue;
            return this.m_49966_();
        }
        return this.m_49966_();
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void m_142387_(Level world, Player player, BlockPos pos, BlockState state) {
        Block filler = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("mna", "filler_block"));
        for (BlockPos offset : this.getOffsets(state)) {
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (offsetState.m_60734_() != filler) continue;
            world.m_5898_(player, 2001, offsetPos, WaterloggableBlockWithOffset.m_49956_((BlockState)state));
        }
        world.m_5898_(player, 2001, pos, WaterloggableBlockWithOffset.m_49956_((BlockState)state));
    }

    protected BlockPos[] getOffsets(BlockState state) {
        return this.offsets;
    }

    @Override
    public BlockPlaceContext adjustPlacement(BlockPlaceContext attempted) {
        return attempted;
    }
}

