/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.IEldrinCapacitorTile;
import com.mna.api.capabilities.IWellspringNodeRegistry;
import com.mna.api.events.EldrinPowerTransferredEvent;
import com.mna.api.faction.IFaction;
import com.mna.api.gui.EldrinCapacitorPermissionsContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EldrinCapacitorTile
extends BlockEntity
implements IEldrinCapacitorTile,
Consumer<FriendlyByteBuf> {
    protected List<Affinity> suppliedAffinities;
    protected HashMap<Affinity, Float> power;
    protected float capacity;
    protected List<EldrinCapacitorPermissionsContainer> openContainers;
    protected boolean isPublic;
    protected boolean shareWithTeam;
    protected boolean shareWithFaction;
    protected UUID placedByPlayerID;
    protected String placedByPlayerName;
    protected IFaction placedByFaction;
    protected String placedByTeamName;
    protected boolean redstoneDisablesSupply = true;

    public EldrinCapacitorTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, float capacity, Affinity ... suppliedAffinities) {
        super(pType, pPos, pBlockState);
        this.suppliedAffinities = Arrays.asList(suppliedAffinities);
        this.power = new HashMap();
        this.capacity = capacity;
        this.openContainers = new ArrayList<EldrinCapacitorPermissionsContainer>();
        this.suppliedAffinities.forEach(a -> this.power.put((Affinity)((Object)a), Float.valueOf(0.0f)));
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, EldrinCapacitorTile tile) {
        tile.ambientCharge();
    }

    protected void ambientCharge() {
        if (this.getPlacedBy() == null) {
            this.f_58857_.m_46961_(this.m_58899_(), true);
            return;
        }
        this.f_58857_.getCapability(ManaAndArtificeMod.getWorldMagicCapability()).ifPresent(worldMagic -> {
            IWellspringNodeRegistry wellsprings = worldMagic.getWellspringRegistry();
            this.suppliedAffinities.forEach(affinity -> {
                float current = this.power.get(affinity).floatValue();
                if (current < this.capacity) {
                    float amount = wellsprings.consumePower(this.placedByPlayerID, this.f_58857_, (Affinity)((Object)((Object)affinity)), this.getChargeRate());
                    this.power.put((Affinity)((Object)((Object)affinity)), Float.valueOf(current + amount));
                }
            });
        });
    }

    protected Vec3 getVFXOriginOffset() {
        return Vec3.m_82512_((Vec3i)this.m_58899_());
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean shareWithTeam() {
        return this.shareWithTeam;
    }

    @Override
    public boolean shareWithFaction() {
        return this.shareWithFaction;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public void setTeamShare(boolean teamShare) {
        this.shareWithTeam = teamShare;
    }

    @Override
    public void setFactionShare(boolean factionShare) {
        this.shareWithFaction = factionShare;
    }

    @Override
    public List<Affinity> getAffinities() {
        return this.suppliedAffinities;
    }

    @Override
    public float getCapacity(Affinity affinity) {
        if (!this.supplies(affinity)) {
            return 0.0f;
        }
        return this.capacity;
    }

    @Override
    public float getCharge(Affinity affinity) {
        if (!this.supplies(affinity)) {
            return 0.0f;
        }
        return this.power.get((Object)affinity).floatValue();
    }

    @Override
    public void setCharge(Affinity affinity, float amount) {
        if (this.supplies(affinity)) {
            this.power.put(affinity, Float.valueOf(amount));
        }
    }

    @Override
    public float charge(Affinity affinity, float amount) {
        if (!this.supplies(affinity)) {
            return 0.0f;
        }
        float current = this.power.get((Object)affinity).floatValue();
        if (current + amount > this.capacity) {
            amount = this.capacity - current;
        }
        this.power.put(affinity, Float.valueOf(current + amount));
        return amount;
    }

    @Override
    public float consume(Affinity affinity, float amount) {
        if (!this.supplies(affinity)) {
            return 0.0f;
        }
        float current = this.power.get((Object)affinity).floatValue();
        if (current < amount) {
            amount = current;
        }
        this.power.put(affinity, Float.valueOf(current - amount));
        return amount;
    }

    @Override
    public float supply(Player requester, Vec3 destPos, Affinity affinity, float amount) {
        if (this.getPlacedBy() == null) {
            return 0.0f;
        }
        if (this.redstoneDisablesSupply && this.m_58904_().m_277086_(this.m_58899_()) > 0) {
            return 0.0f;
        }
        float actualAmount = IEldrinCapacitorTile.super.supply(requester, destPos, affinity, amount, true);
        EldrinPowerTransferredEvent event = new EldrinPowerTransferredEvent(affinity, actualAmount, this.getVFXOriginOffset(), destPos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0.0f;
        }
        return IEldrinCapacitorTile.super.supply(requester, destPos, affinity, amount, false);
    }

    @Override
    public void setPlacedBy(Player player) {
        this.placedByPlayerID = player.m_36316_().getId();
        this.placedByPlayerName = player.m_36316_().getName();
        if (player.m_5647_() != null) {
            this.placedByTeamName = player.m_5647_().m_5758_();
        }
        player.getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> {
            this.placedByFaction = p.getAlliedFaction();
        });
    }

    @Override
    public UUID getPlacedBy() {
        return this.placedByPlayerID;
    }

    @Override
    public String getPlacedByTeam() {
        Player player;
        if (this.placedByTeamName == null && (player = this.f_58857_.m_46003_(this.placedByPlayerID)) != null && player.m_5647_() != null) {
            this.placedByTeamName = player.m_5647_().m_5758_();
        }
        return this.placedByTeamName;
    }

    @Override
    public String getPlacedByPlayerName() {
        Player player;
        if (this.placedByPlayerName == null && (player = this.f_58857_.m_46003_(this.placedByPlayerID)) != null && player.m_5647_() != null) {
            this.placedByPlayerName = player.m_36316_().getName();
        }
        return this.placedByPlayerName;
    }

    @Override
    public IFaction getPlacedByFaction() {
        Player player;
        if (this.placedByFaction == null && (player = this.f_58857_.m_46003_(this.placedByPlayerID)) != null) {
            player.getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(c -> {
                this.placedByFaction = c.getAlliedFaction();
            });
        }
        return this.placedByFaction;
    }

    public void addContainer(EldrinCapacitorPermissionsContainer container) {
        this.openContainers.add(container);
    }

    public void removeContainer(EldrinCapacitorPermissionsContainer container) {
        this.openContainers.remove((Object)container);
    }

    @Override
    public void accept(FriendlyByteBuf data) {
        data.m_130064_(this.m_58899_());
        if (this.getPlacedBy() != null) {
            data.writeBoolean(true);
            data.m_130077_(this.getPlacedBy());
        } else {
            data.writeBoolean(false);
        }
        if (this.placedByPlayerName != null) {
            data.writeBoolean(true);
            data.m_130070_(this.placedByPlayerName);
        } else {
            data.writeBoolean(false);
        }
        if (this.getPlacedByTeam() != null) {
            data.writeBoolean(true);
            data.m_130070_(this.getPlacedByTeam());
        } else {
            data.writeBoolean(false);
        }
        if (this.getPlacedByFaction() != null) {
            data.writeBoolean(true);
            data.writeRegistryId(ManaAndArtificeMod.getFactionsRegistry(), (Object)this.getPlacedByFaction());
        } else {
            data.writeBoolean(false);
        }
        data.writeInt(this.power.size());
        for (Map.Entry<Affinity, Float> entry : this.power.entrySet()) {
            data.writeInt(entry.getKey().ordinal());
            data.writeFloat(entry.getValue().floatValue());
        }
    }

    public EldrinCapacitorTile readFrom(FriendlyByteBuf data) {
        if (data.readBoolean()) {
            this.placedByPlayerID = data.m_130259_();
        }
        if (data.readBoolean()) {
            this.placedByPlayerName = data.m_130277_();
        }
        if (data.readBoolean()) {
            this.placedByTeamName = data.m_130277_();
        }
        if (data.readBoolean()) {
            this.placedByFaction = (IFaction)data.readRegistryIdSafe(IFaction.class);
        }
        this.power.clear();
        int count = data.readInt();
        for (int i = 0; i < count; ++i) {
            Affinity aff = Affinity.values()[data.readInt() % Affinity.values().length];
            this.power.put(aff, Float.valueOf(data.readFloat()));
        }
        return this;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("isPublic", this.isPublic);
        pTag.m_128379_("teamShare", this.shareWithTeam);
        pTag.m_128379_("factionShare", this.shareWithFaction);
        if (this.placedByPlayerID != null) {
            pTag.m_128359_("player", this.placedByPlayerID.toString());
        }
        if (this.placedByPlayerName != null) {
            pTag.m_128359_("playerName", this.placedByPlayerName);
        }
        if (this.placedByTeamName != null) {
            pTag.m_128359_("team", this.placedByTeamName);
        }
        if (this.placedByFaction != null) {
            pTag.m_128359_("faction", ManaAndArtificeMod.getFactionsRegistry().getKey((Object)this.placedByFaction).toString());
        }
        this.suppliedAffinities.forEach(affinity -> pTag.m_128350_(affinity.name(), this.power.get(affinity).floatValue()));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("isPublic")) {
            this.isPublic = pTag.m_128471_("isPublic");
        }
        if (pTag.m_128441_("teamShare")) {
            this.shareWithTeam = pTag.m_128471_("teamShare");
        }
        if (pTag.m_128441_("factionShare")) {
            this.shareWithFaction = pTag.m_128471_("factionShare");
        }
        if (pTag.m_128441_("player")) {
            this.placedByPlayerID = UUID.fromString(pTag.m_128461_("player"));
        }
        if (pTag.m_128441_("playerName")) {
            this.placedByPlayerName = pTag.m_128461_("playerName");
        }
        if (pTag.m_128441_("team")) {
            this.placedByTeamName = pTag.m_128461_("team");
        }
        if (pTag.m_128441_("faction")) {
            ResourceLocation faction = new ResourceLocation(pTag.m_128461_("faction"));
            this.placedByFaction = (IFaction)ManaAndArtificeMod.getFactionsRegistry().getValue(faction);
        }
        this.power.clear();
        for (Affinity affinity : Affinity.values()) {
            if (!pTag.m_128441_(affinity.name())) continue;
            this.power.put(affinity, Float.valueOf(pTag.m_128457_(affinity.name())));
        }
        this.suppliedAffinities = new ArrayList<Affinity>(this.power.keySet());
    }
}

