/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityWithInventory
extends BlockEntity
implements Container,
WorldlyContainer {
    protected NonNullList<ItemStack> inventoryItems;
    protected boolean ignoreQtyLimit = false;
    protected HashMap<Direction, LazyOptional<?>> sidedHandlers;

    public TileEntityWithInventory(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int inventorySize) {
        super(tileEntityTypeIn, pos, state);
        this.inventoryItems = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
        this.sidedHandlers = new HashMap();
    }

    protected LazyOptional<?> getOrCreateSidedHandler(Direction side) {
        if (!this.sidedHandlers.containsKey(side)) {
            this.sidedHandlers.put(side, LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, side)));
        }
        return this.sidedHandlers.get(side);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getOrCreateSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_6211_() {
        this.m_6596_();
        this.inventoryItems.clear();
    }

    public int m_6643_() {
        return this.inventoryItems.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventoryItems) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean hasStack(int index) {
        return !this.m_8020_(index).m_41619_();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack output = ContainerHelper.m_18969_(this.inventoryItems, (int)index, (int)count);
        this.m_6596_();
        return output;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemstack = (ItemStack)this.inventoryItems.get(index);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.inventoryItems.set(index, (Object)ItemStack.f_41583_);
        this.m_6596_();
        return itemstack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventoryItems.set(index, (Object)stack);
        if (!this.ignoreQtyLimit && !stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public int[] m_7071_(Direction side) {
        return new int[0];
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.m_58899_().m_203195_((Position)player.m_20182_(), 8.0);
    }

    public void m_183515_(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventoryItems);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        ContainerHelper.m_18980_((CompoundTag)compound, this.inventoryItems);
    }
}

