/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.capabilities.resource;

import com.mna.api.capabilities.resource.SyncStatus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface ICastingResource {
    public ResourceLocation getRegistryName();

    public SyncStatus getSyncStatus();

    public void clearSyncStatus();

    public float getAmount();

    public boolean hasEnough(LivingEntity var1, float var2);

    public boolean hasEnoughAbsolute(LivingEntity var1, float var2);

    public void setAmount(float var1);

    public void consume(LivingEntity var1, float var2);

    public void restore(float var1);

    public float getMaxAmount();

    public float getMaxAmountBaseline();

    public void setMaxAmount(float var1);

    public void setMaxAmountByLevel(int var1);

    public void addModifier(String var1, float var2);

    public HashMap<String, Float> getModifiers();

    public void removeModifier(String var1);

    public void clearModifiers();

    public int getRegenerationRate(LivingEntity var1);

    public void setRegenerationRate(int var1);

    public void addRegenerationModifier(String var1, float var2);

    public HashMap<String, Float> getRegenerationModifiers();

    public void removeRegenerationModifier(String var1);

    public void clearRegenerationModifiers();

    public float getRegenerationModifier(LivingEntity var1);

    default public boolean hungerAffectsRegenRate() {
        return true;
    }

    default public boolean artificialRestore() {
        return true;
    }

    default public boolean canRechargeFrom(ItemStack batteryItem) {
        return true;
    }

    default public void copyFrom(ICastingResource other) {
        if (other.getRegistryName() != this.getRegistryName()) {
            return;
        }
        this.clearModifiers();
        other.getModifiers().forEach((k, v) -> this.addModifier((String)k, v.floatValue()));
        this.clearRegenerationModifiers();
        other.getRegenerationModifiers().forEach((k, v) -> this.addRegenerationModifier((String)k, v.floatValue()));
        this.setMaxAmount(other.getMaxAmount());
        this.setAmount(other.getAmount());
    }

    default public void writeNBT(CompoundTag nbt) {
        CompoundTag resourceNBT = new CompoundTag();
        resourceNBT.m_128350_("amount", this.getAmount());
        resourceNBT.m_128350_("maximum", this.getMaxAmountBaseline());
        ListTag maximumModifiers = new ListTag();
        for (Map.Entry<String, Float> entry : this.getModifiers().entrySet()) {
            CompoundTag modifier = new CompoundTag();
            modifier.m_128359_("key", entry.getKey());
            modifier.m_128350_("value", entry.getValue().floatValue());
            maximumModifiers.add((Object)modifier);
        }
        resourceNBT.m_128365_("maximum_modifiers", (Tag)maximumModifiers);
        ListTag regenerationModifiers = new ListTag();
        for (Map.Entry<String, Float> entry : this.getRegenerationModifiers().entrySet()) {
            CompoundTag modifier = new CompoundTag();
            modifier.m_128359_("key", entry.getKey());
            modifier.m_128350_("value", entry.getValue().floatValue());
            regenerationModifiers.add((Object)modifier);
        }
        resourceNBT.m_128365_("regeneration_modifiers", (Tag)regenerationModifiers);
        nbt.m_128365_(this.getRegistryName().toString(), (Tag)resourceNBT);
    }

    default public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_(this.getRegistryName().toString())) {
            CompoundTag resourceNBT = nbt.m_128469_(this.getRegistryName().toString());
            this.setAmount(resourceNBT.m_128457_("amount"));
            this.setMaxAmount(resourceNBT.m_128457_("maximum"));
            ListTag maximumModifiers = resourceNBT.m_128437_("maximum_modifiers", 10);
            this.getModifiers().clear();
            maximumModifiers.forEach(inbt -> this.addModifier(((CompoundTag)inbt).m_128461_("key"), ((CompoundTag)inbt).m_128457_("value")));
            ListTag regenerationModifiers = resourceNBT.m_128437_("regeneration_modifiers", 10);
            this.getRegenerationModifiers().clear();
            regenerationModifiers.forEach(inbt -> this.addRegenerationModifier(((CompoundTag)inbt).m_128461_("key"), ((CompoundTag)inbt).m_128457_("value")));
        }
    }

    public void setNeedsSync();
}

