/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public interface IFactionEnemy<T extends LivingEntity> {
    public void setRaidTarget(Player var1);

    @Nullable
    public Player getRaidTarget();

    public IFaction getFaction();

    default public void setDamageResists(String typeID, int level) {
        this.getDamageResists().put(typeID, level);
    }

    public HashMap<String, Integer> getDamageResists();

    public int getTier();

    public void setTier(int var1);

    default public int getTierMax() {
        return 3;
    }

    default public void raidTargetDespawn() {
        if (this.getRaidTarget() != null) {
            if (!this.getRaidTarget().m_6084_()) {
                this.onDespawnDueToTargetDeath();
                ((LivingEntity)this).m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (this.getRaidTarget().m_20280_((Entity)this) > 4096.0) {
                this.onDespawnDueToDistance();
                ((LivingEntity)this).m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    default public boolean factionTargetPlayerPredicate(LivingEntity potentialTarget) {
        if (!(potentialTarget instanceof Player)) {
            return false;
        }
        IPlayerProgression progression = (IPlayerProgression)potentialTarget.getCapability(ManaAndArtificeMod.getProgressionCapability()).orElse(null);
        if (progression == null) {
            return false;
        }
        return potentialTarget.m_6084_() && progression.getAlliedFaction() != null && progression.getAlliedFaction().getEnemyFactions().contains(this.getFaction());
    }

    default public boolean factionTargetHelpPredicate(LivingEntity potentialTarget) {
        if (!(potentialTarget instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)potentialTarget;
        if (mob instanceof IFactionEnemy && ((IFactionEnemy)mob).getFaction() == this.getFaction()) {
            return false;
        }
        if (mob.m_6084_() && mob.m_5448_() instanceof Player) {
            MutableBoolean isFaction = new MutableBoolean(false);
            ((Player)mob.m_5448_()).getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> {
                IFaction myFaction = this.getFaction();
                IFaction playerFaction = p.getAlliedFaction();
                if (myFaction != null && playerFaction != null && myFaction.isAlliedTo(playerFaction)) {
                    isFaction.setTrue();
                }
            });
            return isFaction.booleanValue();
        }
        return false;
    }

    default public void writeFactionData(CompoundTag nbt) {
        CompoundTag factionData = new CompoundTag();
        factionData.m_128405_("tier", this.getTier());
        nbt.m_128365_("faction_data", (Tag)factionData);
    }

    default public void readFactionData(CompoundTag nbt) {
        if (!nbt.m_128441_("faction_data")) {
            return;
        }
        CompoundTag factionData = nbt.m_128469_("faction_data");
        if (factionData.m_128441_("tier")) {
            this.setTier(factionData.m_128451_("tier"));
        }
    }

    default public void onKilled(DamageSource source) {
        if (source.m_7639_() instanceof Player) {
            ((Player)source.m_7639_()).getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> p.getFactionDifficultyStats(this.getFaction()).onFactionMobKilled(source));
        }
    }

    default public void onDespawnDueToDistance() {
        if (this.getRaidTarget() != null) {
            this.getRaidTarget().getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> p.getFactionDifficultyStats(this.getFaction()).onFactionMobDespawnDueToDistance());
        }
    }

    default public void onDespawnDueToTargetDeath() {
        if (this.getRaidTarget() != null) {
            this.getRaidTarget().getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> p.getFactionDifficultyStats(this.getFaction()).onFactionKilledPlayer());
        }
    }

    default public float applyDamageResists(DamageSource source, float amount) {
        return amount - amount * ((float)this.getDamageResists().getOrDefault(source.m_19385_(), 0).intValue() * 0.2f);
    }

    default public void applyInitialSpawnTier(LevelAccessor world) {
        int tier;
        MutableInt enemyTiers = new MutableInt(0);
        world.m_6907_().forEach(player -> player.getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> {
            if (player.m_20280_((Entity)((LivingEntity)this)) < 4096.0) {
                enemyTiers.add(p.getTier());
            }
        }));
        float tierTotal = enemyTiers.getValue().intValue();
        double[] weights = new double[]{this.getTierWeight(tierTotal, 0.0f, 8.0f), this.getTierWeight(tierTotal, 3.0f, 4.0f), tierTotal <= 10.0f ? this.getTierWeight(tierTotal, 6.0f, 8.0f) : 1.0};
        double totalWeight = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            totalWeight += weights[i];
        }
        double r = Math.random() * totalWeight;
        for (tier = 0; tier < weights.length - 1 && !((r -= weights[tier]) <= 0.0); ++tier) {
        }
        this.setTier(tier);
    }

    default public double getTierWeight(float x, float shift, float steepness) {
        return Math.pow(Math.E, -1.0 * (Math.pow(x - shift, 2.0) / (double)steepness));
    }
}

