/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.construct.ai.parameter;

import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructParameterTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ConstructTaskPointParameter
extends ConstructAITaskParameter {
    private DirectionalPoint point;

    public ConstructTaskPointParameter(String id) {
        super(id, ConstructParameterTypes.POINT);
    }

    @Nullable
    public BlockPos getPosition() {
        if (this.point == null) {
            return null;
        }
        return this.point.getPosition();
    }

    @Nullable
    public Direction getDirection() {
        if (this.point == null) {
            return null;
        }
        return this.point.getDirection();
    }

    @Nullable
    public String getOriginalBlockName() {
        if (this.point == null) {
            return null;
        }
        return this.point.getBlock();
    }

    @Nullable
    public DirectionalPoint getPoint() {
        return this.point;
    }

    public void setPoint(DirectionalPoint point) {
        this.point = new DirectionalPoint(point.getPosition(), point.getDirection(), point.getBlock());
    }

    @Override
    public void loadData(CompoundTag nbt) {
        super.loadData(nbt);
        if (nbt.m_128441_("point")) {
            this.point = DirectionalPoint.of(nbt.m_128469_("point"));
        }
    }

    @Override
    public CompoundTag saveData() {
        CompoundTag tag = super.saveData();
        if (this.point != null) {
            tag.m_128365_("point", (Tag)this.point.save());
        }
        return tag;
    }
}

