/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.items;

import com.mna.api.recipes.IMARecipe;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public interface ITieredItem<T extends Item> {
    public static final int TIER_NOT_CHECKED = -1;
    public static final int TIER_NO_RECIPE = -2;
    public static final String TAG_HIDE_TIER_IN_TOOLTIP = "hideTier";

    public void setCachedTier(int var1);

    public int getCachedTier();

    default public int getTier(Level world, ItemStack stack) {
        if (EnchantmentHelper.m_44831_((ItemStack)stack).size() > 0) {
            return this.resolveTier(world, stack);
        }
        return this.getCachedTier();
    }

    default public int resolveTier(Level world, ItemStack stack) {
        List recipes = world.m_7465_().m_44051_().stream().filter(r -> {
            if (r == null) {
                return false;
            }
            ItemStack res = r.m_8043_(world.m_9598_());
            return res.m_41720_() == this;
        }).collect(Collectors.toList());
        if (recipes.size() == 0) {
            return -2;
        }
        Map itemEnchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (itemEnchantments.size() == 1) {
            recipes = recipes.stream().filter(r -> {
                Map enchs = EnchantmentHelper.m_44831_((ItemStack)r.m_8043_(world.m_9598_()));
                if (enchs.size() != 1) {
                    return false;
                }
                MutableBoolean match = new MutableBoolean(false);
                itemEnchantments.entrySet().forEach(e -> enchs.entrySet().forEach(e2 -> {
                    if (e.getKey() == e2.getKey() && e.getValue() == e2.getValue()) {
                        match.setTrue();
                    }
                }));
                return match.getValue();
            }).collect(Collectors.toList());
        }
        MutableInt lowest = new MutableInt(-2);
        recipes.stream().sorted((a, b) -> {
            if (a instanceof IMARecipe) {
                IMARecipe aR = (IMARecipe)a;
                if (b instanceof IMARecipe) {
                    IMARecipe bR = (IMARecipe)b;
                    return aR.getTier() < bR.getTier() ? -1 : (aR.getTier() > bR.getTier() ? 1 : 0);
                }
            }
            return -1;
        }).findFirst().ifPresent(r -> {
            if (r instanceof IMARecipe) {
                IMARecipe mR = (IMARecipe)r;
                lowest.setValue(mR.getTier());
            } else {
                lowest.setValue(0);
            }
        });
        return lowest.getValue();
    }
}

