/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.spells.targeting;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellTargetHelper {
    @Nullable
    public static EntityHitResult rayTraceEntities(Level world, Entity caster, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        return SpellTargetHelper.rayTraceEntities(world, caster, startVec, endVec, boundingBox, filter, Double.MAX_VALUE);
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(Level worldIn, @Nullable Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double max_distance) {
        double cur_distance = max_distance;
        Entity target_candidate = null;
        Vec3 target_pos = null;
        for (Entity entity : worldIn.m_6249_(projectile, boundingBox, filter)) {
            double entityDistance;
            AABB entityBoundingBox = entity.m_20191_().m_82400_((double)0.3f);
            Optional optional = entityBoundingBox.m_82371_(startVec, endVec);
            if (!optional.isPresent() || !((entityDistance = startVec.m_82557_((Vec3)optional.get())) < cur_distance)) continue;
            target_candidate = entity;
            cur_distance = entityDistance;
            target_pos = (Vec3)optional.get();
        }
        return target_candidate == null ? null : new EntityHitResult(target_candidate, target_pos);
    }

    @Nullable
    public static HitResult rayTrace(@Nullable Entity caster, Level world, Vec3 casterPosition, Vec3 casterLook, boolean checkEntityCollision, boolean includeCaster, ClipContext.Block blockModeIn, Predicate<Entity> filter, AABB boundingBox, double range) {
        Vec3 look_projected = casterPosition.m_82549_(casterLook.m_82542_(range, range, range));
        BlockHitResult raytraceresult = world.m_45547_(new ClipContext(casterPosition, look_projected, blockModeIn, ClipContext.Fluid.NONE, caster));
        if (checkEntityCollision) {
            EntityHitResult entity_trace_result;
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                look_projected = raytraceresult.m_82450_();
            }
            if ((entity_trace_result = SpellTargetHelper.rayTraceEntities(world, caster, casterPosition, look_projected, boundingBox, filter)) != null) {
                raytraceresult = entity_trace_result;
            }
        }
        return raytraceresult;
    }
}

