/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.blocks.tileentities.ConstructWorkbenchTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class ConstructWorkbenchBlock
extends WaterloggableBlockWithOffset
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private final BlockPos[] offsetsWE = new BlockPos[]{new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(0, 1, 0), new BlockPos(0, 1, -1), new BlockPos(0, 1, 1), new BlockPos(0, 2, 0), new BlockPos(0, 2, -1), new BlockPos(0, 2, 1)};
    private final BlockPos[] offsetsNS = new BlockPos[]{new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(-1, 1, 0), new BlockPos(1, 1, 0), new BlockPos(0, 2, 0), new BlockPos(-1, 2, 0), new BlockPos(1, 2, 0)};

    public ConstructWorkbenchBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_60978_(3.0f).m_60953_(b -> 15), false, new BlockPos[0]);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        BlockPos pos = context.m_8083_();
        for (BlockPos offset : this.getOffsets(state)) {
            FluidState flState;
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            if (context.m_43725_().m_46859_(offsetPos) || (flState = context.m_43725_().m_6425_(offsetPos)) != null && !flState.m_76178_() && (flState.m_76152_() == Fluids.f_76193_ || flState.m_76152_() == Fluids.f_76192_)) continue;
            return null;
        }
        return state;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ConstructWorkbenchTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.CONSTRUCT_WORKBENCH.get() ? (lvl, pos, state1, be) -> ConstructWorkbenchTile.Tick(lvl, pos, state1, (ConstructWorkbenchTile)be) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        ItemStack activeStack = player.m_21120_(handIn);
        ConstructWorkbenchTile te = (ConstructWorkbenchTile)worldIn.m_7702_(pos);
        if (te == null) {
            return InteractionResult.FAIL;
        }
        if (activeStack.m_41619_() && te.startCrafting(player)) {
            return InteractionResult.SUCCESS;
        }
        if (!(activeStack.m_41720_() instanceof ItemConstructPart)) {
            ItemStack pop = te.popPart();
            if (!pop.m_41619_() && !player.m_36356_(pop)) {
                player.m_19983_(pop);
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack result = te.placePart(activeStack);
        if (result.equals(activeStack)) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            activeStack.m_41774_(1);
        }
        if (!result.m_41619_() && !player.m_36356_(result)) {
            player.m_19983_(result);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropInventory(worldIn, pos, null);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos, @Nullable BlockEntity te) {
        if (world.f_46443_) {
            return;
        }
        ConstructWorkbenchTile wb = (ConstructWorkbenchTile)(te != null ? te : world.m_7702_(pos));
        if (wb != null) {
            for (ConstructSlot slot : ConstructSlot.values()) {
                wb.getConstruct().getPart(slot).ifPresent(p -> {
                    ItemEntity ie = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)p));
                    ie.m_32060_();
                    world.m_7967_((Entity)ie);
                });
            }
        }
    }

    @Override
    protected BlockPos[] getOffsets(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (dir == Direction.EAST || dir == Direction.WEST) {
            return this.offsetsWE;
        }
        return this.offsetsNS;
    }
}

