/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.blocks.WaterloggableBlock;
import com.mna.blocks.tileentities.LodestarTile;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class LodestarBlock
extends WaterloggableBlock
implements EntityBlock {
    public static final IntegerProperty SURFACE_TYPE = IntegerProperty.m_61631_((String)"surface", (int)1, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LOW_TIER = BooleanProperty.m_61465_((String)"low_tier");
    private final boolean low_tier;

    public LodestarBlock(boolean low_tier) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(5.0f, 1000.0f), false);
        this.low_tier = low_tier;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SURFACE_TYPE, FACING, LOW_TIER});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)LOW_TIER)).booleanValue()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
            }
            return Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
        }
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)18.0, (double)14.0);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face;
        int surfaceType;
        if (this.low_tier) {
            return (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)SURFACE_TYPE, (Comparable)Integer.valueOf(3))).m_61124_((Property)LOW_TIER, (Comparable)Boolean.valueOf(this.low_tier));
        }
        if (context.m_43719_() == Direction.UP) {
            surfaceType = 1;
            face = context.m_8125_().m_122424_();
        } else if (context.m_43719_() == Direction.DOWN) {
            surfaceType = 2;
            face = context.m_8125_().m_122424_();
        } else {
            surfaceType = 3;
            face = context.m_43719_();
        }
        return (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)SURFACE_TYPE, (Comparable)Integer.valueOf(surfaceType))).m_61124_((Property)LOW_TIER, (Comparable)Boolean.valueOf(this.low_tier));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        LodestarTile lodestar;
        if (!worldIn.f_46443_ && (lodestar = (LodestarTile)worldIn.m_7702_(pos)) != null) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)lodestar, (Consumer)lodestar);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LOW_TIER) != false ? 0 : 10;
    }

    public RenderShape m_7514_(BlockState state) {
        return this.low_tier ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LodestarTile(pos, state);
    }
}

