/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.runeforging;

import com.mna.api.blocks.IManaweaveNotifiable;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.api.tools.MATags;
import com.mna.blocks.BlockInit;
import com.mna.blocks.runeforging.RuneforgeBlock;
import com.mna.blocks.tileentities.PedestalTile;
import com.mna.items.ItemInit;
import com.mna.items.manaweaving.ItemManaweaveBottle;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PedestalBlock
extends WaterloggableBlock
implements ICutoutBlock,
EntityBlock,
IManaweaveNotifiable {
    public static final BooleanProperty SHOW_SIGN = BooleanProperty.m_61465_((String)"show_sign");
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    public static final BooleanProperty BRIMSTONE = BooleanProperty.m_61465_((String)"brimstone");
    private static final Direction[] CONNECTION_DIRS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5);
    private final boolean showSign;

    public PedestalBlock(boolean withSign) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(3.0f).m_60955_().m_60918_(SoundType.f_56742_), false);
        this.showSign = withSign;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)SHOW_SIGN, (Comparable)Boolean.valueOf(this.showSign))).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BRIMSTONE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, SHOW_SIGN, CONNECTED, PipeBlock.f_55148_, PipeBlock.f_55150_, PipeBlock.f_55149_, PipeBlock.f_55151_, BRIMSTONE});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PedestalTile(pos, state);
    }

    public VoxelShape m_5940_(BlockState p_48816_, BlockGetter p_48817_, BlockPos p_48818_, CollisionContext p_48819_) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        ItemStack activeStack = player.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof PedestalTile) {
            PedestalTile te = (PedestalTile)tileEntity;
            if (!te.m_7983_()) {
                ItemStack stack = te.m_7407_(0, 1);
                if (!player.m_36356_(stack)) {
                    player.m_36176_(stack, true);
                }
            } else if (!activeStack.m_41619_() && te.m_7983_()) {
                ItemStack single = activeStack.m_41777_();
                single.m_41764_(1);
                te.m_6836_(0, single);
                if (!player.m_7500_()) {
                    activeStack.m_41774_(1);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        PedestalTile pt;
        ItemStack displayed;
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof PedestalTile && !(displayed = (pt = (PedestalTile)te).getDisplayedItem()).m_41619_()) {
            if (MATags.isItemIn(displayed.m_41720_(), MATags.Items.BRIGHT_PEDESTAL_ITEMS)) {
                return 15;
            }
            if (MATags.isItemIn(displayed.m_41720_(), MATags.Items.DIM_PEDESTAL_ITEMS)) {
                return 10;
            }
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropInventory(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private BlockState updateStateBasedOnNeighbors(LevelReader world, BlockPos pos, BlockState state) {
        state = (BlockState)state.m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)BRIMSTONE, (Comparable)Boolean.valueOf(false));
        for (Direction offset : CONNECTION_DIRS) {
            BlockState neighborState = world.m_8055_(pos.m_121955_(offset.m_122436_()));
            state = this.calculateStateForSingleNeighbor(state, neighborState, offset);
        }
        return state;
    }

    private BlockState calculateStateForSingleNeighbor(BlockState state, BlockState neighborState, Direction offset) {
        if (neighborState.m_60734_() == BlockInit.RUNEFORGE.get()) {
            Direction neighborDir = (Direction)neighborState.m_61143_((Property)RuneforgeBlock.FACING);
            boolean didConnect = false;
            if (neighborDir == Direction.EAST || neighborDir == Direction.WEST) {
                if (offset == Direction.NORTH) {
                    state = (BlockState)state.m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(true));
                    didConnect = true;
                } else if (offset == Direction.SOUTH) {
                    state = (BlockState)state.m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(true));
                    didConnect = true;
                }
            } else if (offset == Direction.EAST) {
                state = (BlockState)state.m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(true));
                didConnect = true;
            } else if (offset == Direction.WEST) {
                state = (BlockState)state.m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(true));
                didConnect = true;
            }
            if (didConnect) {
                state = (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(true));
                if ((Integer)neighborState.m_61143_((Property)RuneforgeBlock.MATERIAL) == 1) {
                    state = (BlockState)state.m_61124_((Property)BRIMSTONE, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return state;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        stateIn = (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(false));
        stateIn = (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(false));
        stateIn = (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(false));
        stateIn = (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(false));
        stateIn = (BlockState)stateIn.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
        stateIn = (BlockState)stateIn.m_61124_((Property)BRIMSTONE, (Comparable)Boolean.valueOf(false));
        stateIn = this.calculateStateForSingleNeighbor(stateIn, facingState, facing);
        stateIn = this.updateStateBasedOnNeighbors((LevelReader)worldIn, currentPos, stateIn);
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        state = this.updateStateBasedOnNeighbors((LevelReader)context.m_43725_(), context.m_8083_(), state);
        return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean isBreak) {
        BlockState updateState = this.updateStateBasedOnNeighbors((LevelReader)world, pos, state);
        if (!world.m_5776_()) {
            world.m_7731_(pos, updateState, 3);
        }
        super.m_6861_(state, world, pos, block, neighborPos, isBreak);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (world.m_8055_(neighbor).m_60734_() == BlockInit.RUNEFORGE.get()) {
            state.m_60690_((Level)world, pos, world.m_8055_(neighbor).m_60734_(), neighbor, false);
        }
        super.onNeighborChange(state, world, pos, neighbor);
    }

    private void dropInventory(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof PedestalTile) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileEntity));
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null && te instanceof PedestalTile) {
            return AbstractContainerMenu.m_38938_((Container)((PedestalTile)te));
        }
        return 0;
    }

    @Override
    public boolean notify(Level world, BlockPos pos, BlockState state, List<IManaweavePattern> patterns, LivingEntity activator) {
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) != null && te instanceof PedestalTile && ((PedestalTile)te).m_8020_(0).m_41720_() == Items.f_42590_) {
            ItemStack bottle = new ItemStack((ItemLike)ItemInit.MANAWEAVE_BOTTLE.get());
            ItemManaweaveBottle.setPattern(patterns.get(0), bottle);
            ((PedestalTile)te).m_6836_(0, bottle);
            world.m_7260_(pos, state, state, 3);
            return true;
        }
        return false;
    }
}

