/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.runeforging;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.events.RunicAnvilItemUsedEvent;
import com.mna.api.sound.SFX;
import com.mna.api.tools.MATags;
import com.mna.blocks.tileentities.RunicAnvilTile;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.items.ItemInit;
import com.mna.items.armor.BrokenMageArmor;
import com.mna.items.ritual.ItemPractitionersPatch;
import com.mna.items.ritual.ItemPractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.runes.ItemRune;
import com.mna.items.runes.ItemRunescribingRecipe;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.runeforging.RuneforgingRecipe;
import com.mna.recipes.runeforging.RunescribingRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class RunicAnvilBlock
extends WaterloggableBlock
implements ICutoutBlock,
EntityBlock {
    protected static final VoxelShape SHAPE_BASE_WE = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0);
    protected static final VoxelShape SHAPE_HEAD_WE = Block.m_49796_((double)4.0, (double)13.0, (double)-3.0, (double)12.0, (double)16.0, (double)19.0);
    protected static final VoxelShape SHAPE_BASE_NS = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)13.0, (double)12.0);
    protected static final VoxelShape SHAPE_HEAD_NS = Block.m_49796_((double)-3.0, (double)13.0, (double)4.0, (double)19.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_WE = Shapes.m_83110_((VoxelShape)SHAPE_BASE_WE, (VoxelShape)SHAPE_HEAD_WE);
    protected static final VoxelShape SHAPE_NS = Shapes.m_83110_((VoxelShape)SHAPE_BASE_NS, (VoxelShape)SHAPE_HEAD_NS);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final ResourceLocation TAG_COALS = new ResourceLocation("coals");

    public RunicAnvilBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(2.0f, 3.0f).m_60955_().m_60918_(SoundType.f_56749_), false);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ACTIVE});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return SHAPE_WE;
        }
        return SHAPE_NS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RunicAnvilTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        ItemStack activeStack = player.m_21120_(handIn);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity == null && !(tileEntity instanceof RunicAnvilTile)) {
            return InteractionResult.SUCCESS;
        }
        RunicAnvilTile te = (RunicAnvilTile)tileEntity;
        if (activeStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get() || activeStack.m_41720_() == ItemInit.RUNIC_MALUS.get()) {
            return this.onHammerUse(activeStack, player, worldIn, pos, state, te);
        }
        if (MATags.isItemEqual(activeStack, TAG_COALS)) {
            return this.onCharcoalUse(activeStack, player, worldIn, pos, state, te);
        }
        if (activeStack.m_41720_() == ItemInit.SORCEROUS_SEWING_SET.get()) {
            return this.onSewingKitUse(activeStack, player, worldIn, pos, state, te);
        }
        return this.onGenericItemUse(activeStack, player, worldIn, pos, state, te, handIn);
    }

    private InteractionResult onGenericItemUse(ItemStack activeStack, Player player, Level worldIn, BlockPos pos, BlockState state, RunicAnvilTile te, InteractionHand hand) {
        if (!worldIn.f_46443_) {
            IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression == null) {
                return InteractionResult.FAIL;
            }
            RunicAnvilItemUsedEvent event = new RunicAnvilItemUsedEvent(te.m_8020_(0), te.m_8020_(1), activeStack, player);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                te.m_6836_(0, event.pattern.m_41619_() ? ItemStack.f_41583_ : event.pattern.m_41777_());
                te.m_6836_(1, event.material.m_41619_() ? ItemStack.f_41583_ : event.material.m_41777_());
                player.m_21008_(hand, event.catalyst.m_41619_() ? ItemStack.f_41583_ : event.catalyst.m_41777_());
                return InteractionResult.SUCCESS;
            }
            ItemStack existing = te.m_8020_(0);
            if (!(existing.m_41720_() != ItemInit.RUNESMITH_HAMMER.get() && existing.m_41720_() != ItemInit.RUNIC_MALUS.get() || activeStack.m_41619_())) {
                te.m_6836_(0, ItemStack.f_41583_);
                if (this.insertItems(te, player, activeStack, worldIn, pos, state, progression.getTier())) {
                    if (!player.m_36356_(existing)) {
                        player.m_36176_(existing, true);
                    }
                } else {
                    te.m_6836_(0, existing);
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.insertItems(te, player, activeStack, worldIn, pos, state, progression.getTier())) {
                this.removeItems(te, player, activeStack, worldIn, pos, state);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult onCharcoalUse(ItemStack activeStack, Player player, Level worldIn, BlockPos pos, BlockState state, RunicAnvilTile te) {
        ItemStack rune = te.m_8020_(0);
        if (rune.m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (te.m_8020_(1).m_41720_() != Items.f_42516_) {
            return InteractionResult.FAIL;
        }
        Optional<RuneforgingRecipe> forgeRecipe = worldIn.m_7465_().m_44013_((RecipeType)RecipeInit.RUNEFORGING_TYPE.get()).stream().filter(r -> r.getOutputResource().toString().equals(ForgeRegistries.ITEMS.getKey((Object)rune.m_41720_()).toString())).findFirst();
        if (!forgeRecipe.isPresent()) {
            return InteractionResult.FAIL;
        }
        Optional<RunescribingRecipe> scribeRecipe = worldIn.m_7465_().m_44013_((RecipeType)RecipeInit.RUNESCRIBING_TYPE.get()).stream().filter(r -> r.getOutputResource().toString().equals(((RuneforgingRecipe)forgeRecipe.get()).getPatternResource().toString())).findFirst();
        if (!scribeRecipe.isPresent()) {
            return InteractionResult.FAIL;
        }
        ItemStack patternStack = new ItemStack((ItemLike)ItemInit.RECIPE_SCRAP_RUNESCRIBING.get());
        ItemRunescribingRecipe.setRecipe(patternStack, scribeRecipe.get());
        if (!worldIn.f_46443_) {
            te.m_6836_(1, patternStack);
        }
        worldIn.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SFX.Gui.CHARCOAL_SCRIBBLE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_7500_()) {
            activeStack.m_41774_(1);
        }
        if (!worldIn.f_46443_ && player instanceof ServerPlayer) {
            CustomAdvancementTriggers.RUNIC_ANVIL_CRAFT.trigger((ServerPlayer)player, patternStack);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult onHammerUse(ItemStack activeStack, Player player, Level worldIn, BlockPos pos, BlockState state, RunicAnvilTile te) {
        if (player.m_36335_().m_41521_(activeStack.m_41720_(), 0.0f) > 0.0f) {
            return InteractionResult.SUCCESS;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return InteractionResult.FAIL;
        }
        if (worldIn.f_46443_) {
            Item item = te.m_8020_(1).m_41720_();
            this.spawnParticles(item, worldIn, pos);
        }
        int advanceResponse = te.advanceCrafting(player, progression.getTier());
        if (!worldIn.f_46443_) {
            worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, (float)Math.random() * 0.1f + 0.9f);
            if (advanceResponse == 0 || advanceResponse == 4) {
                player.m_36335_().m_41524_(activeStack.m_41720_(), 10);
            } else if (advanceResponse == 2) {
                player.m_213846_((Component)Component.m_237115_((String)"block.mna.runic_anvil.low_tier"));
                player.m_36335_().m_41524_(activeStack.m_41720_(), 40);
            } else if (te.m_8020_(0).m_41619_()) {
                this.insertItems(te, player, activeStack, worldIn, pos, state, progression.getTier());
            }
        }
        activeStack.m_41622_(1, (LivingEntity)player, e -> {});
        return InteractionResult.SUCCESS;
    }

    private InteractionResult onSewingKitUse(ItemStack activeStack, Player player, Level worldIn, BlockPos pos, BlockState state, RunicAnvilTile te) {
        ItemStack sewable = te.m_8020_(0);
        if (sewable.m_41720_() instanceof BrokenMageArmor) {
            if (te.m_8020_(1).m_41720_() != ItemInit.INFUSED_SILK.get()) {
                return InteractionResult.FAIL;
            }
            BrokenMageArmor restoredItem = (BrokenMageArmor)sewable.m_41720_();
            ItemStack restoredStack = restoredItem.restore(sewable);
            restoredStack.m_41721_(0);
            te.m_6836_(1, ItemStack.f_41583_);
            activeStack.m_41622_(1, (LivingEntity)player, e -> {});
            if (player instanceof ServerPlayer) {
                CustomAdvancementTriggers.RUNIC_ANVIL_CRAFT.trigger((ServerPlayer)player, restoredStack);
            }
            worldIn.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
            te.m_6836_(0, restoredStack);
            return InteractionResult.SUCCESS;
        }
        if (sewable.m_41720_() instanceof ItemPractitionersPouch) {
            ItemStack patchStack = te.m_8020_(1);
            if (!(patchStack.m_41720_() instanceof ItemPractitionersPatch)) {
                return InteractionResult.FAIL;
            }
            PractitionersPouchPatches patch = ((ItemPractitionersPatch)patchStack.m_41720_()).getPatch();
            int patchLevel = ((ItemPractitionersPatch)patchStack.m_41720_()).getLevel();
            if (((ItemPractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).getPatchLevel(sewable, patch) >= patchLevel) {
                return InteractionResult.FAIL;
            }
            if (((ItemPractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).countAppliedPatchesForLimit(sewable, patchStack) >= 4) {
                return InteractionResult.FAIL;
            }
            ((ItemPractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).addPatch(sewable, patch, patchLevel);
            te.m_6836_(1, ItemStack.f_41583_);
            activeStack.m_41622_(1, (LivingEntity)player, e -> {});
            worldIn.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(player, ProgressionEventIDs.APPLY_POUCH_PATCH));
                if (player instanceof ServerPlayer) {
                    CustomAdvancementTriggers.RUNIC_ANVIL_CRAFT.trigger((ServerPlayer)player, sewable);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void spawnParticles(Item item, Level worldIn, BlockPos pos) {
        block3: {
            block2: {
                if (item != ItemInit.VINTEUM_INGOT_SUPERHEATED.get()) break block2;
                for (int i = 0; i < 3; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.1f), (double)((float)pos.m_123343_() + 0.5f), -0.5 + Math.random(), Math.random(), -0.5 + Math.random());
                }
                break block3;
            }
            if (!(item instanceof ItemRune)) break block3;
            for (int i = 0; i < 3; ++i) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123797_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.1f), (double)((float)pos.m_123343_() + 0.5f), -0.5 + Math.random(), Math.random(), -0.5 + Math.random());
            }
        }
    }

    private boolean insertItems(RunicAnvilTile te, Player player, ItemStack heldStack, Level world, BlockPos pos, BlockState state, int playerTier) {
        ItemStack single = heldStack.m_41777_();
        single.m_41764_(1);
        if (te.pushItemStack(single, player, playerTier)) {
            if (!player.m_7500_() || heldStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get()) {
                heldStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private void removeItems(RunicAnvilTile te, Player player, ItemStack heldStack, Level world, BlockPos pos, BlockState state) {
        ItemStack stack = te.popItemStack();
        if (!stack.m_41619_() && !player.m_36356_(stack)) {
            player.m_36176_(stack, true);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropInventory(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileEntity));
        }
    }
}

