/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.sorcery;

import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.FacingBlock;
import com.mna.blocks.tileentities.IceSpikeTile;
import com.mna.entities.boss.Odin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.Nullable;

public class IceSpikeBlock
extends FacingBlock
implements ITranslucentBlock,
IDontCreateBlockItem,
EntityBlock {
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public IceSpikeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283828_).m_60966_().m_60910_().m_222994_().m_60955_());
    }

    protected boolean isAir(BlockState state) {
        return false;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pRandom.m_188499_()) {
            return;
        }
        Vec3 center = Vec3.m_82528_((Vec3i)pPos).m_82520_(pRandom.m_188500_(), pRandom.m_188500_(), pRandom.m_188500_());
        if (pRandom.m_188499_()) {
            pLevel.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setGravity(0.01f), center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        } else {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175821_, center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        int face = (Integer)p_60555_.m_61143_((Property)FacingBlock.SURFACE_TYPE);
        switch (face) {
            case 2: {
                return SHAPE_DOWN;
            }
            case 3: {
                Direction dir = (Direction)p_60555_.m_61143_((Property)FacingBlock.FACING);
                switch (dir) {
                    case SOUTH: {
                        return SHAPE_SOUTH;
                    }
                    case WEST: {
                        return SHAPE_WEST;
                    }
                    case EAST: {
                        return SHAPE_EAST;
                    }
                }
                return SHAPE_NORTH;
            }
        }
        return SHAPE_UP;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        if (context.m_43725_() instanceof ServerLevel) {
            FakePlayer fp = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)context.m_43725_()));
            if (!Block.m_49918_((VoxelShape)blockstate.m_60734_().m_5939_(blockstate, (BlockGetter)context.m_43725_(), context.m_8083_(), CollisionContext.m_82750_((Entity)fp)), (Direction)context.m_43719_())) {
                return null;
            }
        }
        Direction[] random_values = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};
        BlockState state = super.m_5573_(context);
        if ((Integer)state.m_61143_((Property)FacingBlock.SURFACE_TYPE) != 3) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)random_values[(int)(Math.random() * (double)random_values.length)]);
        }
        return state;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        if (mob instanceof Odin) {
            return BlockPathTypes.OPEN;
        }
        return BlockPathTypes.DANGER_POWDER_SNOW;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof Odin) {
            return;
        }
        if (pEntity instanceof LivingEntity && (pEntity.f_19790_ != pEntity.m_20185_() || pEntity.f_19792_ != pEntity.m_20189_())) {
            LivingEntity living = (LivingEntity)pEntity;
            living.m_7601_(pState, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!pLevel.m_5776_() && !living.m_21023_(MobEffects.f_19597_)) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            }
            living.m_146917_(living.m_146888_() + 1);
            double d0 = Math.abs(pEntity.m_20185_() - pEntity.f_19790_);
            double d1 = Math.abs(pEntity.m_20189_() - pEntity.f_19792_);
            if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                pEntity.m_6469_(pEntity.m_269291_().m_269109_(), 1.0f);
            }
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new IceSpikeTile(pPos, pState);
    }
}

