/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.sorcery;

import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.FacingBlock;
import com.mna.blocks.tileentities.ImpaleSpikeTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ImpaleBlock
extends FacingBlock
implements ITranslucentBlock,
IDontCreateBlockItem,
EntityBlock {
    private static final VoxelShape SHAPE_UP = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Block.m_49796_((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)18.0, (double)9.0)});
    private static final VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0), Block.m_49796_((double)12.0, (double)7.0, (double)7.0, (double)18.0, (double)9.0, (double)9.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0, (double)6.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)12.0), Block.m_49796_((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)18.0)});
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)13.0), Block.m_49796_((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)7.0, (double)7.0, (double)-2.0, (double)9.0, (double)9.0, (double)4.0)});
    private static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0), Block.m_49796_((double)4.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)-2.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0)});
    private static final VoxelShape SHAPE_DOWN = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)7.0, (double)-2.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0)});

    public ImpaleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60966_().m_222994_().m_60955_());
    }

    protected boolean isAir(BlockState state) {
        return false;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pRandom.m_188499_()) {
            return;
        }
        Vec3 center = Vec3.m_82528_((Vec3i)pPos).m_82520_(pRandom.m_188500_(), pRandom.m_188500_(), pRandom.m_188500_());
        if (pRandom.m_188499_()) {
            pLevel.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())).setGravity(0.01f), center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        } else {
            pLevel.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setGravity(0.01f), center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        int face = (Integer)p_60555_.m_61143_((Property)FacingBlock.SURFACE_TYPE);
        switch (face) {
            case 2: {
                return SHAPE_DOWN;
            }
            case 3: {
                Direction dir = (Direction)p_60555_.m_61143_((Property)FacingBlock.FACING);
                switch (dir) {
                    case SOUTH: {
                        return SHAPE_SOUTH;
                    }
                    case WEST: {
                        return SHAPE_WEST;
                    }
                    case EAST: {
                        return SHAPE_EAST;
                    }
                }
                return SHAPE_NORTH;
            }
        }
        return SHAPE_UP;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        if (context.m_43725_() instanceof ServerLevel) {
            FakePlayer fp = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)context.m_43725_()));
            if (!Block.m_49918_((VoxelShape)blockstate.m_60734_().m_5939_(blockstate, (BlockGetter)context.m_43725_(), context.m_8083_(), CollisionContext.m_82750_((Entity)fp)), (Direction)context.m_43719_())) {
                return null;
            }
        }
        Direction[] random_values = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};
        BlockState state = super.m_5573_(context);
        if ((Integer)state.m_61143_((Property)FacingBlock.SURFACE_TYPE) != 3) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)random_values[(int)(Math.random() * (double)random_values.length)]);
        }
        return state;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ImpaleSpikeTile(pPos, pState);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance * 2.0f, 3.0f, entity.m_269291_().m_268989_());
    }
}

