/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.sorcery;

import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.tileentities.ManaCrystalTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ManaCrystalBlock
extends WaterloggableBlock
implements ITranslucentBlock,
EntityBlock {
    protected static final VoxelShape SHAPE_NORMAL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)25.5, (double)16.0);
    protected static final VoxelShape SHAPE_HANGING = Block.m_49796_((double)0.0, (double)-9.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty HANGING = BooleanProperty.m_61465_((String)"hanging");

    public ManaCrystalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60955_().m_60918_(SoundType.f_56744_).m_60988_(), false);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean hanging = false;
        if (context.m_43719_() == Direction.DOWN) {
            hanging = true;
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HANGING});
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn.f_46443_ && rand.m_188499_()) {
            Vec3 origin = this.getRandomPointAroundBlock(pos, stateIn, true);
            Vec3 dest = this.getRandomPointAroundBlock(pos, stateIn, false);
            worldIn.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), origin.f_82479_, origin.f_82480_, origin.f_82481_, dest.f_82479_, dest.f_82480_, dest.f_82481_);
        }
    }

    private Vec3 getRandomPointAroundBlock(BlockPos pos, BlockState state, boolean touch) {
        return new Vec3(touch ? (double)pos.m_123341_() + 0.15 + Math.random() * 0.7 : (double)pos.m_123341_() + Math.random(), (double)(pos.m_123342_() + ((Boolean)state.m_61143_((Property)HANGING) != false ? 0 : 1)) - 0.5 + Math.random(), touch ? (double)pos.m_123343_() + 0.15 + Math.random() * 0.7 : (double)pos.m_123343_() + Math.random());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ManaCrystalTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.MANA_CRYSTAL.get() && !level.m_5776_() ? (lvl, pos, state1, be) -> ManaCrystalTile.ServerTick(lvl, pos, state1, (ManaCrystalTile)be) : null;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 10;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? SHAPE_HANGING : SHAPE_NORMAL;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

