/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.sorcery;

import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.blocks.tileentities.TransitoryTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;

public class TransitoryTileBlock
extends Block
implements ITranslucentBlock,
IDontCreateBlockItem,
EntityBlock {
    public static final IntegerProperty DURATION = IntegerProperty.m_61631_((String)"duration", (int)0, (int)30);

    public TransitoryTileBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283892_).m_60978_(1.0f).m_60955_().m_60971_((state, reader, pos) -> false));
    }

    public boolean m_7420_(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DURATION});
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (worldIn instanceof ServerLevel) {
            this.checkNeighbors((LevelReader)worldIn, pos);
        }
    }

    public void m_6402_(Level p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        p_180633_1_.m_46672_(p_180633_2_, (Block)this);
    }

    private void checkNeighbors(LevelReader worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null && te instanceof TransitoryTile) {
            for (Direction d : Direction.values()) {
                BlockPos directionOffset = pos.m_121955_(d.m_122436_());
                BlockState directionState = worldIn.m_8055_(directionOffset);
                if (directionState.m_60734_() != this) continue;
                ((TransitoryTile)te).setNeighborOnSide(d);
                BlockEntity neighbor = worldIn.m_7702_(directionOffset);
                if (neighbor == null || !(neighbor instanceof TransitoryTile)) continue;
                ((TransitoryTile)neighbor).setNeighborOnSide(d.m_122424_());
            }
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity te;
        if (!world.m_5776_() && (te = world.m_7702_(pos)) != null && te instanceof TransitoryTile) {
            BlockState neighborState = world.m_8055_(neighbor);
            if (neighborState.m_60734_() == this) {
                ((TransitoryTile)te).setNeighborOnSide(this.directionBetweenPositions(pos, neighbor));
            } else {
                ((TransitoryTile)te).clearNeighborOnSide(this.directionBetweenPositions(pos, neighbor));
            }
        }
    }

    @Nullable
    private Direction directionBetweenPositions(BlockPos a, BlockPos b) {
        if (a.m_7494_().equals((Object)b)) {
            return Direction.UP;
        }
        if (a.m_7495_().equals((Object)b)) {
            return Direction.DOWN;
        }
        if (a.m_122029_().equals((Object)b)) {
            return Direction.EAST;
        }
        if (a.m_122024_().equals((Object)b)) {
            return Direction.WEST;
        }
        if (a.m_122012_().equals((Object)b)) {
            return Direction.NORTH;
        }
        if (a.m_122019_().equals((Object)b)) {
            return Direction.SOUTH;
        }
        return null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TransitoryTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.TRANSITORY_TILE.get() ? (lvl, pos, state1, be) -> TransitoryTile.Tick(lvl, pos, state1, (TransitoryTile)be) : null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void setColor(Level world, BlockPos pos, int color) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof TransitoryTile) {
            TransitoryTile tile = (TransitoryTile)te;
            tile.setColor(color);
        }
    }

    public boolean m_5946_(BlockState pState, Fluid pFluid) {
        return false;
    }
}

