/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.Registries;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.IRequirePlayerReference;
import com.mna.api.blocks.tile.BlockPosCache;
import com.mna.api.blocks.tile.IEldrinCapacitorTile;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.blocks.tile.IMultiblockDefinition;
import com.mna.api.blocks.tile.MultiblockTile;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.events.EldrinCraftingEvent;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.PedestalTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.entities.utility.PresentItem;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.to_client.SpawnParticleEffectMessage;
import com.mna.particles.types.movers.ParticleBezierMover;
import com.mna.particles.types.movers.ParticleLerpMover;
import com.mna.particles.types.movers.ParticleSphereOrbitMover;
import com.mna.particles.types.movers.ParticleVelocityMover;
import com.mna.recipes.ItemAndPatternCraftingInventory;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.eldrin.EldrinAltarRecipe;
import com.mna.sound.PredicateLoopingSound;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.MultiblockRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class EldrinAltarTile
extends MultiblockTile
implements IForgeBlockEntity,
IRequirePlayerReference<EldrinAltarTile>,
IEldrinConsumerTile {
    private static final int MAX_ITEMS = 1;
    public static final int INVENTORY_SLOT_INDEX = 0;
    public static final int CONSUME_RATE = 10;
    public static final Vec3[] crystal_offsets = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.5, 0.0, 1.0), new Vec3(-0.5, 0.0, 1.0), new Vec3(0.5, 0.0, -1.0), new Vec3(-0.5, 0.0, -1.0)};
    private int stage = Stage.IDLE.ordinal();
    private int stageTicks = 0;
    private EldrinAltarRecipe __cachedRecipe;
    private ResourceLocation __cachedRecipeId;
    private BlockPosCache __powerSuppliers;
    private int lastCraftTier = 0;
    private IFaction lastCraftFaction = null;
    private HashMap<Affinity, Float> lastCraftEldrin;
    private ResourceLocation lastCraftRecipeID;
    private EldrinAltarRecipe _lastCraftRecipe;
    private NonNullList<ItemStack> lastCraftItems;
    private NonNullList<ItemStack> lastCraftItemsMerged;
    private ItemStack lastCraftOutput = ItemStack.f_41583_;
    private HashMap<Affinity, Float> consumedPower;
    private HashMap<Affinity, Boolean> powerRequirementStatus;
    private UUID __crafterID;
    private Player __crafter;
    private final ArrayList<ActiveCrystal> activeCrystals = new ArrayList();
    private final ArrayList<CollectedItem> collectedItems = new ArrayList();

    public EldrinAltarTile(BlockEntityType<?> p_i48289_1_, BlockPos pos, BlockState state) {
        super(p_i48289_1_, RLoc.create("multiblock/eldrin_altar"), pos, state, 1);
        this.__powerSuppliers = new BlockPosCache(this, 7, (bp, world) -> {
            if (!this.losCheck(bp.m_7494_())) {
                return false;
            }
            BlockEntity te = this.m_58904_().m_7702_(bp);
            return te != null && te instanceof IEldrinCapacitorTile && ((IEldrinCapacitorTile)te).canSupply(Affinity.UNKNOWN, this.__crafter);
        });
        this.consumedPower = new HashMap();
        this.powerRequirementStatus = new HashMap();
        this.lastCraftEldrin = new HashMap();
        this.lastCraftItems = NonNullList.m_122779_();
        this.lastCraftItemsMerged = NonNullList.m_122779_();
    }

    protected boolean losCheck(BlockPos pos) {
        Vec3 vector3d = Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_());
        Vec3 vector3d1 = Vec3.m_82512_((Vec3i)pos);
        BlockHitResult result = this.m_58904_().m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return result.m_82425_().equals((Object)pos);
        }
        return false;
    }

    public EldrinAltarTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.ELDRIN_ALTAR_TILE.get(), pos, state);
    }

    public Stage getStage() {
        return Stage.values()[this.stage];
    }

    public int getStageTicks() {
        return this.stageTicks;
    }

    private void setStage(Stage stage) {
        this.stage = stage.ordinal();
        this.stageTicks = 0;
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private EldrinAltarRecipe getCachedRecipe() {
        if (this.__cachedRecipe == null && this.__cachedRecipeId != null) {
            this.m_58904_().m_7465_().m_44043_(this.__cachedRecipeId).ifPresent(r -> {
                if (r instanceof EldrinAltarRecipe) {
                    this.__cachedRecipe = (EldrinAltarRecipe)r;
                }
            });
        }
        return this.__cachedRecipe;
    }

    private Player getCrafter() {
        if (this.__crafter == null && this.__crafterID != null) {
            this.__crafter = this.m_58904_().m_46003_(this.__crafterID);
        }
        return this.__crafter;
    }

    @Override
    public void setPlayerReference(Player player) {
        this.__crafter = player;
        this.__crafterID = player.m_20148_();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(5.0);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, EldrinAltarTile tile) {
        MultiblockTile.Tick(level, pos, state, tile);
        tile.__powerSuppliers.tick();
        ++tile.stageTicks;
        if (level.m_5776_()) {
            tile.spawnParticles();
            tile.playSounds();
        } else {
            switch (tile.getStage()) {
                case FINDING_POWER: {
                    tile.tickLogic_findPower();
                    break;
                }
                case CONSUMING_POWER: {
                    tile.tickLogic_consumePower();
                    break;
                }
                case CONSUMING_REAGENTS: {
                    tile.tickLogic_consumeReagents();
                    break;
                }
                case CRAFTING: {
                    tile.tickLogic_craft();
                    break;
                }
                case COMPLETING: {
                    tile.tickLogic_complete();
                    break;
                }
            }
        }
    }

    public boolean structureMatched() {
        return this.structureMatched;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGhostMultiblock() {
        if (!this.structureMatched) {
            this.match(true);
            if (!this.structureMatched) {
                this.getDefinition().ifPresent(r -> {
                    BlockPos anchorPos = this.getMatchOrigin();
                    MultiblockRenderer.setMultiblock(r, (Component)Component.m_237115_((String)r.m_6423_().toString()), false);
                    MultiblockRenderer.anchorTo(anchorPos, Rotation.NONE);
                });
            }
        }
    }

    public HashMap<Affinity, Boolean> getPowerRequirementStatus() {
        return this.powerRequirementStatus;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        if (this.getStage() != Stage.IDLE) {
            this.spawnParticles_active();
            this.spawnParticles_crystals();
            this.spawnParticles_items();
            this.spawnParticles_lights();
            this.spawnParticles_power();
        }
    }

    private void spawnParticles_power() {
        for (Affinity aff : Affinity.values()) {
            if (!this.consumedPower.containsKey((Object)aff) || !(this.consumedPower.get((Object)aff).floatValue() >= 0.0f)) continue;
            for (int i = 0; i < 10; ++i) {
                MAParticleType particle = null;
                switch (aff) {
                    case ARCANE: {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get()));
                        break;
                    }
                    case EARTH: {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get()));
                        break;
                    }
                    case ENDER: {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get()));
                        break;
                    }
                    case FIRE: 
                    case HELLFIRE: 
                    case LIGHTNING: {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get()));
                        break;
                    }
                    case WATER: 
                    case ICE: {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get()));
                        break;
                    }
                    case WIND: {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10);
                        break;
                    }
                }
                if (particle == null) continue;
                Vec3 particlePos = Vec3.m_82512_((Vec3i)this.f_58858_);
                particle.setMover(new ParticleSphereOrbitMover(particlePos.f_82479_, particlePos.f_82480_ + 1.25, particlePos.f_82481_, 0.01f, Math.random() * 360.0, 1.5));
                this.m_58904_().m_7106_((ParticleOptions)particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_active() {
        int i;
        int angleStep = 60;
        Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82492_(0.0, 0.5, 0.0);
        for (i = 0; i < 360; i += angleStep) {
            double angle = (double)((i + this.stageTicks) % 360) * Math.PI / 180.0;
            Vec3 offset = center.m_82549_(new Vec3(Math.sin(angle), 0.0, Math.cos(angle)).m_82541_().m_82490_(4.0)).m_82520_(0.0, 1.0, 0.0);
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_ORBIT.get())).setScale(0.25f).setMaxAge(50).setColor(2, 1, 5).setMover(new ParticleBezierMover(center, offset)), center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.stageTicks == 1) {
            angleStep = 10;
            for (i = 0; i <= 360; i += angleStep) {
                int angle = (i + this.stageTicks * 2) % 360;
                Vec3 offset = new Vec3(Math.sin((double)angle * Math.PI / 180.0), 0.0, Math.cos((double)angle * Math.PI / 180.0)).m_82541_().m_82490_(0.1);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setScale(0.5f).setMaxAge(20), center.f_82479_, center.f_82480_, center.f_82481_, offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_crystals() {
        this.activeCrystals.forEach(e -> {
            Vec3 offset = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82549_(crystal_offsets[e.offsetIndex]);
            Vec3 crystalWidth = new Vec3(0.1, 0.0, 0.1);
            int[] color = e.affinity.getShiftAffinity().getColor();
            for (int i = 0; i < 5; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType(((MAParticleType)((Object)((Object)ParticleInit.LIGHT_VELOCITY.get()))).setColor(color[0], color[1], color[2])), offset.f_82479_ - crystalWidth.f_82479_ + Math.random() * crystalWidth.f_82479_ * 2.0, offset.f_82480_ + 0.55, offset.f_82481_ - crystalWidth.f_82481_ + Math.random() * crystalWidth.f_82481_ * 2.0, 0.0, 0.01, 0.0);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_items() {
        if (this.stage < Stage.CONSUMING_REAGENTS.ordinal()) {
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82520_(0.0, 1.0, 0.0);
        int burstIndex = this.collectedItems.size() - this.stageTicks / 20;
        for (int i = 0; i < this.collectedItems.size(); ++i) {
            CollectedItem ci = this.collectedItems.get(i);
            Vec3 pedestalParticleCenter = new Vec3((double)ci.tilePos.m_123341_() + 0.5, (double)ci.tilePos.m_123342_() + 1.5, (double)ci.tilePos.m_123343_() + 0.5);
            if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && this.stageTicks > 0 && this.stageTicks % 20 == 0 && i == burstIndex) {
                for (int n = 0; n < 20; ++n) {
                    this.m_58904_().m_7106_((ParticleOptions)this.createRandomParticle(ci.stack).setMaxAge(5).setMover(new ParticleVelocityMover(Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1, true)), pedestalParticleCenter.f_82479_, pedestalParticleCenter.f_82480_, pedestalParticleCenter.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && i >= burstIndex || i <= burstIndex && this.stage == Stage.CRAFTING.ordinal()) {
                this.m_58904_().m_7106_((ParticleOptions)this.createRandomParticle(ci.stack).setMover(new ParticleSphereOrbitMover(pedestalParticleCenter.f_82479_, pedestalParticleCenter.f_82480_, pedestalParticleCenter.f_82481_, 0.01f, Math.random() * 360.0, 0.5)), pedestalParticleCenter.f_82479_, pedestalParticleCenter.f_82480_, pedestalParticleCenter.f_82481_, 0.0, 0.0, 0.0);
            }
            if (this.stage != Stage.CRAFTING.ordinal() || i != burstIndex) continue;
            this.m_58904_().m_7106_((ParticleOptions)this.createRandomParticle(ci.stack).setMover(new ParticleLerpMover(pedestalParticleCenter.f_82479_, pedestalParticleCenter.f_82480_, pedestalParticleCenter.f_82481_, center.f_82479_, center.f_82480_, center.f_82481_)), pedestalParticleCenter.f_82479_, pedestalParticleCenter.f_82480_, pedestalParticleCenter.f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.stage >= Stage.CRAFTING.ordinal()) {
            float radius = 0.75f;
            float scale = 0.1f;
            if (this.getStage() == Stage.COMPLETING) {
                if (this.stageTicks > 40) {
                    float pct = MathUtils.clamp01((float)(this.stageTicks - 40) / 40.0f);
                    radius -= 0.74f * pct;
                    scale = (float)((double)scale - 0.09 * (double)pct);
                } else if (this.stageTicks > 80) {
                    return;
                }
            }
            for (int i = 0; i < this.collectedItems.size(); ++i) {
                if (this.getStage() == Stage.CRAFTING && i <= burstIndex) continue;
                CollectedItem ci = this.collectedItems.get(i);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(ci.stack).setScale(scale).setMover(new ParticleSphereOrbitMover(center.f_82479_, center.f_82480_, center.f_82481_, 0.01f, Math.random() * 360.0, radius)), center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_lights() {
        for (int i = 0; i < this.collectedItems.size(); ++i) {
            CollectedItem item = this.collectedItems.get(i);
            if (item.stack.m_41619_()) continue;
            Vec3 offset = Vec3.m_82512_((Vec3i)item.tilePos);
            Vec3 crystalWidth = new Vec3(0.25, 0.0, 0.25);
            for (int n = 0; n < 10; ++n) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), offset.f_82479_ - crystalWidth.f_82479_ + Math.random() * crystalWidth.f_82479_ * 2.0, offset.f_82480_ + 0.55, offset.f_82481_ - crystalWidth.f_82481_ + Math.random() * crystalWidth.f_82481_ * 2.0, 0.0, 0.01, 0.0);
            }
        }
        if (this.getStage() == Stage.COMPLETING && this.stageTicks == 129) {
            int i;
            Random rnd = new Random();
            Vec3 basePoint = Vec3.m_82539_((Vec3i)this.m_58899_());
            Vec3 srcPoint = basePoint.m_82520_(0.5, 1.5, 0.5);
            for (i = 0; i < 150; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), srcPoint.m_7096_(), srcPoint.m_7098_(), srcPoint.m_7094_(), -0.5 + Math.random(), 0.01, -0.5 + Math.random());
            }
            for (i = 0; i < 50; ++i) {
                Vec3 lightPoint = new Vec3(srcPoint.m_7096_() - (double)0.2f + (double)(rnd.nextFloat() * 0.4f), srcPoint.m_7098_() - (double)0.3f, srcPoint.m_7094_() - (double)0.2f + (double)(rnd.nextFloat() * 0.4f));
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), lightPoint.m_7096_(), lightPoint.m_7098_(), lightPoint.m_7094_(), 0.0, 0.01, 0.0);
            }
            int angleStep = 10;
            for (int i2 = 0; i2 <= 360; i2 += angleStep) {
                int angle = (i2 + this.stageTicks * 2) % 360;
                Vec3 offset = new Vec3(Math.sin((double)angle * Math.PI / 180.0), 0.0, Math.cos((double)angle * Math.PI / 180.0)).m_82541_().m_82490_(0.3);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setScale(0.5f).setMaxAge(20), basePoint.f_82479_, basePoint.f_82480_, basePoint.f_82481_, offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private MAParticleType createRandomParticle(ItemStack stack) {
        if (Math.random() < 0.5 && this.getCachedRecipe() != null) {
            ArrayList<Affinity> affs = new ArrayList<Affinity>();
            affs.addAll(this.getCachedRecipe().getPowerRequirements().keySet());
            if (affs.size() > 0) {
                Affinity rand = (Affinity)((Object)affs.get((int)(Math.random() * (double)affs.size())));
                switch (rand) {
                    case ARCANE: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get()));
                    }
                    case EARTH: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get()));
                    }
                    case ENDER: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get()));
                    }
                    case FIRE: 
                    case HELLFIRE: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get()));
                    }
                    case WATER: 
                    case ICE: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())).setScale(0.03f);
                    }
                    case LIGHTNING: 
                    case WIND: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.04f).setColor(30, 30, 30);
                    }
                }
            }
        }
        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(stack).setScale(0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSounds() {
        if (this.getStage() == Stage.FINDING_POWER && this.stageTicks == 1) {
            this.PlaySound(SFX.Spell.Cast.ENDER);
            this.PlayLoopingSound(SFX.Loops.ELDRIN_ALTAR);
        }
        int ticksPerBeam = 5;
        if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && this.stageTicks % ticksPerBeam == 0 && this.stageTicks < this.getActiveCrystals().size() * ticksPerBeam) {
            this.PlaySound(SFX.Spell.Cast.ARCANE);
        }
        int burstFreq = 20;
        if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && this.stageTicks > 0 && this.stageTicks % burstFreq == 0 && this.stageTicks <= burstFreq * this.getCollectedItems().size()) {
            this.PlaySound(SFX.Spell.Impact.Single.EARTH);
        }
        if (this.stage == Stage.CRAFTING.ordinal() && this.stageTicks > 0 && this.stageTicks % burstFreq == 0 && this.stageTicks < burstFreq * this.getCollectedItems().size()) {
            this.PlaySound(SFX.Event.Eldrin.DRAW_IN_ITEM);
        }
        if (this.getStage() == Stage.COMPLETING && this.stageTicks == 129) {
            this.PlaySound(SFX.Event.Eldrin.CRAFT_COMPLETE);
        }
    }

    private void PlaySound(SoundEvent soundID) {
        this.m_58904_().m_7785_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), soundID, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PredicateLoopingSound(soundID, "eldrin_altar", this::soundLoopPredicate).setVolume(0.2f).setPosition(this.f_58858_));
    }

    private boolean soundLoopPredicate(String id) {
        return this.stage > 0;
    }

    public boolean startCrafting(Player player) {
        if (!this.structureMatched) {
            return false;
        }
        if (!this.cacheRecipe(player, false)) {
            return false;
        }
        LazyOptional progression = player.getCapability(PlayerProgressionProvider.PROGRESSION);
        if (!progression.isPresent()) {
            return false;
        }
        if (this.__cachedRecipe == null || this.__cachedRecipe.getTier() > ((IPlayerProgression)progression.resolve().get()).getTier()) {
            player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.lowtier"));
            return false;
        }
        this.activeCrystals.clear();
        this.collectedItems.clear();
        MutableObject playerNWStr = new MutableObject();
        MutableBoolean canStart = new MutableBoolean(true);
        this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> playerNWStr.setValue(m.getWellspringRegistry().getNodeNetworkStrengthFor(player)));
        if (canStart.booleanValue()) {
            this.__crafter = player;
            this.consumedPower.clear();
            this.setStage(Stage.FINDING_POWER);
        }
        return canStart.booleanValue();
    }

    private boolean cacheRecipe(Player crafter, boolean consume) {
        ItemStack stack;
        if (this.getDisplayedItem().m_41619_() || crafter == null) {
            return false;
        }
        Optional<IMultiblockDefinition> def = this.getDefinition();
        if (!def.isPresent()) {
            return false;
        }
        List<BlockPos> offsets = def.get().getPositions(Arrays.asList(BlockInit.PEDESTAL.getId(), BlockInit.PEDESTAL_WITH_SIGN.getId()), null);
        if (offsets.size() != 8) {
            throw new RuntimeException("THIS IS NOT AN M&A ISSUE.  A packmaker has replaced the structure for the Runic Altar and didn't put exactly 8 pedestals.  The pedestals are required to match the recipe.  Go tell them to fix it.");
        }
        BlockPos origin = BlockPos.f_121853_;
        if (this.matchOriginIsCenter()) {
            origin = origin.m_121996_(new Vec3i(def.get().getSize().m_123341_() / 2, 0, def.get().getSize().m_123343_() / 2));
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getDisplayedItem().m_41777_());
        if (consume && !(stack = this.m_7407_(0, 1)).m_41619_()) {
            this.collectedItems.add(new CollectedItem(this.m_58899_(), stack));
        }
        for (BlockPos pos : offsets) {
            ItemStack stack2;
            BlockPos adjustedpos = origin.m_121955_((Vec3i)pos);
            if (adjustedpos.m_123341_() == 0 && adjustedpos.m_123342_() == 0 && adjustedpos.m_123343_() == 0) continue;
            BlockEntity te = this.m_58904_().m_7702_(this.m_58899_().m_121955_((Vec3i)adjustedpos));
            if (te == null || !(te instanceof PedestalTile)) {
                return false;
            }
            stacks.add(((PedestalTile)te).getDisplayedItem().m_41777_());
            if (!consume || (stack2 = ((PedestalTile)te).m_7407_(0, 1)).m_41619_()) continue;
            this.collectedItems.add(new CollectedItem(te.m_58899_(), stack2));
        }
        ItemAndPatternCraftingInventory craftinginventory = new ItemAndPatternCraftingInventory(9, new ArrayList<String>());
        for (int i = 0; i < 9; ++i) {
            craftinginventory.m_6836_(i, (ItemStack)stacks.get(i));
        }
        this.__cachedRecipe = this.m_58904_().m_7465_().m_44015_((RecipeType)RecipeInit.ELDRIN_ALTAR_TYPE.get(), (Container)craftinginventory, this.f_58857_).orElse(null);
        if (this.__cachedRecipe != null) {
            crafter.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                IFaction playerfaction = p.getAlliedFaction();
                int playerTier = p.getTier();
                if (this.__cachedRecipe.getFactionRequirement() != null && this.__cachedRecipe.getFactionRequirement() != playerfaction) {
                    this.__cachedRecipe = null;
                    if (!crafter.m_9236_().m_5776_()) {
                        crafter.m_213846_((Component)Component.m_237115_((String)"block.mna.eldrin_altar.wrongFaction"));
                    }
                }
                if (this.__cachedRecipe.getTier() > playerTier) {
                    this.__cachedRecipe = null;
                    if (!crafter.m_9236_().m_5776_()) {
                        crafter.m_213846_((Component)Component.m_237115_((String)"block.mna.runic_anvil.low_tier"));
                    }
                }
            });
        }
        return this.__cachedRecipe != null;
    }

    private void tickLogic_findPower() {
        if (this.stageTicks == 1) {
            this.__powerSuppliers.queueRecheck();
        } else if (!this.__powerSuppliers.isSearching()) {
            if (this.getCachedRecipe() == null) {
                this.setStage(Stage.IDLE);
                return;
            }
            HashMap requiredpower = new HashMap();
            this.getCachedRecipe().getPowerRequirements().forEach((k, v) -> requiredpower.put(k, v));
            this.__powerSuppliers.getCachedPositions().forEach(bp -> {
                BlockEntity te = this.m_58904_().m_7702_(bp);
                if (te != null && te instanceof IEldrinCapacitorTile) {
                    ((IEldrinCapacitorTile)te).getAffinities().forEach(suppliedPower -> {
                        if (requiredpower.containsKey(suppliedPower)) {
                            requiredpower.remove(suppliedPower);
                            this.activeCrystals.add(new ActiveCrystal((Affinity)((Object)((Object)suppliedPower)), this.getClosestOffset((BlockPos)bp), (BlockPos)bp));
                        }
                    });
                }
            });
            if (requiredpower.size() == 0) {
                this.setStage(Stage.CONSUMING_POWER);
            } else {
                if (this.getCrafter() != null) {
                    this.getCrafter().m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.missing_conduit"));
                }
                this.consumedPower.clear();
                this.setStage(Stage.IDLE);
            }
        }
    }

    private void tickLogic_consumePower() {
        MutableBoolean fullyConsumed = new MutableBoolean(true);
        MutableBoolean consumedAny = new MutableBoolean(false);
        EldrinAltarRecipe cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe == null) {
            this.setStage(Stage.IDLE);
        }
        cachedRecipe.getPowerRequirements().forEach((affinity, required) -> {
            float existing;
            if (!this.consumedPower.containsKey(affinity)) {
                this.consumedPower.put((Affinity)((Object)affinity), Float.valueOf(0.0f));
            }
            if (!this.powerRequirementStatus.containsKey(affinity)) {
                this.powerRequirementStatus.put((Affinity)((Object)affinity), true);
            }
            if ((existing = this.consumedPower.get(affinity).floatValue()) < required.floatValue() && required.floatValue() > 0.0f && existing >= 0.0f) {
                fullyConsumed.setFalse();
                float toConsume = Math.min(10.0f, required.floatValue() - existing);
                float consumed = this.consume(this.__crafter, this.m_58899_(), Vec3.m_82512_((Vec3i)this.m_58899_()), (Affinity)((Object)affinity), toConsume);
                if (consumed > 0.0f) {
                    float newAmt = existing + consumed;
                    if (newAmt < required.floatValue()) {
                        this.consumedPower.put((Affinity)((Object)affinity), Float.valueOf(newAmt));
                    } else {
                        this.consumedPower.put((Affinity)((Object)affinity), Float.valueOf(-1.0f));
                        consumedAny.setTrue();
                    }
                    this.powerRequirementStatus.put((Affinity)((Object)affinity), true);
                } else {
                    this.powerRequirementStatus.put((Affinity)((Object)affinity), false);
                }
            }
        });
        if (!this.m_58904_().m_5776_() && this.m_58904_().m_46467_() % 20L == 0L) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        if (fullyConsumed.booleanValue()) {
            this.setStage(Stage.CONSUMING_REAGENTS);
        }
    }

    private int getClosestOffset(BlockPos pos) {
        int output = -1;
        double dist = Double.MAX_VALUE;
        Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 target = Vec3.m_82512_((Vec3i)pos);
        for (int i = 0; i < crystal_offsets.length; ++i) {
            double loopDist = center.m_82549_(crystal_offsets[i]).m_82557_(target);
            if (!(loopDist < dist)) continue;
            dist = loopDist;
            output = i;
        }
        return output;
    }

    private void tickLogic_consumeReagents() {
        if (this.stageTicks == 1) {
            EldrinAltarRecipe prev = this.getCachedRecipe();
            if (!this.cacheRecipe(this.getCrafter(), true) || prev != this.getCachedRecipe()) {
                this.setStage(Stage.IDLE);
                return;
            }
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        if (this.stageTicks >= 30 * this.getCachedRecipe().getRequiredItems().length) {
            this.setStage(Stage.CRAFTING);
        }
    }

    private void tickLogic_craft() {
        if (this.stageTicks >= 30 * this.getCachedRecipe().getRequiredItems().length) {
            this.setStage(Stage.COMPLETING);
        }
    }

    private void tickLogic_complete() {
        if (this.stageTicks >= 130) {
            Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_());
            MinecraftForge.EVENT_BUS.post((Event)new EldrinCraftingEvent(this.getCachedRecipe(), this.getCachedRecipe().getResultItem(), this.getCrafter()));
            Player crafter = this.getCrafter();
            if (crafter != null && crafter instanceof ServerPlayer) {
                CustomAdvancementTriggers.ELDRIN_ALTAR_CRAFT.trigger((ServerPlayer)crafter, this.getCachedRecipe().getResultItem());
            }
            PresentItem epi = new PresentItem(this.m_58904_(), center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, this.getCachedRecipe().getResultItem());
            this.m_58904_().m_7967_((Entity)epi);
            ArrayList<ItemStack> byproducts = this.getCachedRecipe().rollByproducts(this.f_58857_.m_213780_());
            for (ItemStack byproduct : byproducts) {
                InventoryUtilities.DropItemAt(byproduct, Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_()), this.f_58857_, true);
            }
            this.copyCraftInputToLastCraft();
            this.activeCrystals.clear();
            this.collectedItems.clear();
            this.setStage(Stage.IDLE);
            this.m_6596_();
        }
    }

    private boolean checkReCraftReagents(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        MutableBoolean progressionMet = new MutableBoolean(false);
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getTier() < this.lastCraftTier) {
                player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.lowtier"));
            } else if (this.lastCraftFaction != null && p.getAlliedFaction() != this.lastCraftFaction) {
                player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.wrongfaction"));
            } else {
                progressionMet.setTrue();
            }
        });
        if (!progressionMet.booleanValue()) {
            return false;
        }
        MutableBoolean reagentsPresent = new MutableBoolean(true);
        this.lastCraftItemsMerged.forEach(stack -> {
            if (!stack.m_41619_() && !InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_()))) {
                reagentsPresent.setFalse();
            }
        });
        if (!reagentsPresent.getValue().booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.missing_items"));
            return false;
        }
        MutableBoolean eldrinMet = new MutableBoolean(false);
        player.m_9236_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            HashMap<Affinity, Float> power = m.getWellspringRegistry().getNodeNetworkAmountFor(player);
            for (Affinity aff : this.lastCraftEldrin.keySet()) {
                if (!(power.getOrDefault((Object)aff, Float.valueOf(0.0f)).floatValue() < this.lastCraftEldrin.getOrDefault((Object)aff, Float.valueOf(0.0f)).floatValue())) continue;
                player.m_213846_((Component)Component.m_237110_((String)"gui.mna.recipe.missing_wellspring", (Object[])new Object[]{aff.name()}));
                return;
            }
            eldrinMet.setTrue();
        });
        return eldrinMet.booleanValue();
    }

    private void consumeReCraftReagents(Player player) {
        if (player.m_7500_()) {
            return;
        }
        this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> this.lastCraftEldrin.entrySet().forEach(e -> m.getWellspringRegistry().consumePower(player.m_36316_().getId(), this.f_58857_, (Affinity)((Object)((Object)((Object)e.getKey()))), ((Float)e.getValue()).floatValue())));
        this.lastCraftItemsMerged.forEach(stack -> InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_())));
    }

    public boolean reCraft(Player player) {
        if (!this.m_7983_() || this.m_58904_().m_5776_()) {
            return false;
        }
        if (this.checkReCraftReagents(player)) {
            ServerMessageDispatcher.sendParticleEffect((ResourceKey<Level>)this.m_58904_().m_46472_(), 32.0f, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 1.1f, (float)this.m_58899_().m_123343_() + 0.5f, SpawnParticleEffectMessage.ParticleTypes.MANAWEAVE_CRAFT_COMPLETE);
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Event.Eldrin.CRAFT_COMPLETE, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
            this.setPlayerReference(player);
            this.consumeReCraftReagents(player);
            ItemStack output = this.lastCraftOutput.m_41777_();
            if (player != null && player instanceof ServerPlayer) {
                CustomAdvancementTriggers.ELDRIN_ALTAR_CRAFT.trigger((ServerPlayer)player, output);
            }
            boolean sendUpdate = false;
            if (!player.m_150109_().m_36054_(output)) {
                this.m_6836_(0, output);
                sendUpdate = true;
            }
            if (this._lastCraftRecipe == null && this.lastCraftRecipeID != null) {
                this.f_58857_.m_7465_().m_44043_(this.lastCraftRecipeID).ifPresent(recipe -> {
                    if (recipe instanceof EldrinAltarRecipe) {
                        EldrinAltarRecipe eaRecipe;
                        this._lastCraftRecipe = eaRecipe = (EldrinAltarRecipe)recipe;
                    }
                });
            }
            if (this._lastCraftRecipe != null) {
                int count = 1;
                ArrayList<ItemStack> byproducts = this._lastCraftRecipe.rollByproducts(this.f_58857_.m_213780_());
                for (ItemStack byproduct : byproducts) {
                    if (player.m_150109_().m_36054_(byproduct)) continue;
                    if (count++ < 9) {
                        this.m_6836_(count, byproduct);
                        sendUpdate = true;
                        continue;
                    }
                    InventoryUtilities.DropItemAt(byproduct, Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_()), this.f_58857_, true);
                }
            }
            if (sendUpdate) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
            return true;
        }
        return false;
    }

    private void copyCraftInputToLastCraft() {
        this.lastCraftItems.clear();
        this.lastCraftItemsMerged.clear();
        this.lastCraftEldrin.clear();
        for (CollectedItem ci : this.collectedItems) {
            ItemStack stack = ci.stack;
            this.lastCraftItems.add((Object)stack.m_41777_());
            Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.m_150942_((ItemStack)is, (ItemStack)stack)).findFirst();
            if (existing.isPresent()) {
                existing.get().m_41764_(existing.get().m_41613_() + stack.m_41613_());
                continue;
            }
            this.lastCraftItemsMerged.add((Object)stack.m_41777_());
        }
        this.__cachedRecipe.getPowerRequirements().forEach((a, f) -> this.lastCraftEldrin.put((Affinity)((Object)a), (Float)f));
        this.lastCraftOutput = this.__cachedRecipe.getResultItem().m_41777_();
        this._lastCraftRecipe = this.__cachedRecipe;
        this.lastCraftRecipeID = this.__cachedRecipe.m_6423_();
    }

    public ItemStack getReCraftOutput() {
        return this.lastCraftOutput;
    }

    public HashMap<Affinity, Float> getReCraftEldrin() {
        return this.lastCraftEldrin;
    }

    public List<ItemStack> getReCraftInput() {
        return this.lastCraftItems.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
    }

    @Nullable
    public IFaction getLastCraftFaction() {
        return this.lastCraftFaction;
    }

    public int getLastCraftTier() {
        return this.lastCraftTier;
    }

    public void setReCraftRecipe(ItemStack output, List<ItemStack> inputs, IFaction faction, int tier, HashMap<Affinity, Float> powerRequirements) {
        this.lastCraftOutput = output;
        this.lastCraftItems.clear();
        this.lastCraftItemsMerged.clear();
        for (ItemStack stack : inputs) {
            this.lastCraftItems.add((Object)stack.m_41777_());
            Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.m_41728_((ItemStack)is, (ItemStack)stack)).findFirst();
            if (existing.isPresent()) {
                existing.get().m_41764_(existing.get().m_41613_() + stack.m_41613_());
                continue;
            }
            this.lastCraftItemsMerged.add((Object)stack.m_41777_());
        }
        this.lastCraftFaction = faction;
        this.lastCraftTier = tier;
        this.lastCraftEldrin = powerRequirements;
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        this.updateBlockState();
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack out = super.m_7407_(index, count);
        this.updateBlockState();
        return out;
    }

    private void updateBlockState() {
        this.updateBlockState("invChange", 131);
    }

    private void updateBlockState(String id, Integer data) {
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), data.intValue());
    }

    @Override
    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 1;
    }

    public ItemStack getDisplayedItem() {
        return this.m_8020_(0);
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0};
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return this.m_8020_(0).m_41619_();
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.m_8020_(0).m_41619_();
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        CompoundTag sub = this.writeAdditonal(new CompoundTag());
        base.m_128365_("invSync", (Tag)sub);
        CompoundTag powerStatus = new CompoundTag();
        this.powerRequirementStatus.entrySet().forEach(e -> powerStatus.m_128379_(((Affinity)((Object)((Object)e.getKey()))).name(), ((Boolean)e.getValue()).booleanValue()));
        base.m_128365_("powerStatus", (Tag)powerStatus);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        CompoundTag sub = tag.m_128469_("invSync");
        this.readAdditional(sub);
        CompoundTag powerStatus = tag.m_128469_("powerStatus");
        this.powerRequirementStatus.clear();
        for (int i = 0; i < Affinity.values().length; ++i) {
            Affinity aff = Affinity.values()[i];
            if (!powerStatus.m_128441_(aff.name())) continue;
            this.powerRequirementStatus.put(aff, powerStatus.m_128471_(aff.name()));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag sub = pkt.m_131708_().m_128469_("invSync");
        this.readAdditional(sub);
        CompoundTag powerStatus = pkt.m_131708_().m_128469_("powerStatus");
        this.powerRequirementStatus.clear();
        for (int i = 0; i < Affinity.values().length; ++i) {
            Affinity aff = Affinity.values()[i];
            if (!powerStatus.m_128441_(aff.name())) continue;
            this.powerRequirementStatus.put(aff, powerStatus.m_128471_(aff.name()));
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        this.writeAdditonal(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.readAdditional(compound);
        super.m_142466_(compound);
    }

    private CompoundTag writeAdditonal(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, (NonNullList)this.inventoryItems);
        compound.m_128405_("stage", this.stage);
        compound.m_128405_("stageTicks", this.stageTicks);
        ListTag activeCrystals = new ListTag();
        this.activeCrystals.forEach(a -> activeCrystals.add((Object)a.toNBT()));
        compound.m_128365_("activeCrystals", (Tag)activeCrystals);
        ListTag collectedItems = new ListTag();
        this.collectedItems.forEach(i -> collectedItems.add((Object)i.toNBT()));
        compound.m_128365_("collectedItems", (Tag)collectedItems);
        CompoundTag consumed = new CompoundTag();
        this.consumedPower.entrySet().forEach(e -> consumed.m_128350_(((Affinity)((Object)((Object)e.getKey()))).name(), ((Float)e.getValue()).floatValue()));
        compound.m_128365_("consumedPower", (Tag)consumed);
        if (this.__crafterID != null) {
            compound.m_128359_("crafter_uuid", this.__crafterID.toString());
        }
        if (this.__cachedRecipe != null) {
            compound.m_128359_("cachedRecipeId", this.__cachedRecipe.m_6423_().toString());
        }
        CompoundTag lastCraft = new CompoundTag();
        lastCraft.m_128365_("lastCraftReagents", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.lastCraftItems));
        lastCraft.m_128405_("tier", this.lastCraftTier);
        if (this.lastCraftFaction != null) {
            lastCraft.m_128359_("faction", Registries.Factions.get().getKey((Object)this.lastCraftFaction).toString());
        }
        lastCraft.m_128365_("lastCraftOutput", (Tag)this.lastCraftOutput.m_41739_(new CompoundTag()));
        CompoundTag eldrin = new CompoundTag();
        this.lastCraftEldrin.forEach((a, f) -> eldrin.m_128350_(a.name(), f.floatValue()));
        lastCraft.m_128365_("eldrin", (Tag)eldrin);
        compound.m_128365_("lastCraft", (Tag)lastCraft);
        return compound;
    }

    private void readAdditional(CompoundTag compound) {
        this.m_6211_();
        this.lastCraftItems.clear();
        for (int i = 0; i < 9; ++i) {
            this.lastCraftItems.add((Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)this.inventoryItems);
        this.stage = compound.m_128451_("stage");
        this.stageTicks = compound.m_128451_("stageTicks");
        if (compound.m_128441_("cachedRecipeId")) {
            this.__cachedRecipeId = new ResourceLocation(compound.m_128461_("cachedRecipeId"));
        }
        ListTag list = compound.m_128437_("activeCrystals", 10);
        this.activeCrystals.clear();
        list.forEach(inbt -> {
            CompoundTag activeCrystal = (CompoundTag)inbt;
            this.activeCrystals.add(ActiveCrystal.fromNBT(activeCrystal));
        });
        list = compound.m_128437_("collectedItems", 10);
        this.collectedItems.clear();
        list.forEach(inbt -> {
            CompoundTag collectedItem = (CompoundTag)inbt;
            this.collectedItems.add(CollectedItem.fromNBT(collectedItem));
        });
        if (compound.m_128441_("consumedPower")) {
            this.consumedPower.clear();
            CompoundTag consumed = compound.m_128469_("consumedPower");
            for (Affinity aff : Affinity.values()) {
                if (!consumed.m_128441_(aff.name())) continue;
                this.consumedPower.put(aff, Float.valueOf(consumed.m_128457_(aff.name())));
            }
        }
        if (compound.m_128441_("crafter_uuid")) {
            this.__crafterID = UUID.fromString(compound.m_128461_("crafter_uuid"));
        }
        if (compound.m_128441_("lastCraft")) {
            CompoundTag lastCraft = compound.m_128469_("lastCraft");
            this.lastCraftOutput = ItemStack.m_41712_((CompoundTag)lastCraft.m_128469_("lastCraftOutput"));
            ContainerHelper.m_18980_((CompoundTag)lastCraft.m_128469_("lastCraftReagents"), this.lastCraftItems);
            this.lastCraftTier = lastCraft.m_128451_("tier");
            if (lastCraft.m_128441_("faction")) {
                ResourceLocation factionID = new ResourceLocation(lastCraft.m_128461_("faction"));
                this.lastCraftFaction = (IFaction)Registries.Factions.get().getValue(factionID);
            }
            this.lastCraftEldrin.clear();
            if (lastCraft.m_128441_("eldrin")) {
                CompoundTag eldrin = lastCraft.m_128469_("eldrin");
                for (Affinity aff : Affinity.values()) {
                    if (!eldrin.m_128441_(aff.name())) continue;
                    this.lastCraftEldrin.put(aff, Float.valueOf(eldrin.m_128457_(aff.name())));
                }
            }
            this.lastCraftRecipeID = new ResourceLocation(lastCraft.m_128461_("lastCraftRecipeID"));
            for (ItemStack stack : this.lastCraftItems) {
                Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.m_41728_((ItemStack)is, (ItemStack)stack)).findFirst();
                if (existing.isPresent()) {
                    existing.get().m_41764_(existing.get().m_41613_() + stack.m_41613_());
                    continue;
                }
                this.lastCraftItemsMerged.add((Object)stack.m_41777_());
            }
        }
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.m_8020_(0).m_41619_()) {
            return false;
        }
        return MATags.isItemEqual(this.m_8020_(0), rLoc);
    }

    public ArrayList<ActiveCrystal> getActiveCrystals() {
        return this.activeCrystals;
    }

    public ArrayList<CollectedItem> getCollectedItems() {
        return this.collectedItems;
    }

    public static enum Stage {
        IDLE,
        FINDING_POWER,
        CONSUMING_POWER,
        CONSUMING_REAGENTS,
        CRAFTING,
        COMPLETING;

    }

    public static class CollectedItem {
        public final BlockPos tilePos;
        public final ItemStack stack;

        public CollectedItem(BlockPos pos, ItemStack stack) {
            this.tilePos = pos;
            this.stack = stack;
        }

        public CompoundTag toNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("pos", this.tilePos.m_121878_());
            this.stack.m_41739_(nbt);
            return nbt;
        }

        public static CollectedItem fromNBT(CompoundTag nbt) {
            return new CollectedItem(BlockPos.m_122022_((long)nbt.m_128454_("pos")), ItemStack.m_41712_((CompoundTag)nbt));
        }
    }

    public static class ActiveCrystal {
        public final Affinity affinity;
        public final int offsetIndex;
        public final BlockPos tilePos;

        public ActiveCrystal(Affinity affinity, int offsetIndex, BlockPos tilePos) {
            this.affinity = affinity;
            this.offsetIndex = offsetIndex;
            this.tilePos = tilePos;
        }

        public CompoundTag toNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("affinity", this.affinity.name());
            nbt.m_128405_("offsetIndex", this.offsetIndex);
            nbt.m_128356_("position", this.tilePos.m_121878_());
            return nbt;
        }

        public static ActiveCrystal fromNBT(CompoundTag nbt) {
            return new ActiveCrystal(Affinity.valueOf(nbt.m_128461_("affinity")), nbt.m_128451_("offsetIndex"), BlockPos.m_122022_((long)nbt.m_128454_("position")));
        }
    }
}

