/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.ConstructTask;
import com.mna.api.entities.construct.ai.IMutexManager;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.gui.containers.block.ContainerLodestar;
import com.mna.network.ClientMessageDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LodestarTile
extends BlockEntity
implements Consumer<FriendlyByteBuf>,
MenuProvider,
GeoBlockEntity,
IMutexManager {
    private CompoundTag logic;
    private ArrayList<ConstructAITask<?>> inflatedTasks;
    private List<Component> errors;
    private List<Component> warnings;
    private List<String> misconfiguredIDs;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private HashMap<Class<?>, HashMap<IConstruct<?>, Long>> blockPositionMutex;
    private HashMap<Class<?>, HashMap<IConstruct<?>, Integer>> entityIDMutex;

    public LodestarTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.LODESTAR.get(), pos, state);
        this.logic = new CompoundTag();
        this.inflatedTasks = new ArrayList();
        this.errors = new ArrayList<Component>();
        this.warnings = new ArrayList<Component>();
        this.misconfiguredIDs = new ArrayList<String>();
        this.blockPositionMutex = new HashMap();
        this.entityIDMutex = new HashMap();
    }

    public Optional<ConstructAITask<?>> getCommand(String ID) {
        if (ID == null) {
            return this.inflatedTasks.stream().filter(t -> t.isStart()).findFirst();
        }
        return this.inflatedTasks.stream().filter(t -> t.getId().equals(ID)).findFirst();
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("logic", (Tag)this.logic);
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt.m_128441_("logic")) {
            this.logic = nbt.m_128469_("logic");
            this.inflateLogic();
        }
        super.m_142466_(nbt);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Override
    public void accept(FriendlyByteBuf t) {
        t.m_130064_(this.m_58899_());
        CompoundTag compound = this.m_187480_();
        t.m_130079_(compound);
    }

    public LodestarTile readFrom(FriendlyByteBuf data) {
        CompoundTag compound = data.m_130260_();
        this.m_142466_(compound);
        return this;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerLodestar(id, playerInventory, this);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (this.m_58904_().m_276867_(this.m_58899_())) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.lodestar_armature.inactive"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.lodestar_armature.active"));
        }).transitionLength(20)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void setLogic(CompoundTag logic, boolean sync) {
        this.logic = logic;
        this.inflateLogic();
        if (this.m_58904_().m_5776_() && sync) {
            ClientMessageDispatcher.sendLodestarLogicMessage(this.m_58899_(), logic);
        } else {
            this.m_6596_();
        }
    }

    public CompoundTag getLogic() {
        return this.logic;
    }

    private void inflateLogic() {
        this.inflatedTasks.clear();
        if (!this.logic.m_128441_("commands")) {
            return;
        }
        ListTag data = this.logic.m_128437_("commands", 10);
        data.forEach(tag -> this.inflateLogicNode((CompoundTag)tag));
        this.analyzeLogic();
    }

    private void inflateLogicNode(CompoundTag tag) {
        ResourceLocation taskID = new ResourceLocation(tag.m_128461_("task"));
        ConstructTask action = (ConstructTask)Registries.ConstructTasks.get().getValue(taskID);
        if (action == null) {
            ManaAndArtifice.LOGGER.error("Failed to look up task (" + taskID.toString() + "); Node skipped.  This will likely break connections.");
            return;
        }
        if (tag.m_128441_("id") && tag.m_128441_("start")) {
            ConstructAITask<?> inst = action.instantiateTask(null);
            if (tag.m_128425_("parameters", 9)) {
                inst.loadParameterData(tag.m_128437_("parameters", 10));
            }
            if (tag.m_128425_("connections", 9)) {
                inst.loadConnections(tag.m_128437_("connections", 10));
            }
            inst.setIdAndIsStart(tag.m_128461_("id"), tag.m_128471_("start"));
            inst.inflateParameters();
            this.inflatedTasks.add(inst);
        } else {
            ManaAndArtifice.LOGGER.error("Task (" + taskID.toString() + ") did not have the required parameters id and start from the Lodestar.  Skipping.");
        }
    }

    private void analyzeLogic() {
        this.errors.clear();
        this.warnings.clear();
        this.misconfiguredIDs = this.inflatedTasks.stream().filter(task -> !task.isFullyConfigured()).map(task -> task.getId()).toList();
        boolean hasNoStart = this.inflatedTasks.stream().noneMatch(task -> task.isStart());
        boolean hasMisconfigured = this.misconfiguredIDs.size() > 0;
        List visitedIDs = this.inflatedTasks.stream().map(task -> task.getConnectedIDs()).flatMap(Collection::stream).collect(Collectors.toList());
        boolean hasDisconnected = this.inflatedTasks.stream().anyMatch(task -> !visitedIDs.contains(task.getId()) && !task.isStart());
        if (hasNoStart && this.inflatedTasks.size() > 0) {
            this.errors.add((Component)Component.m_237115_((String)"gui.mna.lodestar.error.no_start"));
        }
        if (hasMisconfigured) {
            this.warnings.add((Component)Component.m_237115_((String)"gui.mna.lodestar.warning.misconfigured"));
        }
        if (hasDisconnected && this.inflatedTasks.size() > 0) {
            this.warnings.add((Component)Component.m_237115_((String)"gui.mna.lodestar.warning.unreachable"));
        }
    }

    public List<Component> getErrors() {
        return this.errors;
    }

    public List<Component> getWarnings() {
        return this.warnings;
    }

    public List<String> getMisconfiguredNodeIDs() {
        return this.misconfiguredIDs;
    }

    @Override
    public boolean claimMutex(BlockPos pos, IConstruct<?> construct, ConstructAITask<?> task) {
        long posLong = pos.m_121878_();
        HashMap mutex = this.blockPositionMutex.computeIfAbsent(((Object)task).getClass(), k -> new HashMap());
        if (mutex.containsValue(posLong)) {
            return mutex.containsKey(construct) && (Long)mutex.get(construct) == posLong;
        }
        mutex.put(construct, posLong);
        return true;
    }

    @Override
    public void releaseMutex(BlockPos pos, IConstruct<?> construct, ConstructAITask<?> task) {
        HashMap mutex = this.blockPositionMutex.computeIfAbsent(((Object)task).getClass(), k -> new HashMap());
        mutex.remove(construct);
    }

    @Override
    public boolean claimMutex(Entity entity, IConstruct<?> construct, ConstructAITask<?> task) {
        if (entity == null) {
            return false;
        }
        int entityID = entity.m_19879_();
        HashMap mutex = this.entityIDMutex.computeIfAbsent(((Object)task).getClass(), k -> new HashMap());
        if (mutex.containsValue(entityID)) {
            return mutex.containsKey(construct) && (Integer)mutex.get(construct) == entityID;
        }
        mutex.put(construct, entityID);
        return true;
    }

    @Override
    public void releaseMutex(Entity entity, IConstruct<?> construct, ConstructAITask<?> task) {
        HashMap mutex = this.entityIDMutex.computeIfAbsent(((Object)task).getClass(), k -> new HashMap());
        mutex.remove(construct);
    }

    @Override
    public void releaseAllMutexes(IConstruct<?> construct, ConstructAITask<?> task) {
        this.blockPositionMutex.computeIfPresent(((Object)task).getClass(), (k, v) -> {
            v.remove(construct);
            return v;
        });
        this.entityIDMutex.computeIfPresent(((Object)task).getClass(), (k, v) -> {
            v.remove(construct);
            return v;
        });
    }
}

