/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.Registries;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.blocks.IRequirePlayerReference;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.api.sound.SFX;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.events.EventDispatcher;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.to_client.SpawnParticleEffectMessage;
import com.mna.recipes.ItemAndPatternCraftingInventory;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import com.mna.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Vector3f;

public class ManaweavingAltarTile
extends TileEntityWithInventory
implements IRequirePlayerReference<ManaweavingAltarTile> {
    public static final int MAX_ITEMS = 9;
    private ArrayList<String> pendingPatterns;
    private ArrayList<IManaweavePattern> addedPatterns;
    private boolean crafting = false;
    private int craftTicks = 0;
    private ManaweavingRecipe __cachedRecipe;
    private ItemStack __cachedRecipeOutput = ItemStack.f_41583_;
    private UUID __crafterID;
    private Player __crafter;
    private boolean copyNBT = false;
    private int lastCraftPatternCount = 0;
    private int lastCraftTier = 0;
    private IFaction lastCraftFaction = null;
    private ResourceLocation lastCraftRecipeID;
    private ManaweavingRecipe _lastCraftRecipe;
    private NonNullList<ItemStack> lastCraftItems;
    private NonNullList<ItemStack> lastCraftItemsMerged;
    private ItemStack lastCraftOutput = ItemStack.f_41583_;
    private LazyOptional<IItemHandlerModifiable> handler;

    public ManaweavingAltarTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, 9);
        this.addedPatterns = new ArrayList();
        this.pendingPatterns = new ArrayList();
        this.lastCraftItems = NonNullList.m_122779_();
        this.lastCraftItemsMerged = NonNullList.m_122779_();
    }

    public ManaweavingAltarTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.MANAWEAVING_ALTAR.get(), pos, state);
    }

    public void pushPattern(IManaweavePattern pattern, Player player) {
        if (this.crafting) {
            return;
        }
        this.setPlayerReference(player);
        this.resolvePendingPatterns();
        if (this.addedPatterns.size() == 6) {
            return;
        }
        this.addedPatterns.add(pattern);
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public ItemStack m_8016_(int index) {
        if (this.isCrafting()) {
            return ItemStack.f_41583_;
        }
        ItemStack output = super.m_8016_(index);
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        return output;
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        if (this.isCrafting()) {
            return ItemStack.f_41583_;
        }
        ItemStack output = super.m_7407_(index, count);
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        return output;
    }

    public void popPattern(Player player) {
        if (this.crafting) {
            return;
        }
        this.setPlayerReference(player);
        this.resolvePendingPatterns();
        if (this.addedPatterns.size() <= 0) {
            return;
        }
        this.addedPatterns.remove(this.addedPatterns.size() - 1);
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean pushItem(Player player, ItemStack stack) {
        if (this.crafting) {
            return false;
        }
        this.setPlayerReference(player);
        if (stack.m_41613_() != 1) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < 9; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, stack);
            success = true;
            break;
        }
        if (success && this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        return success;
    }

    public ItemStack popItem(Player player) {
        if (this.crafting) {
            return ItemStack.f_41583_;
        }
        this.setPlayerReference(player);
        ItemStack output = ItemStack.f_41583_;
        for (int i = 8; i >= 0; --i) {
            if (this.m_8020_(i).m_41619_()) continue;
            output = this.m_8016_(i);
            break;
        }
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        return output;
    }

    public void clearPatterns() {
        this.addedPatterns.clear();
    }

    public Collection<IManaweavePattern> getAddedPatterns() {
        this.resolvePendingPatterns();
        return this.addedPatterns;
    }

    @Override
    public int m_6643_() {
        return 9;
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        CompoundTag sub = this.writeAdditonal(new CompoundTag());
        base.m_128365_("invSync", (Tag)sub);
        return base;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        CompoundTag sub = tag.m_128469_("invSync");
        this.readAdditional(sub);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag sub = pkt.m_131708_().m_128469_("invSync");
        this.readAdditional(sub);
    }

    public int m_6893_() {
        return 1;
    }

    public ItemStack[] getDisplayedItems() {
        ItemStack[] stacks = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            stacks[i] = this.m_8020_(i);
        }
        return stacks;
    }

    private boolean MatchesRecipe(Player player) {
        IPlayerProgression progression;
        int tier = 1;
        IFaction faction = null;
        if (player != null && (progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) != null) {
            tier = progression.getTier();
            faction = progression.getAlliedFaction();
        }
        this.__cachedRecipe = null;
        this.__cachedRecipeOutput = ItemStack.f_41583_;
        ManaweavingRecipe recipe = this.m_58904_().m_7465_().m_44015_((RecipeType)RecipeInit.MANAWEAVING_RECIPE_TYPE.get(), (Container)this.createCraftingInventory(), this.f_58857_).orElse(null);
        if (recipe != null && recipe.getTier() <= tier) {
            this.__cachedRecipe = recipe;
            this.__cachedRecipeOutput = recipe.getResultItem().m_41777_();
            this.copyNBT = recipe.getCopyNBT();
        }
        if (this.__cachedRecipeOutput != null && !this.__cachedRecipeOutput.m_41619_()) {
            if (this.__cachedRecipe.getFactionRequirement() != null && this.__cachedRecipe.getFactionRequirement() != faction) {
                this.__cachedRecipeOutput = ItemStack.f_41583_;
                this.__cachedRecipe = null;
                if (player != null) {
                    player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.wrongfaction"));
                }
                return false;
            }
            this.lastCraftTier = recipe.getTier();
            this.lastCraftFaction = recipe.getFactionRequirement();
            return true;
        }
        return false;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeAdditonal(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.readAdditional(compound);
        super.m_142466_(compound);
    }

    private CompoundTag writeAdditonal(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, (NonNullList)this.inventoryItems);
        this.resolvePendingPatterns();
        CompoundTag patterns = new CompoundTag();
        int count = 0;
        for (IManaweavePattern pattern : this.addedPatterns) {
            patterns.m_128359_("pattern_" + count++, pattern.getRegistryId().toString());
        }
        compound.m_128405_("patterns_count", this.addedPatterns.size());
        compound.m_128365_("patterns", (Tag)patterns);
        compound.m_128379_("crafting", this.crafting);
        compound.m_128379_("copyNBT", this.copyNBT);
        compound.m_128405_("craftTicks", this.craftTicks);
        CompoundTag lastCraft = new CompoundTag();
        lastCraft.m_128365_("lastCraftReagents", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.lastCraftItems));
        lastCraft.m_128405_("patterns_count", this.lastCraftPatternCount);
        lastCraft.m_128405_("tier", this.lastCraftTier);
        if (this.lastCraftFaction != null) {
            lastCraft.m_128359_("faction", Registries.Factions.get().getKey((Object)this.lastCraftFaction).toString());
        }
        lastCraft.m_128365_("lastCraftOutput", (Tag)this.lastCraftOutput.m_41739_(new CompoundTag()));
        if (this.lastCraftRecipeID != null) {
            lastCraft.m_128359_("lastCraftRecipeID", this.lastCraftRecipeID.toString());
        }
        compound.m_128365_("lastCraft", (Tag)lastCraft);
        if (this.__crafterID != null) {
            compound.m_128359_("crafter_uuid", this.__crafterID.toString());
        }
        return compound;
    }

    private void readAdditional(CompoundTag compound) {
        this.m_6211_();
        this.addedPatterns.clear();
        this.pendingPatterns.clear();
        this.lastCraftItems.clear();
        for (int i = 0; i < 9; ++i) {
            this.lastCraftItems.add((Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)this.inventoryItems);
        if (compound.m_128441_("patterns") && compound.m_128441_("patterns_count")) {
            int count = compound.m_128451_("patterns_count");
            CompoundTag patterns = compound.m_128469_("patterns");
            for (int i = 0; i < count; ++i) {
                String identifier = "pattern_" + i;
                if (!patterns.m_128441_(identifier)) continue;
                this.pendingPatterns.add(patterns.m_128461_(identifier));
            }
        }
        this.crafting = compound.m_128471_("crafting");
        this.craftTicks = compound.m_128451_("craftTicks");
        this.copyNBT = compound.m_128471_("copyNBT");
        if (compound.m_128441_("crafter_uuid")) {
            this.__crafterID = UUID.fromString(compound.m_128461_("crafter_uuid"));
        }
        if (compound.m_128441_("lastCraft")) {
            CompoundTag lastCraft = compound.m_128469_("lastCraft");
            this.lastCraftOutput = ItemStack.m_41712_((CompoundTag)lastCraft.m_128469_("lastCraftOutput"));
            ContainerHelper.m_18980_((CompoundTag)lastCraft.m_128469_("lastCraftReagents"), this.lastCraftItems);
            this.lastCraftPatternCount = lastCraft.m_128451_("patterns_count");
            this.lastCraftTier = lastCraft.m_128451_("tier");
            if (lastCraft.m_128441_("faction")) {
                ResourceLocation factionID = new ResourceLocation(lastCraft.m_128461_("faction").toLowerCase());
                this.lastCraftFaction = (IFaction)Registries.Factions.get().getValue(factionID);
            }
            this.lastCraftRecipeID = new ResourceLocation(lastCraft.m_128461_("lastCraftRecipeID"));
            for (ItemStack stack : this.lastCraftItems) {
                Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.m_41728_((ItemStack)is, (ItemStack)stack)).findFirst();
                if (existing.isPresent()) {
                    existing.get().m_41764_(existing.get().m_41613_() + stack.m_41613_());
                    continue;
                }
                this.lastCraftItemsMerged.add((Object)stack.m_41777_());
            }
        }
    }

    public void spawnCraftingParticles() {
        if (!this.m_58904_().m_5776_()) {
            return;
        }
        Random rnd = new Random();
        BlockPos pos = this.m_58899_();
        Vector3f srcPoint = new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.85f, (float)pos.m_123343_() + 0.5f);
        for (int i = 0; i < 10; ++i) {
            Vector3f lightPoint = new Vector3f(srcPoint.x() - 0.2f + rnd.nextFloat() * 0.4f, srcPoint.y(), srcPoint.z() - 0.2f + rnd.nextFloat() * 0.4f);
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())).setScale(0.1f), (double)lightPoint.x(), (double)lightPoint.y(), (double)lightPoint.z(), 0.0, 0.01, 0.0);
        }
        float SPEED = 0.1f;
        float RADIUS = 0.25f;
        int i = 0;
        while ((double)i < (double)this.craftTicks * 1.5) {
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), (double)srcPoint.x(), (double)(srcPoint.y() + 0.4f), (double)srcPoint.z(), (double)SPEED, (double)rnd.nextInt(360), (double)RADIUS);
            ++i;
        }
        if (this.getCraftTicks() > this.getMaxCraftTicks() - 20) {
            RADIUS = 0.6f - rnd.nextFloat() * 0.25f;
            for (i = 0; i < 100; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), (double)srcPoint.x(), (double)(srcPoint.y() + 0.2f), (double)srcPoint.z(), (double)SPEED + rnd.nextGaussian() * (double)0.1f, (double)(-30 + rnd.nextInt(30)), (double)RADIUS);
            }
        }
    }

    private void resolvePendingPatterns() {
        if (this.f_58857_ != null && this.pendingPatterns.size() > 0) {
            for (String s : this.pendingPatterns) {
                ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe(this.m_58904_(), new ResourceLocation(s));
                if (p == null) continue;
                this.addedPatterns.add(p);
            }
            this.pendingPatterns.clear();
        }
    }

    private void setCrafting(boolean crafting) {
        this.crafting = crafting;
        if (!this.m_58904_().m_5776_() && this.crafting) {
            this.m_58904_().m_5594_(null, this.m_58899_(), SFX.Event.Block.MANAWEAVE_ALTAR_CRAFT, SoundSource.BLOCKS, 1.0f, (float)((double)0.95f + Math.random() * (double)0.05f));
        }
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public int getCraftTicks() {
        return this.craftTicks;
    }

    public int getMaxCraftTicks() {
        return 85;
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, ManaweavingAltarTile tile) {
        if (!tile.crafting) {
            return;
        }
        tile.spawnCraftingParticles();
        ++tile.craftTicks;
        if (tile.craftTicks >= tile.getMaxCraftTicks()) {
            tile.setCrafting(false);
            tile.craftTicks = 0;
            if (!tile.m_58904_().m_5776_()) {
                if (!EventDispatcher.DispatchManaweaveCrafting(tile.__cachedRecipe, tile.__cachedRecipeOutput, tile.getCrafter())) {
                    level.m_7260_(tile.m_58899_(), tile.m_58900_(), tile.m_58900_(), 2);
                    return;
                }
                if (tile.copyNBT) {
                    CompoundTag nbt = tile.__cachedRecipeOutput.m_41784_();
                    for (ItemStack stack : tile.inventoryItems) {
                        if (!stack.m_41782_()) continue;
                        nbt.m_128391_(stack.m_41783_());
                    }
                }
                tile.copyCraftInputToLastCraft();
                ServerMessageDispatcher.sendParticleEffect((ResourceKey<Level>)tile.m_58904_().m_46472_(), 32.0f, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.3f, (float)pos.m_123343_() + 0.5f, SpawnParticleEffectMessage.ParticleTypes.MANAWEAVE_CRAFT_COMPLETE);
            }
            tile.pendingPatterns.clear();
            tile.addedPatterns.clear();
            tile.m_6211_();
            Player crafter = tile.getCrafter();
            if (crafter != null & crafter instanceof ServerPlayer) {
                MutableBoolean factionMatch = new MutableBoolean(false);
                crafter.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                    if (p.getAlliedFaction() != null && tile.__cachedRecipe.getFactionRequirement() == p.getAlliedFaction()) {
                        factionMatch.setTrue();
                    }
                });
                CustomAdvancementTriggers.MANAWEAVE_CRAFT.trigger((ServerPlayer)crafter, tile.__cachedRecipeOutput, factionMatch.booleanValue());
            }
            if (tile.__cachedRecipe != null) {
                tile.lastCraftRecipeID = tile.__cachedRecipe.m_6423_();
                tile._lastCraftRecipe = tile.__cachedRecipe;
                int count = 1;
                ArrayList<ItemStack> byproducts = tile.__cachedRecipe.rollByproducts(level.m_213780_());
                for (ItemStack byproduct : byproducts) {
                    if (count++ < 9) {
                        tile.m_6836_(count, byproduct);
                        continue;
                    }
                    InventoryUtilities.DropItemAt(byproduct, Vec3.m_82512_((Vec3i)pos.m_7494_()), level, true);
                }
            }
            tile.setOutputItem(tile.__cachedRecipeOutput);
        }
    }

    private void setOutputItem(ItemStack stack) {
        if (!this.m_58904_().m_5776_()) {
            this.ignoreQtyLimit = true;
            if (stack != null) {
                this.m_6836_(0, stack);
            }
            this.ignoreQtyLimit = false;
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public void setPlayerReference(Player player) {
        this.__crafter = player;
        this.__crafterID = player.m_20148_();
    }

    private boolean checkReCraftReagents(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        MutableBoolean progressionMet = new MutableBoolean(false);
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getTier() < this.lastCraftTier) {
                player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.lowtier"));
            } else if (this.lastCraftFaction != null && p.getAlliedFaction() != this.lastCraftFaction) {
                player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.wrongfaction"));
            } else {
                progressionMet.setTrue();
            }
        });
        if (!progressionMet.booleanValue()) {
            return false;
        }
        float mana = this.getReCraftManaCost();
        MutableBoolean enoughMana = new MutableBoolean(true);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> enoughMana.setValue(m.getCastingResource().hasEnoughAbsolute((LivingEntity)player, mana)));
        if (!enoughMana.getValue().booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.missing_mana"));
            return false;
        }
        MutableBoolean reagentsPresent = new MutableBoolean(true);
        this.lastCraftItemsMerged.forEach(stack -> {
            if (!stack.m_41619_() && !InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_()))) {
                reagentsPresent.setFalse();
            }
        });
        if (!reagentsPresent.getValue().booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"gui.mna.recipe.missing_items"));
            return false;
        }
        return true;
    }

    private void consumeReCraftReagents(Player player) {
        if (player.m_7500_()) {
            return;
        }
        float mana = this.getReCraftManaCost();
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().consume((LivingEntity)player, mana));
        this.lastCraftItemsMerged.forEach(stack -> InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandler)new InvWrapper((Container)player.m_150109_())));
    }

    private void copyCraftInputToLastCraft() {
        this.lastCraftItems.clear();
        this.lastCraftItemsMerged.clear();
        for (ItemStack stack : this.inventoryItems) {
            this.lastCraftItems.add((Object)stack.m_41777_());
            Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.m_150942_((ItemStack)is, (ItemStack)stack)).findFirst();
            if (existing.isPresent()) {
                existing.get().m_41764_(existing.get().m_41613_() + stack.m_41613_());
                continue;
            }
            this.lastCraftItemsMerged.add((Object)stack.m_41777_());
        }
        this.lastCraftPatternCount = this.addedPatterns.size();
        this.lastCraftOutput = this.__cachedRecipeOutput.m_41777_();
    }

    public boolean reCraft(Player player) {
        if (this.addedPatterns.size() != 0 || !this.m_7983_() || this.m_58904_().m_5776_()) {
            return false;
        }
        if (this.checkReCraftReagents(player)) {
            ServerMessageDispatcher.sendParticleEffect((ResourceKey<Level>)this.m_58904_().m_46472_(), 32.0f, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 1.1f, (float)this.m_58899_().m_123343_() + 0.5f, SpawnParticleEffectMessage.ParticleTypes.MANAWEAVE_CRAFT_COMPLETE);
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
            this.setPlayerReference(player);
            this.consumeReCraftReagents(player);
            ItemStack output = this.lastCraftOutput.m_41777_();
            if (player instanceof ServerPlayer) {
                MutableBoolean factionMatch = new MutableBoolean(false);
                player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                    if (p.getAlliedFaction() != null && this.__cachedRecipe != null && this.__cachedRecipe.getFactionRequirement() == p.getAlliedFaction()) {
                        factionMatch.setTrue();
                    }
                });
                CustomAdvancementTriggers.MANAWEAVE_CRAFT.trigger((ServerPlayer)player, output, factionMatch.booleanValue());
            }
            boolean sendUpdate = false;
            if (!player.m_150109_().m_36054_(output)) {
                this.setOutputItem(output);
                sendUpdate = true;
            }
            if (this._lastCraftRecipe == null && this.lastCraftRecipeID != null) {
                this.f_58857_.m_7465_().m_44043_(this.lastCraftRecipeID).ifPresent(recipe -> {
                    if (recipe instanceof ManaweavingRecipe) {
                        ManaweavingRecipe mwRecipe;
                        this._lastCraftRecipe = mwRecipe = (ManaweavingRecipe)recipe;
                    }
                });
            }
            if (this._lastCraftRecipe != null) {
                int count = 1;
                ArrayList<ItemStack> byproducts = this._lastCraftRecipe.rollByproducts(this.f_58857_.m_213780_());
                for (ItemStack byproduct : byproducts) {
                    if (player.m_150109_().m_36054_(byproduct)) continue;
                    if (count++ < 9) {
                        this.m_6836_(count, byproduct);
                        sendUpdate = true;
                        continue;
                    }
                    InventoryUtilities.DropItemAt(byproduct, Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_()), this.f_58857_, true);
                }
            }
            if (sendUpdate) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
            return true;
        }
        return false;
    }

    public ItemStack getReCraftOutput() {
        return this.lastCraftOutput;
    }

    @Nullable
    public IFaction getLastCraftFaction() {
        return this.lastCraftFaction;
    }

    public int getLastCraftTier() {
        return this.lastCraftTier;
    }

    public int getLastCraftPatternCount() {
        return this.lastCraftPatternCount;
    }

    public void setReCraftRecipe(ItemStack output, List<ItemStack> inputs, IFaction faction, int tier, int patternCount) {
        this.lastCraftOutput = output;
        this.lastCraftItems.clear();
        this.lastCraftItemsMerged.clear();
        for (ItemStack stack : inputs) {
            this.lastCraftItems.add((Object)stack.m_41777_());
            Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.m_41728_((ItemStack)is, (ItemStack)stack)).findFirst();
            if (existing.isPresent()) {
                existing.get().m_41764_(existing.get().m_41613_() + stack.m_41613_());
                continue;
            }
            this.lastCraftItemsMerged.add((Object)stack.m_41777_());
        }
        this.lastCraftFaction = faction;
        this.lastCraftTier = tier;
        this.lastCraftPatternCount = patternCount;
    }

    public int getReCraftManaCost() {
        return this.lastCraftPatternCount * GeneralConfigValues.AverageManaweaveCost;
    }

    public List<ItemStack> getReCraftInput() {
        return this.lastCraftItems.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
    }

    private Player getCrafter() {
        if (this.__crafter == null && this.__crafterID != null) {
            this.__crafter = this.m_58904_().m_46003_(this.__crafterID);
        }
        return this.__crafter;
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return this.getCrafter() != null && this.m_8020_(index).m_41619_() && itemStackIn.m_41613_() == 1;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isCrafting() && this.getCrafter() != null && !this.m_8020_(index).m_41619_() && stack.m_41613_() == 1;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 1.0, 0.0);
    }

    private ItemAndPatternCraftingInventory createCraftingInventory() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (IManaweavePattern p : this.addedPatterns) {
            patterns.add(p.getRegistryId().toString());
        }
        for (String s : this.pendingPatterns) {
            patterns.add(s);
        }
        ItemAndPatternCraftingInventory craftinginventory = new ItemAndPatternCraftingInventory(9, patterns);
        for (int i = 0; i < 9; ++i) {
            craftinginventory.m_6836_(i, this.m_8020_(i));
        }
        return craftinginventory;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.handler == null) {
                this.handler = LazyOptional.of(this::createHandler);
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof ChestBlock)) {
            return new InvWrapper((Container)this);
        }
        Container inv = ChestBlock.m_51511_((ChestBlock)((ChestBlock)state.m_60734_()), (BlockState)state, (Level)this.m_58904_(), (BlockPos)this.m_58899_(), (boolean)true);
        return new InvWrapper((Container)(inv == null ? this : inv));
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.getCrafter() != null) {
            return super.m_7013_(index, stack);
        }
        return false;
    }

    @Override
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }
}

