/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.blocks.tile.IMultiblockDefinition;
import com.mna.api.blocks.tile.MultiblockTile;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.factions.Factions;
import com.mna.recipes.multiblock.MultiblockDefinition;
import com.mna.tools.render.MultiblockRenderer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SanctumTile
extends MultiblockTile {
    private IFaction alignedFaction;

    public SanctumTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.CIRCLE_OF_POWER.get(), pos, state, null);
    }

    public void setFaction(IFaction faction) {
        this.alignedFaction = faction;
    }

    public boolean hasFaction() {
        return this.alignedFaction != null;
    }

    @Override
    protected Optional<IMultiblockDefinition> getDefinition() {
        ResourceLocation recipeId = this.alignedFaction.getSanctumStructure();
        if (!this.hasFaction() || recipeId == null) {
            return Optional.empty();
        }
        if (this._cachedMultiblockRecipe == null) {
            this.m_58904_().m_7465_().m_44043_(recipeId).ifPresent(r -> {
                if (r instanceof MultiblockDefinition) {
                    this._cachedMultiblockRecipe = (MultiblockDefinition)r;
                }
            });
        }
        return Optional.ofNullable(this._cachedMultiblockRecipe);
    }

    public static void ServerTick(Level level, BlockPos pos, BlockState state, SanctumTile tile) {
        MultiblockTile.Tick(level, pos, state, tile);
        if (!tile.m_58904_().m_5776_() && tile.structureMatched && tile.m_58904_().m_46467_() % 300L == 0L) {
            tile.getDefinition().ifPresent(r -> {
                if (tile.alignedFaction == null) {
                    return;
                }
                float sanctumScale = 32.0f;
                int hX = (int)((Math.ceil((float)r.getSize().m_123341_() / 2.0f) + 1.0) * (double)sanctumScale);
                int hZ = (int)((Math.ceil((float)r.getSize().m_123343_() / 2.0f) + 1.0) * (double)sanctumScale);
                AABB bb = new AABB(pos).m_82363_((double)hZ, (double)((float)(r.getSize().m_123342_() + 1) * sanctumScale), (double)hZ).m_82363_((double)(-hX), 0.0, (double)(-hZ));
                List entities = tile.m_58904_().m_45976_(LivingEntity.class, bb);
                if (entities.size() > 0) {
                    entities.forEach(entity -> {
                        if (entity instanceof Player) {
                            entity.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(pr -> {
                                if (pr.getAlliedFaction() != null && (pr.getAlliedFaction() == tile.alignedFaction || pr.getAlliedFaction().isAlliedTo(tile.alignedFaction))) {
                                    entity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.CIRCLE_OF_POWER.get(), 600));
                                } else {
                                    tile.setSacrifice((LivingEntity)entity);
                                }
                            });
                        } else {
                            tile.setSacrifice((LivingEntity)entity);
                        }
                    });
                }
            });
        }
    }

    @Override
    protected boolean advancementSelector(LivingEntity candidate) {
        if (this.alignedFaction == null) {
            return false;
        }
        if (!(candidate instanceof ServerPlayer)) {
            return false;
        }
        IPlayerProgression progression = (IPlayerProgression)candidate.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return false;
        }
        return progression.getAlliedFaction() == this.alignedFaction;
    }

    private void setSacrifice(LivingEntity entity) {
        if (this.alignedFaction == null) {
            return;
        }
        float sacrificeDistance = 9.0f;
        if ((this.alignedFaction == Factions.UNDEAD || this.alignedFaction.isAlliedTo(Factions.UNDEAD)) && entity.m_20183_().m_123331_((Vec3i)this.m_58899_()) <= (double)sacrificeDistance) {
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.SOUL_VULNERABILITY.get(), 100, 0, true, true));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGhostMultiblock() {
        this.getDefinition().ifPresent(r -> {
            BlockPos anchorPos = this.f_58858_.m_7494_();
            MultiblockRenderer.setMultiblock(r, (Component)Component.m_237115_((String)r.m_6423_().toString()), false);
            MultiblockRenderer.anchorTo(anchorPos, Rotation.NONE);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.writeFactionToNBT(data);
        return data;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        this.readFactionFromNBT(nbt);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        this.writeFactionToNBT(data);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readFactionFromNBT(nbt);
    }

    private void writeFactionToNBT(CompoundTag nbt) {
        if (this.alignedFaction != null) {
            nbt.m_128359_("faction", Registries.Factions.get().getKey((Object)this.alignedFaction).toString());
        }
    }

    private void readFactionFromNBT(CompoundTag nbt) {
        if (nbt.m_128441_("faction")) {
            try {
                this.alignedFaction = (IFaction)Registries.Factions.get().getValue(new ResourceLocation(nbt.m_128461_("faction")));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Error parsing aligned faction on Circle of Power, setting to NONE.");
                ManaAndArtifice.LOGGER.error((Object)ex);
                this.alignedFaction = null;
            }
        }
    }

    @Override
    protected BlockPos getMatchOrigin() {
        return this.m_58899_().m_7494_();
    }
}

