/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.blocks.tile.OwnerInformation;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.items.IPhylacteryItem;
import com.mna.blocks.artifice.SeerStoneBlock;
import com.mna.blocks.tileentities.ElementalSentryTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.gui.containers.block.ContainerSeerStone;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemPlayerCharm;
import com.mna.items.runes.ItemRuneMarking;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class SeerStoneTile
extends TileEntityWithInventory
implements MenuProvider,
IForgeBlockEntity,
Consumer<FriendlyByteBuf> {
    private static final int TARGET_TIME = 100;
    private static final Direction[] offsets = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private LivingEntity target = null;
    private int findTargetCounter = 0;
    private int crystalAngle = 0;
    private OwnerInformation ownerInfo;
    public static final int WHITELIST_START = 0;
    public static final int WHITELIST_END = 17;
    public static final int BLACKLIST_START = 18;
    public static final int BLACKLIST_END = 35;
    public static final int MARKING_START = 36;
    public static final int MARKING_END = 37;
    private boolean targetDefaultMobs = true;
    private ArrayList<EntityType<?>> mobWhitelist = new ArrayList();
    private ArrayList<EntityType<?>> mobBlacklist = new ArrayList();
    private ArrayList<UUID> playerTargetWhiteList = new ArrayList();
    private ArrayList<UUID> playerTargetBlackList = new ArrayList();
    private AABB searchArea;

    public SeerStoneTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.SEER_STONE.get(), pos, state, 38);
        this.ownerInfo = new OwnerInformation();
        this.buildFilters();
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, SeerStoneTile blockEntity) {
        if (!blockEntity.hasTarget()) {
            blockEntity.crystalAngle -= 5;
            if (blockEntity.crystalAngle < 0) {
                blockEntity.crystalAngle = 0;
            }
            blockEntity.acquireTarget();
        } else {
            blockEntity.crystalAngle += 5;
            if (blockEntity.crystalAngle > 90) {
                blockEntity.crystalAngle = 90;
            }
            if (blockEntity.getTarget() == null || !blockEntity.getTarget().m_6084_() || blockEntity.isTargetOutsideSearchArea()) {
                blockEntity.clearTarget();
            }
        }
    }

    public boolean hasTarget() {
        block4: {
            block6: {
                block5: {
                    boolean retainTarget;
                    if (this.target == null) break block4;
                    boolean bl = retainTarget = this.target.m_6084_() && this.isMobWhitelisted(this.target);
                    if (this.mobBlacklist.size() > 0) {
                        retainTarget &= !this.isMobBlacklisted(this.target);
                    }
                    if (!retainTarget) break block5;
                    Vec3 vec3 = new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
                    if (!(this.target.m_20238_(vec3) > 2304.0)) break block6;
                }
                this.clearTarget();
                this.acquireTarget(true);
                return false;
            }
            return true;
        }
        return false;
    }

    private void acquireTarget() {
        this.acquireTarget(false);
    }

    private void acquireTarget(boolean force) {
        ++this.findTargetCounter;
        if (this.findTargetCounter >= 100 || force) {
            this.findTargetCounter = 0;
            Vec3 myPos = new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
            List potentialTargets = this.m_58904_().m_6443_(LivingEntity.class, this.searchArea, e -> {
                LivingEntity summoner;
                if (SummonUtils.isSummon((Entity)e) && (summoner = SummonUtils.getSummoner(e)) != null && this.ownerInfo.isFriendlyTo(summoner)) {
                    return false;
                }
                boolean subPredicate = this.isMobWhitelisted((LivingEntity)e);
                if (this.mobBlacklist.size() > 0) {
                    subPredicate &= !this.isMobBlacklisted((LivingEntity)e);
                }
                return e.m_6084_() && subPredicate;
            });
            if (potentialTargets.size() > 0) {
                potentialTargets.sort((o1, o2) -> {
                    Double o1Dist = o1.m_20238_(myPos);
                    Double o2Dist = o2.m_20238_(myPos);
                    return o1Dist.compareTo(o2Dist);
                });
                this.target = (LivingEntity)potentialTargets.get(0);
                for (int i = 0; i < offsets.length; ++i) {
                    BlockEntity be = this.m_58904_().m_7702_(this.m_58899_().m_121955_(offsets[i].m_122436_()));
                    if (be == null || !(be instanceof ElementalSentryTile)) continue;
                    ((ElementalSentryTile)be).forceTarget(this.target);
                }
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SeerStoneBlock.HAS_TARGET, (Comparable)Boolean.valueOf(true)));
                this.m_58904_().m_46590_(this.m_58899_(), this.m_58900_().m_60734_(), Direction.UP);
                this.m_58904_().m_46590_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_(), Direction.UP);
            }
        }
    }

    private boolean defaultPredicate(LivingEntity e) {
        return this.targetDefaultMobs ? e instanceof Enemy || e instanceof FlyingMob : false;
    }

    private boolean isMobWhitelisted(LivingEntity e) {
        boolean subPredicate = this.mobWhitelist.contains(e.m_6095_());
        if (subPredicate && e instanceof Player && this.playerTargetWhiteList.size() > 0) {
            subPredicate = this.playerTargetWhiteList.contains(((Player)e).m_36316_().getId());
        }
        if (this.targetDefaultMobs) {
            subPredicate |= this.defaultPredicate(e);
        }
        return subPredicate;
    }

    private boolean isMobBlacklisted(LivingEntity e) {
        boolean subPredicate = this.mobBlacklist.contains(e.m_6095_());
        if (subPredicate && e instanceof Player && this.playerTargetBlackList.size() > 0) {
            subPredicate = this.playerTargetBlackList.contains(((Player)e).m_36316_().getId());
        }
        return subPredicate;
    }

    public void buildFilters() {
        UUID uuid;
        EntityType<? extends Mob> type;
        ItemStack stack;
        int i;
        this.playerTargetWhiteList.clear();
        this.playerTargetBlackList.clear();
        this.mobWhitelist.clear();
        this.mobBlacklist.clear();
        this.targetDefaultMobs = false;
        for (i = 0; i <= 17; ++i) {
            stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IPhylacteryItem) {
                type = ((IPhylacteryItem)stack.m_41720_()).getContainedEntity(stack);
                if (type != null) {
                    if (this.mobWhitelist.contains(type)) continue;
                    this.mobWhitelist.add(type);
                    continue;
                }
                this.targetDefaultMobs = true;
                continue;
            }
            if (!(stack.m_41720_() instanceof ItemPlayerCharm)) continue;
            uuid = ((ItemPlayerCharm)ItemInit.PLAYER_CHARM.get()).getPlayerUUID(stack);
            if (!this.mobWhitelist.contains(EntityType.f_20532_)) {
                this.mobWhitelist.add(EntityType.f_20532_);
            }
            if (uuid == null) continue;
            this.playerTargetWhiteList.add(uuid);
        }
        if (this.mobWhitelist.isEmpty()) {
            this.targetDefaultMobs = true;
        }
        for (i = 18; i <= 35; ++i) {
            stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IPhylacteryItem) {
                type = ((IPhylacteryItem)stack.m_41720_()).getContainedEntity(stack);
                if (type == null || this.mobBlacklist.contains(type)) continue;
                this.mobBlacklist.add(type);
                continue;
            }
            if (!(stack.m_41720_() instanceof ItemPlayerCharm)) continue;
            uuid = ((ItemPlayerCharm)ItemInit.PLAYER_CHARM.get()).getPlayerUUID(stack);
            if (!this.mobBlacklist.contains(EntityType.f_20532_)) {
                this.mobBlacklist.add(EntityType.f_20532_);
            }
            if (uuid == null) continue;
            this.playerTargetBlackList.add(uuid);
        }
        DirectionalPoint a = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getDirectionalPoint(this.m_8020_(36));
        DirectionalPoint b = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getDirectionalPoint(this.m_8020_(37));
        this.searchArea = a.isValid() && b.isValid() ? MathUtils.createInclusiveBB(a.getPosition(), b.getPosition()) : new AABB(this.m_58899_()).m_82400_(32.0);
    }

    private void clearTarget() {
        this.target = null;
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SeerStoneBlock.HAS_TARGET, (Comparable)Boolean.valueOf(false)));
        this.m_58904_().m_46590_(this.m_58899_(), this.m_58900_().m_60734_(), Direction.UP);
        this.m_58904_().m_46590_(this.m_58899_().m_7495_(), this.m_58900_().m_60734_(), Direction.UP);
    }

    public Entity getTarget() {
        return this.target;
    }

    public void copyTargetTo(ElementalSentryTile other) {
        other.forceTarget(this.target);
    }

    private boolean isTargetOutsideSearchArea() {
        if (this.searchArea == null || this.target == null || !this.target.m_6084_()) {
            return false;
        }
        return !this.searchArea.m_82381_(this.target.m_20191_());
    }

    public int getCrystalAngle() {
        return this.crystalAngle;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.ownerInfo.save(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.ownerInfo.load(compound);
        this.buildFilters();
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Seer Stone");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ContainerSeerStone(id, playerInventory, this);
    }

    @Override
    public void accept(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(this.m_58899_());
    }

    public void setOwner(Player owner) {
        this.ownerInfo.setOwner(owner);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public int[] m_7071_(Direction side) {
        int[] slots = new int[this.m_6643_()];
        for (int i = 0; i < this.m_6643_(); ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean m_7013_(int index, ItemStack itemStackIn) {
        return true;
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

