/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.EldrinAltarTile;
import com.mna.gui.GuiTextures;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.MARenderTypes;
import com.mna.tools.render.ModelUtils;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class EldrinAltarRenderer
implements BlockEntityRenderer<EldrinAltarTile> {
    private final ResourceLocation crystal = RLoc.create("block/eldrin/receiver_crystal");
    private final ItemRenderer itemRenderer;
    private final Minecraft mc = Minecraft.m_91087_();
    private static final Vec3 CrystalOffset = new Vec3(0.5, 1.1, 0.5);
    private static final Vec3 TileBeamOffset = new Vec3(0.0, 0.93, 0.0);
    private final EntityRenderDispatcher renderDispatcher;
    private final Font font;
    private float colorFlash = 255.0f;

    public EldrinAltarRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = this.mc.m_91291_();
        this.renderDispatcher = this.mc.m_91290_();
        this.font = this.mc.f_91062_;
    }

    public void render(EldrinAltarTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack itemstack = tileEntityIn.getDisplayedItem();
        Level world = tileEntityIn.m_58904_();
        BlockPos pos = tileEntityIn.m_58899_();
        BlockState state = tileEntityIn.m_58900_();
        if (!itemstack.m_41619_()) {
            this.renderItem(matrixStackIn, itemstack, combinedLightIn, bufferIn);
        }
        float partialTick = (float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks;
        this.colorFlash = (int)(255.0 - Math.abs(Math.sin(partialTick / 30.0f)) * 200.0);
        Vec3 center = Vec3.m_82528_((Vec3i)pos);
        this.renderFloatingCrystals(tileEntityIn, partialTick, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, world, pos, state, center);
        this.renderCollectedItems(tileEntityIn, partialTick, matrixStackIn, bufferIn, combinedLightIn, center);
        this.renderPowerRequirements(tileEntityIn, partialTick, matrixStackIn, bufferIn, combinedLightIn, center);
        this.renderLastRecipe(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderLastRecipe(EldrinAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.m_7983_() || tileEntityIn.getStage() != EldrinAltarTile.Stage.IDLE || tileEntityIn.getReCraftOutput().m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ == null || mc.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)mc.f_91077_;
        if (!brtr.m_82425_().equals((Object)tileEntityIn.m_58899_())) {
            return;
        }
        List<ItemStack> itemstacks = tileEntityIn.getReCraftInput();
        HashMap<Affinity, Float> eldrin = tileEntityIn.getReCraftEldrin();
        float scale = 0.15f;
        float xItemStep = 1.0f;
        float xEldrinStep = 1.75f;
        float xItemOffset = (float)(itemstacks.size() - 1) * xItemStep / 2.0f;
        float xEldrinOffset = (float)(eldrin.size() - 1) * xEldrinStep / 2.0f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.6, 0.5);
        matrixStackIn.m_85841_(scale, scale, scale);
        this.renderString(Component.m_237115_((String)"block.mna.manaweaving_altar.repeat").getString(), matrixStackIn, bufferIn, combinedLightIn);
        Object affStr = "";
        for (Affinity aff : eldrin.keySet()) {
            String s = String.format("%.0f", eldrin.get((Object)aff));
            int size = 8;
            StringBuilder sb = new StringBuilder(size);
            for (int i = 0; i < (size - s.length()) / 2; ++i) {
                sb.append(" ");
            }
            sb.append(s);
            while (sb.length() < size) {
                sb.append(" ");
            }
            affStr = (String)affStr + sb.toString();
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, -2.4, 0.0);
        this.renderString((String)affStr, matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(this.renderDispatcher.m_253208_());
        matrixStackIn.m_85837_(0.0, -0.75, 0.0);
        this.itemRenderer.m_269128_(tileEntityIn.getReCraftOutput(), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)mc.f_91073_, 0);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, -0.75, 0.0);
        scale = 0.5f;
        matrixStackIn.m_85841_(scale, scale, scale);
        matrixStackIn.m_252880_(xItemOffset, 0.0f, 0.0f);
        for (int i = 0; i < itemstacks.size(); ++i) {
            ItemStack stack = itemstacks.get(i);
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)mc.f_91073_, 0);
            matrixStackIn.m_252880_(-xItemStep, 0.0f, 0.0f);
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85837_(0.0, -1.35, 0.0);
        matrixStackIn.m_85841_(scale, scale, scale);
        matrixStackIn.m_252880_(xEldrinOffset, 0.0f, 0.0f);
        for (Affinity aff : eldrin.keySet()) {
            ItemStack stack = GuiTextures.affinityIcons.get((Object)aff);
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)mc.f_91073_, 0);
            this.renderString(String.format("%.0f", eldrin.get((Object)aff)), matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.m_252880_(-xEldrinStep, 0.0f, 0.0f);
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    protected void renderString(String text, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        stack.m_252781_(this.renderDispatcher.m_253208_());
        stack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float opacity = 0.25f;
        int textColor = (int)(opacity * 255.0f) << 24;
        float hOffset = -this.font.m_92895_(text) / 2;
        this.font.m_272078_(text, hOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.NORMAL, textColor, packedLight, false);
        this.font.m_272078_(text, hOffset, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight, false);
        stack.m_85849_();
    }

    private void renderFloatingCrystals(EldrinAltarTile tileEntityIn, float partialTick, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Level world, BlockPos pos, BlockState state, Vec3 center) {
        Vec3[] offsets = EldrinAltarTile.crystal_offsets;
        double[] yOffsets = new double[offsets.length];
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.0, 0.5);
        for (int i = 0; i < offsets.length; ++i) {
            yOffsets[i] = Math.sin((double)(partialTick + (float)(i * 20)) * Math.PI / 180.0) / 15.0;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(offsets[i].m_7096_(), 1.0 + offsets[i].m_7098_() + yOffsets[i], offsets[i].m_7094_());
            ModelUtils.renderModel(bufferIn, world, pos, state, this.crystal, matrixStackIn, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85849_();
        int ticksForEachBeam = 5;
        int stageTicks = tileEntityIn.getStageTicks();
        for (int i = 0; i < tileEntityIn.getActiveCrystals().size(); ++i) {
            if (tileEntityIn.getStage() == EldrinAltarTile.Stage.CONSUMING_POWER && tileEntityIn.getStageTicks() < i * ticksForEachBeam) continue;
            EldrinAltarTile.ActiveCrystal e = tileEntityIn.getActiveCrystals().get(i);
            Vec3 crystalPos = CrystalOffset.m_82549_(offsets[e.offsetIndex]).m_82520_(0.0, yOffsets[e.offsetIndex], 0.0);
            Vec3 tilePos = Vec3.m_82512_((Vec3i)e.tilePos).m_82546_(center).m_82549_(TileBeamOffset);
            float minStageTicks = ticksForEachBeam * i;
            float maxStageTicks = minStageTicks + (float)ticksForEachBeam;
            float beamPct = 1.0f;
            if (tileEntityIn.getStage() == EldrinAltarTile.Stage.CONSUMING_POWER) {
                if ((float)stageTicks < minStageTicks) continue;
                beamPct = MathUtils.clamp01(((float)stageTicks + partialTicks) / maxStageTicks);
            }
            if (!(beamPct > 0.0f)) continue;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(tilePos.f_82479_, tilePos.f_82480_, tilePos.f_82481_);
            WorldRenderUtils.renderBeam(world, partialTicks, matrixStackIn, bufferIn, combinedLightIn, tilePos, crystalPos, beamPct, e.affinity.getShiftAffinity().getColor(), 0.05f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
            matrixStackIn.m_85849_();
        }
        if (tileEntityIn.getStage() == EldrinAltarTile.Stage.COMPLETING && tileEntityIn.getStageTicks() > 80) {
            float stagePlusPartial = (float)tileEntityIn.getStageTicks() + partialTicks;
            float pct = MathUtils.clamp01((stagePlusPartial - 80.0f) / 20.0f);
            int alpha = (int)(176.0f * pct);
            float scale = 0.01f + 2.74f * pct;
            Vec3 relativeCenterPos = new Vec3(0.5, 1.5, 0.5);
            for (int i = 0; i < tileEntityIn.getActiveCrystals().size(); ++i) {
                EldrinAltarTile.ActiveCrystal e = tileEntityIn.getActiveCrystals().get(i);
                Vec3 crystalPos = CrystalOffset.m_82549_(offsets[e.offsetIndex]).m_82520_(0.0, yOffsets[e.offsetIndex], 0.0);
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(crystalPos.f_82479_, crystalPos.f_82480_, crystalPos.f_82481_);
                WorldRenderUtils.renderBeam(world, partialTicks, matrixStackIn, bufferIn, combinedLightIn, crystalPos, relativeCenterPos, pct, e.affinity.getShiftAffinity().getColor(), 0.05f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                matrixStackIn.m_85849_();
            }
            int[] innerColor = new int[]{7, 43, 155};
            int[] outerColor = new int[]{20, 40, 150};
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(relativeCenterPos.f_82479_, relativeCenterPos.f_82480_, relativeCenterPos.f_82481_);
            WorldRenderUtils.renderRadiant(stageTicks, matrixStackIn, bufferIn, innerColor, outerColor, alpha, scale, false);
            matrixStackIn.m_85849_();
        }
    }

    private void renderCollectedItems(EldrinAltarTile tileEntityIn, float partialTick, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, Vec3 center) {
        if (tileEntityIn.getStage() != EldrinAltarTile.Stage.CONSUMING_REAGENTS) {
            return;
        }
        float rotation = (float)tileEntityIn.getStageTicks() + partialTick;
        int maxItems = tileEntityIn.getCollectedItems().size() - tileEntityIn.getStageTicks() / 20;
        float yOffset = 0.53f + 0.43f * MathUtils.clamp01((float)tileEntityIn.getStageTicks() / 10.0f);
        for (int i = 0; i < maxItems; ++i) {
            EldrinAltarTile.CollectedItem item = tileEntityIn.getCollectedItems().get(i);
            Vec3 tilePos = Vec3.m_82512_((Vec3i)item.tilePos).m_82546_(center).m_82520_(0.0, (double)yOffset, 0.0);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(tilePos.f_82479_, tilePos.f_82480_, tilePos.f_82481_);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(i % 4 == 0 ? -rotation : rotation));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(i % 2 == 0 ? rotation : -rotation));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(i % 3 == 0 ? -rotation : rotation));
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_269128_(item.stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
            matrixStackIn.m_85849_();
        }
    }

    private void renderItem(PoseStack matrixStackIn, ItemStack itemstack, int combinedLightIn, MultiBufferSource bufferIn) {
        matrixStackIn.m_85836_();
        if (itemstack.m_41720_() instanceof BlockItem) {
            matrixStackIn.m_85837_(0.5, 1.05, 0.5);
        } else {
            matrixStackIn.m_85837_(0.5, 1.0, 0.5);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
        this.itemRenderer.m_269128_(itemstack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
        matrixStackIn.m_85849_();
    }

    private void renderPowerRequirements(EldrinAltarTile tileEntityIn, float partialTick, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, Vec3 center) {
        if (tileEntityIn.getStage() != EldrinAltarTile.Stage.CONSUMING_POWER) {
            return;
        }
        List<Affinity> missingPower = tileEntityIn.getPowerRequirementStatus().entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(e -> (Affinity)((Object)((Object)e.getKey()))).collect(Collectors.toList());
        double xOffset = 0.5;
        double xPadding = 0.2;
        double hOffset = (double)(missingPower.size() - 1) * xOffset + (double)(missingPower.size() - 1) * xPadding;
        Quaternionf cameraRotation = Minecraft.m_91087_().m_91290_().m_253208_();
        Quaternionf badgeRotation = new Quaternionf(0.0f, cameraRotation.y(), 0.0f, cameraRotation.w());
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        matrixStackIn.m_252781_(badgeRotation);
        matrixStackIn.m_85837_(-hOffset / 2.0, 0.0, 0.0);
        missingPower.forEach(e -> {
            this.renderAffinityBadge(matrixStackIn, bufferIn, (Affinity)((Object)e), combinedLightIn);
            matrixStackIn.m_85837_(xOffset + xPadding, 0.0, 0.0);
        });
        matrixStackIn.m_85849_();
    }

    private void renderAffinityBadge(PoseStack matrixStackIn, MultiBufferSource bufferIn, Affinity affinity, int packedLightIn) {
        float scaleFactor = 0.5f;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)GuiTextures.affinityBadges.get((Object)affinity)));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        float nrmV = 1.0f;
        float nrmH = 1.0f;
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV);
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV);
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV);
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV);
        matrixStackIn.m_85849_();
    }

    private void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(255, (int)this.colorFlash, (int)this.colorFlash, 230).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nrmH, nrmV, nrmH).m_5752_();
    }
}

