/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.ManaAndArtifice;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.api.tools.RLoc;
import com.mna.blocks.manaweaving.ManaweavingAltarBlock;
import com.mna.blocks.tileentities.ManaweavingAltarTile;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ManaweavingAltarRenderer
implements BlockEntityRenderer<ManaweavingAltarTile> {
    private static final ResourceLocation SPARKLE_TEXTURE = RLoc.create("textures/particle/sparkle.png");
    private static final ResourceLocation CRYSTAL_A = RLoc.create("block/manaweaving_altar_crystal_a");
    private static final ResourceLocation CRYSTAL_B = RLoc.create("block/manaweaving_altar_crystal_b");
    private static final ResourceLocation CRYSTAL_C = RLoc.create("block/manaweaving_altar_crystal_c");
    private static final RenderType RENDER_TYPE = RenderType.m_110470_((ResourceLocation)SPARKLE_TEXTURE);
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.mc.m_91291_();
    private final EntityRenderDispatcher renderDispatcher = this.mc.m_91290_();
    private final Font font;

    public ManaweavingAltarRenderer(BlockEntityRendererProvider.Context context) {
        this.font = this.mc.f_91062_;
    }

    public void render(ManaweavingAltarTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float yFloatA = (float)Math.sin(((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks) / 40.0f) * 0.01f;
        float yFloatB = (float)Math.sin(((float)(ManaAndArtifice.instance.proxy.getGameTicks() + 40L) + partialTicks) / 40.0f) * 0.01f;
        float yFloatC = (float)Math.sin(((float)(ManaAndArtifice.instance.proxy.getGameTicks() + 80L) + partialTicks) / 40.0f) * 0.01f;
        this.renderModelExtras(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, yFloatA, yFloatB, yFloatC);
        this.renderStacks(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, partialTicks);
        this.renderPatterns(tileEntityIn, matrixStackIn, bufferIn, yFloatA, yFloatB, yFloatC);
        this.renderLastRecipe(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderModelExtras(ManaweavingAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, float yFloatA, float yFloatB, float yFloatC) {
        Level world = tileEntityIn.m_58904_();
        BlockPos pos = tileEntityIn.m_58899_();
        BlockState state = tileEntityIn.m_58900_();
        matrixStackIn.m_85836_();
        switch ((Direction)state.m_61143_((Property)ManaweavingAltarBlock.FACING)) {
            case EAST: {
                matrixStackIn.m_252880_(1.0f, 0.0f, 0.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.m_252880_(1.0f, 0.0f, 1.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                matrixStackIn.m_252880_(0.0f, 0.0f, 1.0f);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, yFloatA, 0.0f);
        ModelUtils.renderModel(bufferIn, world, pos, state, CRYSTAL_A, matrixStackIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, yFloatB, 0.0f);
        ModelUtils.renderModel(bufferIn, world, pos, state, CRYSTAL_B, matrixStackIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.0f, yFloatC, 0.0f);
        ModelUtils.renderModel(bufferIn, world, pos, state, CRYSTAL_C, matrixStackIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    private void renderLastRecipe(ManaweavingAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.m_7983_() || tileEntityIn.getAddedPatterns().size() != 0 || tileEntityIn.getReCraftOutput().m_41619_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ == null || mc.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)mc.f_91077_;
        if (!brtr.m_82425_().equals((Object)tileEntityIn.m_58899_())) {
            return;
        }
        List<ItemStack> itemstacks = tileEntityIn.getReCraftInput();
        float scale = 0.15f;
        float xStep = 1.0f;
        float xOffset = (float)(itemstacks.size() - 1) * xStep / 2.0f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.3, 0.5);
        matrixStackIn.m_85841_(scale, scale, scale);
        this.renderString(Component.m_237115_((String)"block.mna.manaweaving_altar.repeat").getString(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(this.renderDispatcher.m_253208_());
        matrixStackIn.m_85837_(0.0, -0.75, 0.0);
        this.itemRenderer.m_269128_(tileEntityIn.getReCraftOutput(), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)mc.f_91073_, 0);
        matrixStackIn.m_85837_(0.0, -0.75, 0.0);
        scale = 0.5f;
        matrixStackIn.m_85841_(scale, scale, scale);
        matrixStackIn.m_252880_(xOffset, 0.0f, 0.0f);
        for (int i = 0; i < itemstacks.size(); ++i) {
            ItemStack stack = itemstacks.get(i);
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)mc.f_91073_, 0);
            matrixStackIn.m_252880_(-xStep, 0.0f, 0.0f);
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85837_(0.0, -1.95, 0.0);
        this.renderString(Component.m_237110_((String)"block.mna.manaweaving_altar.repeat_mana_cost", (Object[])new Object[]{tileEntityIn.getReCraftManaCost()}).getString(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.m_85849_();
    }

    protected void renderString(String text, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        stack.m_252781_(this.renderDispatcher.m_253208_());
        stack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float opacity = 0.25f;
        int textColor = (int)(opacity * 255.0f) << 24;
        float hOffset = -this.font.m_92895_(text) / 2;
        this.font.m_271703_(text, hOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.NORMAL, textColor, packedLight);
        this.font.m_271703_(text, hOffset, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        stack.m_85849_();
    }

    private void renderStacks(ManaweavingAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, float partialTicks) {
        ItemStack[] itemstacks = tileEntityIn.getDisplayedItems();
        for (int i = 0; i < itemstacks.length; ++i) {
            Random r = new Random((long)i * 1234L);
            if (itemstacks[i].m_41619_()) continue;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 1.3, 0.5);
            Vec3 randomPos = new Vec3(r.nextGaussian() * Math.sin((float)i / 4.5f), r.nextGaussian() * Math.sin((float)i / 4.5f), r.nextGaussian() * Math.sin((float)i / 4.5f)).m_82541_();
            randomPos = randomPos.m_82490_((double)0.3f);
            if (!tileEntityIn.isCrafting()) {
                matrixStackIn.m_85837_(randomPos.m_7096_(), randomPos.m_7098_(), randomPos.m_7094_());
            } else {
                float ringAngle = (float)i * (360.0f / (float)itemstacks.length);
                float craftPct = (float)tileEntityIn.getCraftTicks() / (float)tileEntityIn.getMaxCraftTicks();
                Vec3 ringPos = new Vec3(Math.cos(ringAngle), 0.0, Math.sin(ringAngle)).m_82490_((double)(1.0f - craftPct));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
                if (tileEntityIn.getCraftTicks() < tileEntityIn.getMaxCraftTicks() / 5) {
                    float pct = (float)tileEntityIn.getCraftTicks() / ((float)tileEntityIn.getMaxCraftTicks() / 5.0f);
                    Vec3 lerpPos = MathUtils.lerpVector3d(randomPos, ringPos, pct);
                    matrixStackIn.m_85837_(lerpPos.m_7096_(), lerpPos.m_7098_(), lerpPos.m_7094_());
                } else {
                    matrixStackIn.m_85837_(ringPos.m_7096_(), ringPos.m_7098_(), ringPos.m_7094_());
                }
            }
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
            this.itemRenderer.m_269128_(itemstacks[i], ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
            matrixStackIn.m_85849_();
        }
    }

    private void renderPatterns(ManaweavingAltarTile tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, float yFloatA, float yFloatB, float yFloatC) {
        int count = 7;
        float radius = 0.375f;
        float rotation = 0.0f;
        float rotationBase = 0.0f;
        float[] yOffsets = new float[]{0.8375f, 0.91f, 0.9525f};
        switch ((Direction)tileEntityIn.m_58900_().m_61143_((Property)ManaweavingAltarBlock.FACING)) {
            case SOUTH: {
                rotation = 180.0f;
                rotationBase = 180.0f;
                break;
            }
            case EAST: {
                rotation = 90.0f;
                break;
            }
            case WEST: {
                rotation = -90.0f;
                break;
            }
            default: {
                rotationBase = 180.0f;
            }
        }
        for (IManaweavePattern pattern : tileEntityIn.getAddedPatterns()) {
            float yOffset = count == 1 || count == 7 ? yOffsets[0] + yFloatA : (count == 2 || count == 6 ? yOffsets[1] + yFloatB : yOffsets[2] + yFloatC);
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 0.0f, 0.5f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(rotation));
            matrixStackIn.m_252880_(-0.5f, 0.0f, -0.5f);
            Vector3f vec = new Vector3f(0.0f, yOffset, radius);
            vec.rotate((Quaternionfc)Axis.f_252436_.m_252977_(rotationBase + (float)(45 * count)));
            matrixStackIn.m_252880_(vec.x() + 0.5f, vec.y(), vec.z() + 0.5f);
            this.renderPattern(pattern, matrixStackIn, bufferIn, rotation);
            matrixStackIn.m_85849_();
            if (--count != 4) continue;
            --count;
        }
    }

    private void renderPattern(IManaweavePattern pattern, PoseStack matrixStackIn, MultiBufferSource bufferIn, float rotation) {
        byte[][] points = pattern.get();
        float pointSize = 0.5f;
        float baseScale = 0.03f;
        float offsetX = (float)points.length / 2.0f * pointSize;
        float offsetY = (float)points[0].length / 2.0f * pointSize;
        Quaternionf cameraRotation = Minecraft.m_91087_().m_91290_().m_253208_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.2, 0.0);
        matrixStackIn.m_85841_(baseScale, baseScale, baseScale);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-rotation));
        matrixStackIn.m_252781_(cameraRotation);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RENDER_TYPE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * pointSize;
                float originY = offsetY - (float)i * pointSize;
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 1.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 1.0f, 1.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 1.0f, 0.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 0.0f);
            }
        }
        matrixStackIn.m_85849_();
    }

    private static void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float u, float v) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(109, 227, 220, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

