/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.ManaAndArtifice;
import com.mna.blocks.tileentities.OcculusTile;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class OcculusRenderer
implements BlockEntityRenderer<OcculusTile> {
    private final ResourceLocation interior = new ResourceLocation("mna", "block/occulus_eye_shell_interior");
    private final ResourceLocation frame = new ResourceLocation("mna", "block/occulus_eye_shell");
    private static final Random RANDOM = new Random(31100L);

    public OcculusRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(OcculusTile tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntityIn.m_58904_();
        BlockPos pos = tileEntityIn.m_58899_();
        BlockState state = tileEntityIn.m_58900_();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 teDir = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        Vec3 playerPos = mc.f_91074_.m_20182_();
        Vec3 between = playerPos.m_82546_(teDir);
        double angle = -Math.atan2(between.f_82481_, between.f_82479_) / 2.0 / Math.PI * 360.0 + 90.0;
        Quaternionf eyeRotation = Axis.f_252436_.m_252977_((float)angle);
        matrixStack.m_85836_();
        float translateUp = (float)Math.sin(((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks) / 40.0f) * 0.1f;
        float addedHeight = MathUtils.clamp01(0.5f - (float)(between.m_82553_() / 10.0));
        float finalHeight = addedHeight / 2.0f + translateUp * addedHeight;
        matrixStack.m_252880_(0.5f, finalHeight, 0.5f);
        matrixStack.m_252781_(eyeRotation);
        float colorMod = 0.15f;
        this.renderModelWithRandomColor(matrixStack, bufferIn.m_6299_(RenderType.m_173239_()), world, pos, state, colorMod, combinedLightIn, combinedOverlayIn);
        ModelUtils.renderModel(bufferIn, world, pos, state, this.frame, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
    }

    private void renderModelWithRandomColor(PoseStack stack, VertexConsumer builder, Level world, BlockPos pos, BlockState state, float colorMod, int light, int overlay) {
        float r = (RANDOM.nextFloat() * 0.5f + 0.1f) * colorMod;
        float g = (RANDOM.nextFloat() * 0.5f + 0.4f) * colorMod;
        float b = (RANDOM.nextFloat() * 0.5f + 0.5f) * colorMod;
        ModelUtils.renderModel(builder, world, pos, state, this.interior, stack, new float[]{1.0f, r, g, b}, light, overlay);
    }
}

