/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.api.blocks.tile.pylon.PylonTileBase;
import com.mna.api.tools.RLoc;
import com.mna.tools.render.MARenderTypes;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PylonRenderer
implements BlockEntityRenderer<PylonTileBase> {
    public static final ResourceLocation crystal = RLoc.create("block/eldrin/pylon_crystal");
    public static final ResourceLocation ring = RLoc.create("block/eldrin/pylon_ring");
    public static final ResourceLocation scroll = RLoc.create("block/eldrin/pylon_scroll");
    private final float[] uLookup = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 0.0f, 0.25f, 0.5f, 0.75f, 0.0f, 0.25f, 0.5f, 0.75f, 0.0f, 0.25f, 0.5f, 0.75f};
    private final float[] vLookup = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 0.25f, 0.25f, 0.25f, 0.5f, 0.5f, 0.5f, 0.5f, 0.75f, 0.75f, 0.75f, 0.75f};
    private final int[] defaultActiveColor = new int[]{49, 235, 234};

    public PylonRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PylonTileBase pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        long ticks = pBlockEntity.m_58904_().m_46467_();
        Direction facing = (Direction)pBlockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        int[] color = pBlockEntity.getColor();
        if (color == null || color.length != 3) {
            color = this.defaultActiveColor;
        }
        float powerUpPct = pBlockEntity.getPowerupPct(pPartialTick);
        int[] runeWord = pBlockEntity.getRuneword();
        float runewordPct = Math.min(powerUpPct / 0.5f, 1.0f);
        pPoseStack.m_85836_();
        switch (facing) {
            case EAST: {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                pPoseStack.m_85837_(-0.8, 1.65, 0.75);
                break;
            }
            case WEST: {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                pPoseStack.m_85837_(0.2, 1.65, -0.25);
                break;
            }
            case NORTH: {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                pPoseStack.m_85837_(-0.8, 1.65, -0.25);
                break;
            }
            default: {
                pPoseStack.m_85837_(0.2, 1.65, 0.75);
            }
        }
        this.renderRuneWord(pPoseStack, pBuffer, new ResourceLocation("mna:textures/block/runescribing_table/runes.png"), pPackedLight, color, runeWord, runewordPct);
        ResourceLocation badge = pBlockEntity.getIcon();
        if (badge != null) {
            pPoseStack.m_85837_(0.3, -1.2, 0.07);
            this.renderPotionEffectBadge(pPoseStack, pBuffer, badge, pPackedLight);
        }
        pPoseStack.m_85849_();
        if (powerUpPct > 0.5f) {
            float radiantPct = Math.min((powerUpPct - 0.5f) / 0.25f, 1.0f);
            int[] color2 = color;
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.5, 2.0, 0.5);
            if (powerUpPct > 0.75f) {
                float beamLengthPct = (powerUpPct - 0.75f) / 0.25f;
                WorldRenderUtils.renderBeam(pBlockEntity.m_58904_(), pPartialTick, pPoseStack, pBuffer, pPackedLight, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, (double)pBlockEntity.getClearHeightAbove(), 0.0), beamLengthPct, color2, 0.05f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
            }
            WorldRenderUtils.renderRadiant((float)ticks + pPartialTick, pPoseStack, pBuffer, color, color2, (int)(230.0f * radiantPct), 0.5f, false);
            WorldRenderUtils.renderRadiant((float)(ticks + 1000L) + pPartialTick, pPoseStack, pBuffer, color, color2, (int)(230.0f * radiantPct), 0.5f, false);
            pPoseStack.m_85849_();
        }
    }

    private void renderPotionEffectBadge(PoseStack matrixStackIn, MultiBufferSource bufferIn, ResourceLocation buffTexture, int packedLightIn) {
        float scaleFactor = 0.25f;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)buffTexture));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        float nrmV = 1.0f;
        float nrmH = 1.0f;
        int[] activeColor = new int[]{255, 255, 255};
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, activeColor);
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, activeColor);
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, activeColor);
        this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, activeColor);
        matrixStackIn.m_85849_();
    }

    private void renderRuneWord(PoseStack matrixStackIn, MultiBufferSource bufferIn, ResourceLocation buffTexture, int packedLightIn, int[] color, int[] indices, float powerUpPct) {
        float scaleFactor = 0.2f;
        float xStep = 0.5f;
        float yStep = -0.75f;
        int count = 0;
        int charactersPerLine = 7;
        int numLines = (int)Math.ceil((float)indices.length / (float)charactersPerLine);
        float[] linePcts = new float[numLines];
        float linePctAffect = 1.0f / (float)numLines;
        for (int i = 0; i < numLines; ++i) {
            float powerUpForFullBlue = 1.0f - linePctAffect * (float)i;
            linePcts[i] = powerUpPct > powerUpForFullBlue ? 1.0f : (powerUpPct > powerUpForFullBlue - linePctAffect ? (powerUpPct - powerUpForFullBlue + linePctAffect) / linePctAffect : 0.0f);
        }
        int curLine = 0;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)buffTexture));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index >= 0) {
                this.renderRune(matrixStackIn, vertexBuilder, 0xF000F0, index, linePcts[curLine], color);
            }
            matrixStackIn.m_252880_(xStep, 0.0f, 0.0f);
            if (++count <= 6) continue;
            matrixStackIn.m_252880_((float)(-count) * xStep, yStep, 0.0f);
            count = 0;
            ++curLine;
        }
        matrixStackIn.m_85849_();
    }

    private void renderRune(PoseStack matrixStackIn, VertexConsumer vertexBuilder, int packedLightIn, int index, float colorShiftPct, int[] activeColor) {
        boolean flip;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        boolean bl = flip = (index & 0x10) > 0;
        if ((index &= 0xF) < 0 || index > 15) {
            return;
        }
        float nrmV = 1.0f;
        float nrmH = 1.0f;
        float u = this.uLookup[index];
        float v = this.vLookup[index];
        float u2 = u + 0.25f;
        float v2 = v + 0.25f;
        int[] inactiveColor = new int[]{0, 0, 0};
        if (flip) {
            float tmp = u;
            u = u2;
            u2 = tmp;
        }
        if (colorShiftPct == 1.0f) {
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, u, v2, nrmH, nrmV, activeColor);
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, u2, v2, nrmH, nrmV, activeColor);
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, u2, v, nrmH, nrmV, activeColor);
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, u, v, nrmH, nrmV, activeColor);
        } else if (colorShiftPct == 0.0f) {
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, u, v2, nrmH, nrmV, inactiveColor);
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, u2, v2, nrmH, nrmV, inactiveColor);
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, u2, v, nrmH, nrmV, inactiveColor);
            this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, u, v, nrmH, nrmV, inactiveColor);
        } else {
            if (colorShiftPct > 0.0f) {
                v2 = v + 0.25f * (1.0f - colorShiftPct);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, colorShiftPct, u, v2, nrmH, nrmV, inactiveColor);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, colorShiftPct, u2, v2, nrmH, nrmV, inactiveColor);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, u2, v, nrmH, nrmV, inactiveColor);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, u, v, nrmH, nrmV, inactiveColor);
            }
            if (colorShiftPct < 1.0f) {
                v2 = v + 0.25f;
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, u, v2, nrmH, nrmV, activeColor);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, u2, v2, nrmH, nrmV, activeColor);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, colorShiftPct, u2, v += 0.25f * (1.0f - colorShiftPct), nrmH, nrmV, activeColor);
                this.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, colorShiftPct, u, v, nrmH, nrmV, activeColor);
            }
        }
    }

    private void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] color) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(color[0], color[1], color[2], 230).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nrmH, nrmV, nrmH).m_5752_();
    }
}

