/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.ManaAndArtifice;
import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.SeerStoneTile;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SeerStoneRenderer
implements BlockEntityRenderer<SeerStoneTile> {
    public static final ResourceLocation crystal = RLoc.create("block/seer_stone/crystal");
    public static final ResourceLocation crystal_band = RLoc.create("block/seer_stone/crystal_band");

    public SeerStoneRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SeerStoneTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = tile.m_58904_();
        BlockPos pos = tile.m_58899_();
        BlockState state = tile.m_58900_();
        long ticks = ManaAndArtifice.instance.proxy.getGameTicks();
        double yRot = 0.0;
        Entity target = tile.getTarget();
        if (target != null) {
            Vec3 myPos = Vec3.m_82512_((Vec3i)pos);
            Vec3 targetPos = target.m_146892_();
            double xDelta = targetPos.f_82479_ - myPos.f_82479_;
            double zDelta = targetPos.f_82481_ - myPos.f_82481_;
            yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)zDelta, (double)xDelta) * 57.2957763671875) - 90.0f));
        }
        float angle = MathUtils.clamp((float)tile.getCrystalAngle() + partialTicks, 0.0f, 90.0f);
        float redPct = 1.0f - angle / 90.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.75 + Math.sin(((float)ticks + partialTicks) / 40.0f) * 0.1, 0.5);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(angle));
        if (target != null) {
            matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)yRot));
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(ticks % 360L)));
        VertexConsumer vertexBuilder = bufferIn.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
        ModelUtils.renderModel(vertexBuilder, world, pos, state, crystal, matrixStack, new float[]{1.0f, 1.0f, redPct, redPct}, combinedLightIn, combinedOverlayIn);
        ModelUtils.renderModel(bufferIn, world, pos, state, crystal_band, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
        if (target != null) {
            float scale = 0.2f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.75 + Math.sin(((float)ticks + partialTicks) / 40.0f) * 0.1, 0.5);
            matrixStack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91290_().m_114384_(target, 0.0, 0.25 / (double)scale, 0.0, 0.0f, 0.0f, matrixStack, bufferIn, combinedLightIn);
            matrixStack.m_85849_();
        }
    }
}

