/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers.wizard_lab;

import com.mna.ManaAndArtifice;
import com.mna.blocks.artifice.ArcanaAltarBlock;
import com.mna.blocks.tileentities.models.ArcanaAltarModel;
import com.mna.blocks.tileentities.renderers.wizard_lab.WizardLabRenderer;
import com.mna.blocks.tileentities.wizard_lab.ArcanaAltarTile;
import com.mna.tools.render.MARenderTypes;
import com.mna.tools.render.ModelUtils;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;

public class ArcanaAltarRenderer
extends WizardLabRenderer<ArcanaAltarTile> {
    private final ItemRenderer itemRenderer;
    private final Minecraft mc = Minecraft.m_91087_();

    public ArcanaAltarRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, new ArcanaAltarModel());
        this.itemRenderer = this.mc.m_91291_();
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        ArcanaAltarTile tile = (ArcanaAltarTile)this.getAnimatable();
        for (int i = 0; i < 6; ++i) {
            Vector3f offset = tile.getCandlePos(i, partialTick);
            poseStack.m_85836_();
            poseStack.m_252880_(offset.x(), offset.y(), offset.z());
            ModelUtils.renderModel(bufferSource.m_6299_(RenderType.m_110463_()), tile.m_58904_(), tile.m_58899_(), tile.m_58900_(), i % 2 == 0 ? ArcanaAltarModel.candle_short : ArcanaAltarModel.candle_long, poseStack, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        float beamPct = Math.max(tile.getBeamPct(partialTick), 0.0f);
        float completionPct = Math.max((float)(tile.getCompletionTicks() - 60 - 20) / 20.0f, 0.0f);
        if (tile.isActive() && tile.getState().ordinal() >= ArcanaAltarTile.States.FINALIZING.ordinal()) {
            int[] color = new int[]{30, 60, 170};
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 2.5, 0.0);
            WorldRenderUtils.renderRadiant(tile.m_58904_().m_46467_(), poseStack, bufferSource, color, color, 255, 3.0f - 3.0f * completionPct, false);
            poseStack.m_85849_();
        }
        if (tile.isActive()) {
            Quaternionf cameraRotation = Minecraft.m_91087_().m_91290_().m_253208_();
            Quaternionf orbRotation = new Quaternionf(0.0f, cameraRotation.y(), 0.0f, cameraRotation.w());
            VertexConsumer vertexBuilder = bufferSource.m_6299_(MARenderTypes.ORB_RENDER);
            int[] colors = new int[]{255, 255, 255};
            float orbPct = tile.getItemCollectPct(partialTick) - beamPct;
            for (int i = 0; i < 4; ++i) {
                float rotationDegrees = 90.0f * (float)i;
                poseStack.m_85836_();
                poseStack.m_252781_(orbRotation);
                Direction facing = (Direction)tile.m_58900_().m_61143_((Property)ArcanaAltarBlock.f_54117_);
                switch (facing) {
                    case WEST: {
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        break;
                    }
                }
                poseStack.m_85837_(0.0, 2.5, 0.0);
                poseStack.m_85841_(0.25f * orbPct, 0.25f * orbPct, 0.25f * orbPct);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationDegrees));
                poseStack.m_85837_(0.5, -0.25, 0.0);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                float nrmV = (float)Math.cos((double)(rotationDegrees - 180.0f) * Math.PI / 180.0);
                float nrmH = (float)Math.cos((double)(rotationDegrees - 180.0f - 90.0f) * Math.PI / 180.0);
                PoseStack.Pose matrixstack$entry = poseStack.m_85850_();
                Matrix4f renderMatrix = matrixstack$entry.m_252922_();
                Matrix3f normalMatrix = matrixstack$entry.m_252943_();
                ArcanaAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLight, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, colors);
                ArcanaAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLight, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, colors);
                ArcanaAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLight, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, colors);
                ArcanaAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLight, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, colors);
                poseStack.m_85849_();
            }
            if (tile.getRequestingPattern() != null) {
                Quaternionf patternRotation = Axis.f_252436_.m_252977_(0.0f);
                float scale = 0.3f;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 1.3, 0.0);
                poseStack.m_85841_(scale, scale, scale);
                WorldRenderUtils.renderManaweavePattern(tile.getRequestingPattern(), patternRotation, poseStack, bufferSource, false);
                poseStack.m_85849_();
            } else if (tile.getRequestingStack().size() > 0) {
                int index = (int)(ManaAndArtifice.instance.proxy.getGameTicks() / 20L % (long)tile.getRequestingStack().size());
                ItemStack stack = new ItemStack((ItemLike)tile.getRequestingStack().get(index));
                float bob = (float)Math.sin(((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTick) / 60.0f) / 40.0f;
                float rotation = ManaAndArtifice.instance.proxy.getGameTicks();
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 1.9f + bob, 0.0f);
                poseStack.m_85841_(0.25f, 0.25f, 0.25f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, bufferSource, (Level)this.mc.f_91073_, 0);
                poseStack.m_85849_();
            }
            if (tile.getState() == ArcanaAltarTile.States.FINALIZING) {
                poseStack.m_85836_();
                Vec3 start = Vec3.m_82514_((Vec3i)tile.m_58899_(), (double)1.0);
                Vec3 end = Vec3.m_82514_((Vec3i)tile.m_58899_(), (double)2.5);
                poseStack.m_85837_(0.0, 2.5, 0.0);
                WorldRenderUtils.renderBeam(tile.m_58904_(), partialTick, poseStack, bufferSource, packedLight, end, start, beamPct, new int[]{200, 200, 255}, 255, 0.065f * (1.0f - completionPct), MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                poseStack.m_85849_();
            }
        }
        super.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
    }

    private static void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] rgb) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], 230).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nrmH, nrmV, nrmH).m_5752_();
    }
}

