/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.items.ItemInit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DisenchanterTile
extends WizardLabTile
implements IEldrinConsumerTile {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int INVENTORY_SIZE = 2;
    private float ticksRequired = 100.0f;
    private float powerPerTick = 3.0f;
    private PowerStatus fireConsumeStatus = PowerStatus.NOT_REQUESTING;
    private PowerStatus windConsumeStatus = PowerStatus.NOT_REQUESTING;
    private float firePowerAccum = 0.0f;
    private float windPowerAccum = 0.0f;

    public DisenchanterTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public DisenchanterTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.DISENCHANTER.get(), pos, state, 2);
    }

    @Override
    public boolean canActivate(Player player) {
        boolean baseActivate = this.canContinue();
        if (!baseActivate) {
            return false;
        }
        ItemStack input = this.m_8020_(0);
        if (EnchantmentHelper.m_44831_((ItemStack)input).size() == 0) {
            return false;
        }
        ItemStack output = this.m_8020_(1);
        if (EnchantmentHelper.m_44831_((ItemStack)output).size() > 0) {
            return false;
        }
        return !GeneralConfigValues.DisenchantBlacklist.contains(ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()).toString());
    }

    @Override
    protected boolean canContinue() {
        return this.hasStack(0) && this.hasStack(1) && !GeneralConfigValues.DisenchantBlacklist.contains(ForgeRegistries.ITEMS.getKey((Object)this.m_8020_(0).m_41720_()).toString());
    }

    @Override
    public float getPctComplete() {
        return (float)this.getActiveTicks() / this.ticksRequired;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1);
    }

    @Override
    protected boolean canActiveTick() {
        float amount;
        this.fireConsumeStatus = PowerStatus.NOT_REQUESTING;
        this.windConsumeStatus = PowerStatus.NOT_REQUESTING;
        if (this.firePowerAccum < this.powerPerTick) {
            amount = this.consume(this.getCrafter(), this.m_58899_(), Vec3.m_82512_((Vec3i)this.m_58899_()), Affinity.FIRE, this.powerPerTick);
            this.firePowerAccum += Math.max(amount, 0.0f);
            this.fireConsumeStatus = this.calculatePowerStatus(this.powerPerTick, amount);
        } else if (this.fireConsumeStatus != PowerStatus.SUPPLIED) {
            this.fireConsumeStatus = PowerStatus.SUPPLIED;
        }
        if (this.windPowerAccum < this.powerPerTick) {
            amount = this.consume(this.getCrafter(), this.m_58899_(), Vec3.m_82512_((Vec3i)this.m_58899_()), Affinity.WIND, this.powerPerTick);
            this.windPowerAccum += Math.max(amount, 0.0f);
            this.windConsumeStatus = this.calculatePowerStatus(this.powerPerTick, amount);
        } else if (this.windConsumeStatus != PowerStatus.SUPPLIED) {
            this.windConsumeStatus = PowerStatus.SUPPLIED;
        }
        if (!this.fireConsumeStatus.allowMachineOperation() || !this.windConsumeStatus.allowMachineOperation()) {
            return false;
        }
        this.windPowerAccum = 0.0f;
        this.firePowerAccum = 0.0f;
        if (this.getActiveTicks() == 90 && !this.m_58904_().m_5776_()) {
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Spell.Buff.ARCANE, SoundSource.BLOCKS, 1.0f, (float)(0.95 + Math.random() * (double)0.1f));
        }
        return true;
    }

    @Override
    protected CompoundTag getMeta() {
        CompoundTag tag = new CompoundTag();
        this.writePowerConsumeStatus(this.fireConsumeStatus, tag, "firePowerStatus");
        tag.m_128350_("firePowerAccum", this.firePowerAccum);
        this.writePowerConsumeStatus(this.windConsumeStatus, tag, "windPowerStatus");
        tag.m_128350_("windPowerAccum", this.windPowerAccum);
        return tag;
    }

    @Override
    protected void loadMeta(CompoundTag tag) {
        this.fireConsumeStatus = this.readPowerConsumeStatus(tag, "firePowerStatus");
        this.windConsumeStatus = this.readPowerConsumeStatus(tag, "windPowerStatus");
        if (tag.m_128441_("firePowerAccum")) {
            this.firePowerAccum = tag.m_128457_("firePowerAccum");
        }
        if (tag.m_128441_("windPowerAccum")) {
            this.windPowerAccum = tag.m_128457_("windPowerAccum");
        }
    }

    @Override
    protected void onComplete() {
        Player crafter;
        ListTag chants;
        ItemStack input = this.m_8020_(0);
        ItemStack output = this.m_8020_(1);
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)input);
        int indexToMove = (int)((double)enchantments.size() * Math.random());
        enchantments.entrySet().stream().skip(indexToMove).findFirst().ifPresent(e -> {
            HashMap<Enchantment, Integer> moved = new HashMap<Enchantment, Integer>();
            moved.put((Enchantment)e.getKey(), (Integer)e.getValue());
            EnchantmentHelper.m_44865_(moved, (ItemStack)output);
            enchantments.remove(e.getKey());
        });
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)input);
        if (input.m_41720_() instanceof EnchantedBookItem && input.m_41782_() && (chants = input.m_41783_().m_128437_("StoredEnchantments", 10)).size() == 1) {
            this.m_6836_(0, new ItemStack((ItemLike)Items.f_42517_));
        }
        if (this.getCrafter() != null && !this.m_58904_().m_5776_() && (crafter = this.getCrafter()) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(crafter, ProgressionEventIDs.REMOVE_ENCHANTMENT));
            if (crafter instanceof ServerPlayer) {
                CustomAdvancementTriggers.DISENCHANT.trigger((ServerPlayer)crafter, output);
            }
        }
    }

    @Override
    protected void onDeactivated() {
        this.fireConsumeStatus = PowerStatus.NOT_REQUESTING;
        this.windConsumeStatus = PowerStatus.NOT_REQUESTING;
    }

    @Override
    public int getXPCost(Player crafter) {
        return 100;
    }

    @Override
    protected void tick() {
        super.tick();
        if (this.m_58904_().m_5776_()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        if (this.isActive()) {
            int i;
            Random random = new Random();
            float radius = 1.25f - this.getPctComplete();
            Vec3 pos = Vec3.m_82514_((Vec3i)this.m_58899_(), (double)2.0);
            Vec3 offset = new Vec3(random.nextGaussian(), random.nextGaussian(), random.nextGaussian()).m_82541_().m_82490_((double)radius);
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_LERP.get())), pos.f_82479_ + offset.f_82479_, pos.f_82480_ + offset.f_82480_, pos.f_82481_ + offset.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
            int numGlows = (int)(5.0f * this.getPctComplete());
            for (i = 0; i < numGlows; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get())), pos.f_82479_ + offset.f_82479_, pos.f_82480_ + offset.f_82480_, pos.f_82481_ + offset.f_82481_, 0.0, 0.0, 0.0);
            }
            if ((double)this.getPctComplete() > 0.95) {
                for (i = 0; i < 150; ++i) {
                    this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), pos.m_7096_(), pos.m_7098_() - 0.8, pos.m_7094_(), -0.5 + Math.random(), 0.01, -0.5 + Math.random());
                }
            }
        }
    }

    @Override
    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        HashMap<Affinity, PowerStatus> reqs = new HashMap<Affinity, PowerStatus>();
        reqs.put(Affinity.FIRE, this.fireConsumeStatus);
        reqs.put(Affinity.WIND, this.windConsumeStatus);
        return reqs;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends WizardLabTile> state) {
        if (this.isActive()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.laboratory_disenchantment_armature.active"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.laboratory_disenchantment_armature.idle"));
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN || side == Direction.UP) {
            return new int[]{1};
        }
        return new int[]{0, 1};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isActive();
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        switch (index) {
            case 0: {
                return this.m_8020_(index).m_41619_() && EnchantmentHelper.m_44831_((ItemStack)stack).size() > 0;
            }
            case 1: {
                return this.m_8020_(index).m_41619_() && stack.m_41720_() == ItemInit.RUNE_PROJECTION.get();
            }
        }
        return false;
    }
}

